/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPMOpFailureException;
import com.lucent.ra.nms.backend.LEDSSPortMaster;
import com.lucent.ra.nms.backend.LEDSSPortMaster_RI;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEStatusManager;
import com.lucent.ra.nms.util.LEUUEncoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class LETftpUpgrade {
    public static final int TIMEOUT = 120000;
    public static final int BLOCK_COUNT = 4;
    public static final short WRITESIZE = 256;
    public static final String DATAFILE_START = "file ";
    public static final String DATAFILE_END = "end";
    LEStatusManager m_status;
    LEDSSPortMaster m_dss;
    BufferedReader m_reader;
    byte[] m_send = new byte[256];
    byte[] m_decode = new byte[45];
    String m_file;
    short m_count;
    int m_blocks;
    int m_filesize;

    public static boolean IsTftpFile(File file) throws IOException {
        boolean istftp = true;
        FileInputStream fis = new FileInputStream(file);
        int i = 0;
        while (istftp && i < 512) {
            int ch = fis.read();
            istftp = LETftpUpgrade.IsPrintable(ch);
            ++i;
        }
        return istftp;
    }

    public static boolean IsPrintable(int ch) {
        return ch == 10 || ch == 13 || ch == 9 || ch == 10 || ch == 13 || ch > 31 && ch < 127;
    }

    public LETftpUpgrade(LEDSSPortMaster dss, BufferedReader reader, LEStatusManager status) {
        this.m_dss = dss;
        this.m_reader = reader;
        this.m_status = status;
    }

    public void doUpgrade() throws LEDSSException {
        this.m_dss.startUpgrade();
        boolean data = false;
        try {
            String line = this.m_reader.readLine();
            while (line != null) {
                int len;
                if (data) {
                    if (line.startsWith(DATAFILE_END)) {
                        this.flush();
                        this.send((byte)6, (short)0, this.m_send);
                        LEDebug.getLog().logln(40, "EOF: " + this.m_file + " " + this.m_filesize + " bytes");
                        this.m_status.setStatus("Finished file " + this.m_file, 0);
                        data = false;
                    } else {
                        len = LEUUEncoder.UUDecode(line, this.m_decode);
                        this.queue(this.m_decode, len);
                    }
                } else {
                    len = line.length();
                    char ch = len > 0 ? line.charAt(0) : (char)'\u0000';
                    if (ch == '#' || ch == '!') {
                        String comment = line.substring(1);
                        if (comment.length() > 0) {
                            this.m_status.setStatus(comment);
                        }
                        LEDebug.getLog().logln(40, "Comment: " + comment);
                    } else if (line.startsWith(DATAFILE_START)) {
                        int start = DATAFILE_START.length();
                        int end = line.length();
                        short index = 0;
                        int i = start;
                        while (i < end) {
                            short s = index;
                            index = (short)(s + 1);
                            this.m_decode[s] = (byte)line.charAt(i);
                            ++i;
                        }
                        short s = index;
                        index = (short)(s + 1);
                        this.m_decode[s] = 0;
                        this.send((byte)5, index, this.m_decode);
                        this.m_file = line.substring(start);
                        LEDebug.getLog().logln(40, line);
                        this.m_status.setStatus("Downloading file " + this.m_file);
                        data = true;
                        this.m_blocks = 0;
                        this.m_filesize = 0;
                    } else if (len > 0) {
                        this.m_status.setStatus(line);
                        LEDebug.getLog().logln(40, "Command: " + line);
                        this.m_dss.execute(line, 120000);
                    }
                }
                line = this.m_reader.readLine();
            }
            if (data) {
                this.flush();
                this.send((byte)6, (short)0, this.m_send);
                throw new LEDSSException("Upgrade file missing end statement");
            }
        }
        catch (LEDSSException e) {
            this.m_dss.stopUpgrade();
            throw e;
        }
        catch (IOException e) {
            LEDebug.getLog().logln(20, e);
            String msg = "Upgrade failed";
            if (e.getMessage() != null) {
                msg = String.valueOf(msg) + ": " + e.getMessage();
            }
            this.m_dss.stopUpgrade();
            throw new LEDSSException(e, msg);
        }
        this.m_dss.stopUpgrade();
    }

    void queue(byte[] data, int len) throws LEDSSException, IOException {
        LEDebug.getLog().logln(40, "Queue'ing more data: " + len);
        if (this.m_count + len > 256) {
            ++this.m_blocks;
            if (this.m_blocks % 4 == 0) {
                this.m_status.setStatus(this.m_blocks / 4);
            }
            short remainder = (short)(this.m_count + len - 256);
            System.arraycopy(data, 0, this.m_send, this.m_count, 256 - this.m_count);
            this.send((byte)6, (short)256, this.m_send);
            System.arraycopy(data, 256 - this.m_count, this.m_send, 0, remainder);
            this.m_count = remainder;
        } else {
            System.arraycopy(data, 0, this.m_send, this.m_count, len);
            this.m_count = (short)(this.m_count + len);
        }
        this.m_filesize += len;
    }

    void flush() throws LEDSSException, IOException {
        if (this.m_count > 0) {
            this.send((byte)6, this.m_count, this.m_send);
        }
        this.m_count = 0;
    }

    void send(byte cmd, short len, byte[] data) throws LEDSSException, IOException {
        LEDebug.getLog().logln(40, "Sending " + LEDSSPortMaster_RI.GetOpCodeString(cmd) + " Length: " + Integer.toString(len) + " bytes");
        LESendResponse resp = this.m_dss.send(cmd, len, data, false, 120000);
        if (!resp.successful()) {
            LEDebug.getLog().logln(40, "TFTP Upgrade: Data Send Failed");
            throw new LEDSSPMOpFailureException("Data Send Failed: " + LEDSSPortMaster_RI.GetOpCodeString(cmd));
        }
        LEDebug.getLog().logln(40, "TFTP Upgrade: Data Send Succeeded");
    }
}

