/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEBGPPeer;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEBGPPeers
extends LETable {
    public LEBGPPeers(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEBGPPeers config = new LEBGPPeers(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String name, String local, String asn) {
        LEVector errors = null;
        StringBuffer cmdbuf = new StringBuffer(30);
        cmdbuf.append("add ");
        cmdbuf.append("bgp peer ");
        cmdbuf.append(local);
        cmdbuf.append(" ");
        cmdbuf.append(name);
        cmdbuf.append(" ");
        cmdbuf.append(asn);
        LEPMCommand ret = this.m_facade.execute(cmdbuf.toString());
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("bgp peer", name);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEBGPPeer(this.m_facade, key);
    }
}

