/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDLCI;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEDLCITable
extends LETable {
    String m_owner;
    String m_type;

    public LEDLCITable(LEConnectionFacade facade, String board, String owner, String type) {
        super(facade, board);
        this.m_owner = owner;
        this.m_type = type;
    }

    public Object clone() {
        LEDLCITable config = new LEDLCITable(this.m_facade, this.m_board, this.m_owner, this.m_type);
        config.copy(this);
        return config;
    }

    public LEVector add(String number, String address) {
        LEVector errors = null;
        LEPMCommand ret = this.setView();
        if (ret == null || ret.getStatus()) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("add ");
            buf.append(this.m_type);
            buf.append(" ");
            buf.append(this.m_owner);
            buf.append(" ");
            buf.append(number);
            buf.append(" ");
            buf.append(address);
            ret = this.m_facade.execute(buf.toString());
            if (ret.getStatus()) {
                ret = this.m_facade.execute("save all");
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String number) {
        LEVector errors = null;
        LEDLCI dlci = (LEDLCI)this.get(number);
        if (!(dlci instanceof LEDLCI)) {
            return errors;
        }
        LEPMCommand ret = this.setView();
        if (ret == null || ret.getStatus()) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("delete ");
            buf.append(this.m_type);
            buf.append(" ");
            buf.append(this.m_owner);
            buf.append(" ");
            buf.append(number);
            ret = this.m_facade.execute(buf.toString());
            if (ret.getStatus()) {
                this.remove(number);
                ret = this.m_facade.execute("save all");
                if (!ret.getStatus()) {
                    this.refresh();
                }
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        LEDLCI dlci = (LEDLCI)this.get(key);
        if (dlci == null) {
            return false;
        }
        String address = (String)dlci.get("address");
        if (address == null) {
            return false;
        }
        this.makeViewCommand(cmds);
        StringBuffer buf = new StringBuffer(100);
        buf.append("add ");
        buf.append(this.m_type);
        buf.append(" ");
        buf.append(this.m_owner);
        buf.append(" ");
        buf.append(key);
        buf.append(" ");
        buf.append(address);
        cmds.addElement(new String(buf));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        this.makeViewCommand(cmds);
        StringBuffer buf = new StringBuffer(100);
        buf.append("delete ");
        buf.append(this.m_type);
        buf.append(" ");
        buf.append(this.m_owner);
        buf.append(" ");
        buf.append(key);
        cmds.addElement(new String(buf));
        return true;
    }

    LEConfig createConfig(String key) {
        LEDLCI dlci = new LEDLCI(this.m_facade, key);
        return dlci;
    }
}

