/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEIPPool;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEVector;

public class LEIPPools
extends LETable {
    public LEIPPools(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEIPPools config = new LEIPPools(this.m_facade);
        config.copy(this);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("ippool", name);
        LEPMCommand ret = this.m_facade.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
            }
            this.refresh();
        } else {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        StringBuffer cmd = new StringBuffer();
        cmd.append("delete ippool ");
        cmd.append(name);
        cmd.append(" all");
        LEPMCommand ret = this.m_facade.execute(cmd.toString());
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_facade.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        } else {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEIPPool(this.m_facade, key);
    }

    boolean getChangedCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getChangedCommands(cmds);
        if (gen) {
            this.removeResets(cmds, start);
        }
        return gen;
    }

    boolean getAllCommands(LEVector cmds) {
        int start = cmds.size();
        boolean gen = super.getAllCommands(cmds);
        if (gen) {
            this.removeResets(cmds, start);
        }
        return gen;
    }

    void removeResets(LEVector cmds, int start) {
        int end = cmds.size();
        int reboot = -1;
        int i = start;
        while (i < end) {
            String cmd = (String)cmds.elementAt(i);
            if (cmd.equals("reset ippool")) {
                if (reboot > 0) {
                    cmds.removeElementAt(reboot);
                    --end;
                }
                reboot = --i;
            }
            ++i;
        }
    }

    boolean generateAddCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeAddCommand("ippool", key));
        return true;
    }

    boolean generateDeleteCommand(String key, LEVector cmds) {
        cmds.addElement(this.makeDeleteCommand("ippool", key));
        return true;
    }
}

