/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEIPSecProfileRule
extends LEConfig {
    public static final String POLICY_FILTER = "505";
    public static final String STATIC_SA = "506";
    public static final int KEY_COUNT = 2;
    static String[] s_keys = null;
    String m_name;
    String m_number;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[2];
            int i = 0;
            LEIPSecProfileRule.s_keys[i++] = POLICY_FILTER;
            LEIPSecProfileRule.s_keys[i++] = STATIC_SA;
        }
        return s_keys;
    }

    public LEIPSecProfileRule(LEConnectionFacade facade, String name, String number) {
        super(facade);
        this.m_name = name;
        this.m_number = number;
        this.m_tag = "sec-profile " + this.m_name + " " + this.m_number;
    }

    public Object clone() {
        LEIPSecProfileRule config = new LEIPSecProfileRule(this.m_facade, this.m_name, this.m_number);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(STATIC_SA)) {
            this.makeSetCommand(cmds, this.m_tag, STATIC_SA, "static-sa");
        }
        if (allCmds || keys.contains(POLICY_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, POLICY_FILTER, "policy-filter");
        }
        return cmds.size() > start;
    }
}

