/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEL2TP
extends LEConfig {
    public static final String TYPE = "495";
    public static final String AUTH_REMOTE = "507";
    public static final String CHOOSE_RANDOM = "508";
    public static final String ID_FOR_HOST = "479";
    public static final String SECRET = "l2tp-secret";
    public static final int KEY_COUNT = 5;
    static String[] s_keys = null;
    boolean m_secretFetched = false;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[5];
            LEL2TP.s_keys[0] = TYPE;
            LEL2TP.s_keys[1] = AUTH_REMOTE;
            LEL2TP.s_keys[2] = CHOOSE_RANDOM;
            LEL2TP.s_keys[3] = ID_FOR_HOST;
            LEL2TP.s_keys[4] = SECRET;
        }
        return s_keys;
    }

    public LEL2TP(LEConnectionFacade facade, String board, String key) {
        super(facade, board, key);
    }

    public LEL2TP(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LEL2TP config = new LEL2TP(this.m_facade, this.m_board, this.m_fetchKey);
        config.copy(this);
        return config;
    }

    void setSecret(String secret) {
        this.m_secretFetched = true;
        this.setField(SECRET, secret);
    }

    public boolean requiresReboot(String key) {
        return key.equals(TYPE);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String temp;
        int start = cmds.size();
        boolean allCmds = keys == null;
        boolean reboot = false;
        if ((allCmds || keys.contains(TYPE)) && (temp = (String)this.get(TYPE)) != null) {
            StringBuffer cmdbuf = new StringBuffer("set ");
            cmdbuf.append("l2tp ");
            if (temp.equals("disable")) {
                cmdbuf.append(temp);
            } else if (temp.equals("no-config")) {
                cmdbuf.append(temp);
            } else {
                cmdbuf.append("enable ");
                cmdbuf.append(temp);
            }
            cmds.add(cmdbuf.toString());
            reboot = true;
        }
        if (allCmds || keys.contains(AUTH_REMOTE)) {
            this.makeSetCommand(cmds, "l2tp", AUTH_REMOTE, "authenticate-remote");
        }
        if (allCmds || keys.contains(CHOOSE_RANDOM)) {
            this.makeSetCommand(cmds, "l2tp", CHOOSE_RANDOM, "choose-random-tunnel-endpoint");
        }
        if (allCmds || keys.contains(ID_FOR_HOST)) {
            this.makeSetCommand(cmds, "l2tp", ID_FOR_HOST, "id-for-host");
        }
        if (allCmds && this.m_secretFetched) {
            this.makeSetCommand(cmds, "l2tp", SECRET, "secret");
        } else if (!allCmds && keys.contains(SECRET)) {
            this.makeSetCommand(cmds, "l2tp", SECRET, "secret");
        }
        if (reboot) {
            cmds.addElement("save all");
            cmds.addElement("reboot");
        }
        return cmds.size() > start;
    }
}

