/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LENetworkRanges;
import com.lucent.ra.nms.util.LEVector;

public class LEOSPFArea
extends LEConfig {
    public static final String AREA_TYPE = "AreaType";
    public static final String AUTH_ID = "AuthID";
    public static final String AUTH_KEY = "AuthKey";
    public static final String AUTH_TYPE = "AuthType";
    public static final String NETWORK_RANGES = "range";
    public static final String PASSWORD = "password";
    public static final String STUB_COST = "stub-default-cost";
    public static final int KEY_COUNT = 7;
    public static final String OSPF_AREA_TAG = "ospf area ";
    public static final String RESET = "reset ospf";
    public static final String AUTH_MD5 = "md5";
    public static final String AUTH_NONE = "none";
    public static final String AUTH_PASSWORD = "password";
    public static final String EXTERNAL = "external";
    public static final String NSSA = "nssa";
    public static final String STUB = "stub";
    static String[] s_keys = null;
    String m_name;
    String m_tag;
    boolean m_reset;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[7];
            int i = 0;
            LEOSPFArea.s_keys[i++] = AREA_TYPE;
            LEOSPFArea.s_keys[i++] = AUTH_ID;
            LEOSPFArea.s_keys[i++] = AUTH_KEY;
            LEOSPFArea.s_keys[i++] = AUTH_TYPE;
            LEOSPFArea.s_keys[i++] = NETWORK_RANGES;
            LEOSPFArea.s_keys[i++] = "password";
            LEOSPFArea.s_keys[i++] = STUB_COST;
        }
        return s_keys;
    }

    public LEOSPFArea(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
        this.m_tag = OSPF_AREA_TAG + this.m_name;
    }

    public Object clone() {
        LEOSPFArea config = new LEOSPFArea(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean requiresReset(String key) {
        return key.equals(AUTH_ID) || key.equals(AUTH_KEY) || key.equals("password");
    }

    LEConfig createConfig(String key) {
        if (key.equals(NETWORK_RANGES)) {
            return new LENetworkRanges(this.m_facade, this.m_tag);
        }
        return new LEConfig(this.m_facade);
    }

    boolean getAllCommands(LEVector cmds) {
        boolean ret = super.getAllCommands(cmds);
        if (ret && this.m_reset) {
            cmds.addElement("save all");
            cmds.addElement(RESET);
            this.m_reset = false;
        }
        return ret;
    }

    boolean getChangedCommands(LEVector cmds) {
        boolean ret = super.getChangedCommands(cmds);
        if (ret && this.m_reset) {
            cmds.addElement("save all");
            cmds.addElement(RESET);
            this.m_reset = false;
        }
        return ret;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String type;
        boolean allCmds = keys == null;
        int start = cmds.size();
        if ((allCmds || keys.contains(AREA_TYPE)) && (type = (String)this.get(AREA_TYPE)) != null) {
            StringBuffer buf1 = new StringBuffer("set ");
            buf1.append(this.m_tag);
            buf1.append(" ");
            StringBuffer buf2 = new StringBuffer("set ");
            buf2.append(this.m_tag);
            buf2.append(" ");
            if (type.equals(EXTERNAL)) {
                buf1.append(NSSA);
                buf1.append(" ");
                buf1.append("off");
                buf2.append(EXTERNAL);
                buf2.append(" ");
                buf2.append("on");
            } else if (type.equals(NSSA)) {
                buf1.append(EXTERNAL);
                buf1.append(" ");
                buf1.append("off");
                buf2.append(NSSA);
                buf2.append(" ");
                buf2.append("on");
            } else {
                buf1.append(EXTERNAL);
                buf1.append(" ");
                buf1.append("off");
                buf2.append(NSSA);
                buf2.append(" ");
                buf2.append("off");
            }
            cmds.addElement(new String(buf1));
            cmds.addElement(new String(buf2));
        }
        if ((allCmds || keys.contains(AUTH_TYPE) || keys.contains(AUTH_KEY) || keys.contains(AUTH_ID) || keys.contains("password")) && (type = (String)this.get(AUTH_TYPE)) != null) {
            if (type.equals(AUTH_MD5)) {
                String id = (String)this.get(AUTH_ID);
                String key = (String)this.get(AUTH_KEY);
                if (id != null && id.length() > 0 && key != null && key.length() > 0) {
                    StringBuffer buf = new StringBuffer("set ");
                    buf.append(this.m_tag);
                    buf.append(" md5 ");
                    buf.append(id);
                    buf.append(" ");
                    buf.append(key);
                    cmds.addElement(new String(buf));
                    this.m_reset = true;
                }
            } else if (type.equals("password")) {
                this.m_reset = this.makeSetCommand(cmds, this.m_tag, "password", "password");
            }
        }
        if (allCmds || keys.contains(STUB_COST)) {
            this.makeSetCommand(cmds, this.m_tag, STUB_COST, STUB_COST);
        }
        return cmds.size() > start;
    }
}

