/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.util.LECipher;
import com.lucent.ra.nms.util.LEResourceID;
import com.lucent.ra.nms.util.LEVector;
import java.io.Serializable;
import java.util.Hashtable;

public class LEPop
implements Serializable,
Cloneable {
    public static final String DEFAULT = "##DEFAULT##";
    String m_name;
    String m_password;
    String m_defaultUser = "!root";
    String m_defaultPW;
    LEVector m_ids = new LEVector();
    Hashtable m_hostnames = new Hashtable();
    Hashtable m_usernames = new Hashtable();
    Hashtable m_passwords = new Hashtable();

    public LEPop(String name, String password) {
        this.m_name = name;
        this.m_password = LECipher.Encrypt(password);
        this.m_defaultPW = LECipher.Encrypt("");
    }

    public synchronized Object clone() {
        LEPop pop = new LEPop(this.m_name, LECipher.Decrypt(this.m_password));
        pop.setDefaultUsername(this.getDefaultUsername());
        pop.setDefaultPassword(this.getDefaultPassword());
        int len = this.m_ids.size();
        int i = 0;
        while (i < len) {
            String id = (String)this.m_ids.elementAt(i);
            pop.setEntry(this.getHostnameFor(id), this.getUsernameFor(id), this.getPasswordFor(id));
            ++i;
        }
        return pop;
    }

    public String getName() {
        return this.m_name;
    }

    public String getPassword() {
        return LECipher.Decrypt(this.m_password);
    }

    public String getDefaultUsername() {
        return this.m_defaultUser;
    }

    public String getDefaultPassword() {
        return LECipher.Decrypt(this.m_defaultPW);
    }

    public LEVector getIDs() {
        return this.m_ids;
    }

    public String getHostnameFor(String id) {
        return (String)this.m_hostnames.get(id);
    }

    public String getUsernameFor(String id) {
        return (String)this.m_usernames.get(id);
    }

    public String getPasswordFor(String id) {
        String pw = (String)this.m_passwords.get(id);
        if (pw != null) {
            pw = LECipher.Decrypt(pw);
        }
        return pw;
    }

    public String getActualUsernameFor(String id) {
        String user = this.getUsernameFor(id);
        if (DEFAULT.equals(user)) {
            user = this.m_defaultUser;
        }
        return user;
    }

    public String getActualPasswordFor(String id) {
        String pw = this.getPasswordFor(id);
        if (DEFAULT.equals(pw)) {
            pw = LECipher.Decrypt(this.m_defaultPW);
        }
        return pw;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setPassword(String password) {
        this.m_password = LECipher.Encrypt(password);
    }

    public void setDefaultUsername(String username) {
        this.m_defaultUser = username;
    }

    public void setDefaultPassword(String password) {
        this.m_defaultPW = LECipher.Encrypt(password);
    }

    public String setEntry(String hostname, String username, String password) {
        String id = LEResourceID.CreatePM_ID(hostname, username);
        this.m_ids.addUnique(id);
        this.m_hostnames.put(id, hostname);
        this.m_usernames.put(id, username);
        this.m_passwords.put(id, LECipher.Encrypt(password));
        return id;
    }

    public void removeEntry(String hostname, String username) {
        String id = LEResourceID.CreatePM_ID(hostname, username);
        this.removeEntry(id);
    }

    public void removeEntry(String id) {
        if (this.m_ids.removeElement(id)) {
            this.m_hostnames.remove(id);
            this.m_usernames.remove(id);
            this.m_passwords.remove(id);
        }
    }
}

