/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEIPIPSAs;
import com.lucent.ra.nms.model.LEIPSecSAs;
import com.lucent.ra.nms.model.LEProxySAs;
import com.lucent.ra.nms.model.LESA;

public class LESAs
extends LEConfig {
    public static final String IPSEC_SA = "ipsec";
    public static final String IPIP_SA = "ipip";
    public static final String PROXY_SA = "proxy";
    public static final int KEY_COUNT = 3;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[3];
            int i = 0;
            LESAs.s_keys[i++] = IPSEC_SA;
            LESAs.s_keys[i++] = IPIP_SA;
            LESAs.s_keys[i++] = PROXY_SA;
        }
        return s_keys;
    }

    public LESAs(LEConnectionFacade facade) {
        super(facade);
    }

    public Object clone() {
        LESAs config = new LESAs(this.m_facade);
        config.copy(this);
        return config;
    }

    public LESA getSA(String name) {
        LEIPIPSAs ipip;
        LESA sa = null;
        LEIPSecSAs ipsec = (LEIPSecSAs)this.get(IPSEC_SA);
        if (ipsec != null) {
            sa = (LESA)ipsec.get(name);
        }
        if (sa == null && (ipip = (LEIPIPSAs)this.get(IPIP_SA)) != null) {
            sa = (LESA)ipip.get(name);
        }
        if (sa == null) {
            LEProxySAs proxy = (LEProxySAs)this.get(PROXY_SA);
            if (sa != null) {
                sa = (LESA)proxy.get(name);
            }
        }
        return sa;
    }

    LEConfig createConfig(String key) {
        LEConfig config = key.equals(IPSEC_SA) ? new LEIPSecSAs(this.m_facade) : (key.equals(IPIP_SA) ? new LEIPIPSAs(this.m_facade) : (key.equals(PROXY_SA) ? new LEProxySAs(this.m_facade) : new LEConfig(this.m_facade)));
        return config;
    }
}

