/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEAddDialog;
import COM.livingston.forms.LECmdErrorDialog;
import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineFactory;
import COM.livingston.forms.LENewEntry;
import COM.livingston.forms.LERenameDialog;
import COM.livingston.forms.LETableForm;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LELocation;
import COM.livingston.model.LELocations;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LELocationsForm
extends LETableForm {
    String m_addName;

    public LELocationsForm() {
        this.m_renameEntries = true;
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Label label = new Label("Location Name:");
        label.setFont(LEFont.getBoldFont());
        panel.add("West", label);
        Component component = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        panel.add("Center", component);
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add Location", panel);
        if (lEAddDialog.okay()) {
            this.m_addName = ((LEFormLine)((Object)component)).getValue();
            if (this.m_addName.length() > 0) {
                return true;
            }
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A location name must be specified");
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LELocations lELocations = (LELocations)this.getTable(lEPortMaster);
        if (lELocations.get(this.m_addName) == null) {
            LEVector lEVector = lELocations.add(this.m_addName);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            }
            this.addEntry(lEPortMaster.getHostname(), lELocations, this.m_addName);
            lENewEntry = new LENewEntry(lEPortMaster, lELocations, this.m_addName);
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains a location named " + this.m_addName);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LELocations)) {
            return;
        }
        LELocations lELocations = (LELocations)lETable;
        LEVector lEVector = lELocations.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        String string;
        if (!(object instanceof LELocation)) {
            return null;
        }
        LELocation lELocation = (LELocation)object;
        LELocations lELocations = (LELocations)this.getTable(lEPortMaster);
        if (lELocations.get(string = lELocation.getName()) != null) {
            string = LETableForm.GetUniqueKey(lELocations, string, 12);
        }
        if ((lEVector = lELocations.add(string)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
            string = null;
        }
        return string;
    }

    String renameEntry(LEPortMaster lEPortMaster, LETable lETable, String string) {
        String string2 = null;
        LERenameDialog lERenameDialog = new LERenameDialog(LEUiUtils.GetBaseFrame(), lETable.getKeySpec(), string);
        String string3 = lERenameDialog.getNewName();
        if (string3 != null) {
            Object object = lETable.get(string3);
            if (object == null) {
                LEVector lEVector = ((LELocations)lETable).add(string3);
                if (lEVector == null) {
                    string2 = string3;
                } else {
                    new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConfigFacility(), lEVector);
                }
            } else {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getHostname()) + " already contains a location named " + string3);
            }
        }
        return string2;
    }
}

