/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEGroup;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEGroups
extends LETable {
    String m_line;

    public LEGroups(LEConfigFacility facility, String board, String line) {
        super(facility, board);
        this.m_line = line;
    }

    public LEGroups(LEConfigFacility facility, String line) {
        super(facility);
        this.m_line = line;
    }

    public Object clone() {
        LEGroups config = new LEGroups(this.m_facility, this.m_board, this.m_line);
        config.copy(this);
        return config;
    }

    public String getLine() {
        return this.m_line;
    }

    public LEVector add(String cgroup, String channels, String rate) {
        LEPMCommand ret;
        LEVector errors = null;
        if (this.m_board != null && !(ret = this.setView()).getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        if (errors == null) {
            LEGroup group = (LEGroup)this.getConfig(cgroup);
            group.set(LEGroup.CHANNELS, channels);
            group.set(LEGroup.SPEED, rate);
            errors = group.saveChanges();
            this.refresh();
        }
        return errors;
    }

    public LEVector delete(String cgroup) {
        LEVector cmds;
        LEPMCommand ret;
        LEPMCommand ret2;
        LEVector errors = null;
        if (this.m_board != null && !(ret2 = this.setView()).getStatus()) {
            errors = new LEVector();
            errors.addElement(ret2);
        }
        if (errors == null) {
            this.m_fields.remove(cgroup);
            if (this.m_facility != null) {
                StringBuffer buf = new StringBuffer("set ");
                buf.append(this.m_line);
                buf.append(" group ");
                buf.append(cgroup);
                buf.append(" channels ");
                ret = this.m_facility.execute(buf.toString());
                if (!ret.getStatus()) {
                    errors = new LEVector();
                    errors.addElement(ret);
                }
            }
        }
        if (errors == null && this.m_facility != null && this.getCommands(cmds = new LEVector())) {
            int len = cmds.size();
            int i = 0;
            while (i < len) {
                ret = this.m_facility.execute((String)cmds.elementAt(i));
                if (!ret.getStatus()) {
                    if (errors == null) {
                        errors = new LEVector();
                    }
                    errors.addElement(ret);
                }
                ++i;
            }
        }
        if (errors != null) {
            this.refresh();
        }
        return errors;
    }

    public void clear() {
        this.m_fields.clear();
        this.setChanged();
        this.notifyObservers();
    }

    LEConfig createConfig(String key) {
        return new LEGroup(this.m_facility, this.m_board, this.m_line, key);
    }
}

