/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDLCIList;
import COM.livingston.model.LEDLCITable;
import COM.livingston.model.LEPort;
import COM.livingston.util.LEVector;

public class LESyncPort
extends LEPort {
    public static final String COMPRESSION = Integer.toString(290);
    public static final String DESTINATION = Integer.toString(74);
    public static final String DLCI_LIST = "dlci";
    public static final String IP_DLCI_TAB = Integer.toString(305);
    public static final String IPX_DLCI_TAB = Integer.toString(306);
    public static final String GROUP = Integer.toString(129);
    public static final String HANGUP = Integer.toString(332);
    public static final String IDLE_TIMEOUT = Integer.toString(297);
    public static final String INPUT_FILTER = Integer.toString(193);
    public static final String IPX_NETWORK = Integer.toString(189);
    public static final String LOCAL_IP = Integer.toString(177);
    public static final String LMI_TIMER = Integer.toString(319);
    public static final String LMI_TYPE = Integer.toString(318);
    public static final String MODEM_CONTROL = Integer.toString(316);
    public static final String MTU = Integer.toString(295);
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = Integer.toString(15);
    public static final String NETWORK_TYPE = Integer.toString(312);
    public static final String OSPF = Integer.toString(181);
    public static final String OUTPUT_FILTER = Integer.toString(194);
    public static final String PROTOCOL = Integer.toString(289);
    public static final String RIP_BROAD = Integer.toString(187);
    public static final String RIP_LISTEN = Integer.toString(188);
    public static final String SPEED = Integer.toString(130);
    public static final int KEY_COUNT = 34;
    public static final String LMI = "lmi";
    public static final String ANNEXD = "annex-d";
    public static final String NONE = "none";
    public static final String PPP = "ppp";
    public static final String FRAME = "frame";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[34];
            int i = 0;
            LESyncPort.s_keys[i++] = COMPRESSION;
            LESyncPort.s_keys[i++] = DESTINATION;
            LESyncPort.s_keys[i++] = DLCI_LIST;
            LESyncPort.s_keys[i++] = GROUP;
            LESyncPort.s_keys[i++] = HANGUP;
            LESyncPort.s_keys[i++] = IDLE_TIMEOUT;
            LESyncPort.s_keys[i++] = INPUT_FILTER;
            LESyncPort.s_keys[i++] = IP_DLCI_TAB;
            LESyncPort.s_keys[i++] = IPX_DLCI_TAB;
            LESyncPort.s_keys[i++] = IPX_NETWORK;
            LESyncPort.s_keys[i++] = LMI_TYPE;
            LESyncPort.s_keys[i++] = LMI_TIMER;
            LESyncPort.s_keys[i++] = LOCAL_IP;
            LESyncPort.s_keys[i++] = MODEM_CONTROL;
            LESyncPort.s_keys[i++] = MTU;
            LESyncPort.s_keys[i++] = NAT_TCP_TIMEOUT;
            LESyncPort.s_keys[i++] = NAT_OTHER_TIMEOUT;
            LESyncPort.s_keys[i++] = NAT_FAIL_ACTION;
            LESyncPort.s_keys[i++] = NAT_IN_MAP;
            LESyncPort.s_keys[i++] = NAT_PROXY_IN_MAP;
            LESyncPort.s_keys[i++] = NAT_OUT_MAP;
            LESyncPort.s_keys[i++] = NAT_PROXY_OUT_MAP;
            LESyncPort.s_keys[i++] = NAT_LOG_FAILURE;
            LESyncPort.s_keys[i++] = NAT_LOG_SUCCESS;
            LESyncPort.s_keys[i++] = NAT_LOG_SYSLOG;
            LESyncPort.s_keys[i++] = NAT_LOG_CONSOLE;
            LESyncPort.s_keys[i++] = NETMASK;
            LESyncPort.s_keys[i++] = NETWORK_TYPE;
            LESyncPort.s_keys[i++] = OUTPUT_FILTER;
            LESyncPort.s_keys[i++] = OSPF;
            LESyncPort.s_keys[i++] = PROTOCOL;
            LESyncPort.s_keys[i++] = RIP_BROAD;
            LESyncPort.s_keys[i++] = RIP_LISTEN;
            LESyncPort.s_keys[i++] = SPEED;
        }
        return s_keys;
    }

    public LESyncPort(LEConfigFacility facility, String board, String name) {
        super(facility, board, name);
    }

    public Object clone() {
        LESyncPort config = new LESyncPort(this.m_facility, this.m_board, this.m_name);
        config.copy(this);
        return config;
    }

    LEConfig createConfig(String key) {
        if (key.equals(IP_DLCI_TAB)) {
            return new LEDLCITable(this.m_facility, this.m_board, this.m_name, "ipdlci");
        }
        if (key.equals(IPX_DLCI_TAB)) {
            return new LEDLCITable(this.m_facility, this.m_board, this.m_name, "ipxdlci");
        }
        return new LEDLCIList(this.m_facility, this.m_name);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(NETWORK_TYPE)) {
            this.makeTypeCommand(cmds, null, (String)this.get(NETWORK_TYPE), null);
        }
        if (allCmds || keys.contains(COMPRESSION)) {
            this.makeSetCommand(cmds, this.m_name, COMPRESSION, "compression");
        }
        if (allCmds || keys.contains(DESTINATION)) {
            this.makeSetCommand(cmds, this.m_name, DESTINATION, "destination");
        }
        if (allCmds || keys.contains(GROUP)) {
            this.makeSetCommand(cmds, this.m_name, GROUP, "group");
        }
        if (allCmds || keys.contains(HANGUP)) {
            this.makeSetCommand(cmds, this.m_name, HANGUP, "hangup");
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_name, IDLE_TIMEOUT, "idletime");
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, INPUT_FILTER, "ifilter");
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_name, IPX_NETWORK, "ipxnet");
        }
        if (allCmds || keys.contains(LMI_TYPE) || keys.contains(LMI_TIMER)) {
            String lmi = (String)this.get(LMI_TYPE);
            String timer = (String)this.get(LMI_TIMER);
            if (lmi == null || lmi.equals(NONE)) {
                lmi = LMI;
                timer = "0";
            }
            if (lmi != null && lmi.length() > 0 && timer != null && timer.length() > 0) {
                StringBuffer buf = new StringBuffer("set ");
                buf.append(this.m_name);
                buf.append(" ");
                buf.append(lmi);
                buf.append(" ");
                buf.append(timer);
                cmds.addElement(new String(buf));
            }
        }
        if (allCmds || keys.contains(LOCAL_IP)) {
            this.makeSetCommand(cmds, this.m_name, LOCAL_IP, "address");
        }
        if (allCmds || keys.contains(MODEM_CONTROL)) {
            this.makeSetCommand(cmds, this.m_name, MODEM_CONTROL, "cd");
        }
        if (allCmds || keys.contains(MTU)) {
            this.makeSetCommand(cmds, this.m_name, MTU, "mtu");
        }
        if (allCmds || keys.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_name, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_name, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(cmds, this.m_name, NAT_FAIL_ACTION);
        }
        if (allCmds || keys.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_IN_MAP, true, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_PROXY_IN_MAP, true, true);
        }
        if (allCmds || keys.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_OUT_MAP, false, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_name, NAT_PROXY_OUT_MAP, false, true);
        }
        if (allCmds || keys.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (allCmds || keys.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (allCmds || keys.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (allCmds || keys.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(cmds, this.m_name, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_name, NETMASK, "netmask");
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, OUTPUT_FILTER, "ofilter");
        }
        if (allCmds || keys.contains(OSPF)) {
            this.makeSetCommand(cmds, this.m_name, OSPF, "ospf");
        }
        if (allCmds || keys.contains(PROTOCOL)) {
            this.makeSetCommand(cmds, this.m_name, PROTOCOL, "protocol");
        }
        if (allCmds || keys.contains(RIP_BROAD) || keys.contains(RIP_LISTEN)) {
            this.makeRIPCommand(cmds, this.m_name, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        return cmds.size() > start;
    }
}

