/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEDataSpec;
import COM.livingston.util.LEVector;

public class LETable
extends LEConfig {
    LEVector m_obsolete;

    public LETable(LEConfigFacility facility, String board, String key) {
        super(facility, board, key);
    }

    public LETable(LEConfigFacility facility, String board) {
        super(facility, board);
    }

    public LETable(LEConfigFacility facility) {
        super(facility);
    }

    public Object clone() {
        LETable config = new LETable(this.m_facility, this.m_board);
        config.copy(this);
        return config;
    }

    public int size() {
        return this.m_fields.size();
    }

    public String getDescriptionFor(String key) {
        return key;
    }

    public LEDataSpec getSpecFor(String key) {
        LEDataSpec spec = null;
        if (this.m_spec != null) {
            spec = this.m_spec.getSpecFor("entry");
        }
        return spec;
    }

    public LEDataSpec getKeySpec() {
        LEDataSpec spec = null;
        if (this.m_spec != null) {
            spec = this.m_spec.getSpecFor("key");
        }
        return spec;
    }

    void refresh(LEConfig config) {
        if (this.m_obsolete != null) {
            return;
        }
        this.m_obsolete = this.getKeys();
        super.refresh(this);
        int len = this.m_obsolete.size();
        int i = 0;
        while (i < len) {
            this.m_fields.remove((String)this.m_obsolete.elementAt(i));
            ++i;
        }
        this.m_obsolete = null;
    }

    void setField(String key, Object value) {
        if (this.m_obsolete != null) {
            this.m_obsolete.removeElement(key);
        }
        super.setField(key, value);
    }

    LEConfig getConfig(String key) {
        if (this.m_obsolete != null) {
            this.m_obsolete.removeElement(key);
        }
        return super.getConfig(key);
    }

    String makeAddCommand(String key, String tag) {
        StringBuffer buf = new StringBuffer("add ");
        buf.append(key);
        buf.append(" ");
        buf.append(tag);
        return buf.toString();
    }

    String makeDeleteCommand(String key, String tag) {
        StringBuffer buf = new StringBuffer("delete ");
        buf.append(key);
        buf.append(" ");
        buf.append(tag);
        return buf.toString();
    }

    String makeSetCommand(String one, String two, String three, String four) {
        StringBuffer buf = new StringBuffer("set ");
        buf.append(one);
        buf.append(" ");
        buf.append(two);
        buf.append(" ");
        buf.append(three);
        buf.append(" ");
        buf.append(four);
        return buf.toString();
    }
}

