/*
 * Decompiled with CFR 0.152.
 */
import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPMUpgrade;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LEBorderPanel;
import COM.livingston.ui.LEConfirmClient;
import COM.livingston.ui.LEConfirmDialog;
import COM.livingston.ui.LEErrorDialog;
import COM.livingston.ui.LEFont;
import COM.livingston.ui.LETextField;
import COM.livingston.ui.LEUiUtils;
import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEObserver;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import COM.livingston.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class LEUpgradeView
extends LEBorderPanel
implements LEView,
LEConfirmClient,
LEObserver,
Runnable,
ActionListener {
    public static final String NEWLINE = new String("\n");
    public static final String PERCENT = new String("%");
    public static final String REBOOT = new String("reboot");
    public static final String SPACE = new String(" ");
    public static final String DOT = new String(".");
    static Insets s_defInsets = new Insets(3, 5, 3, 5);
    Label m_boxes;
    Button m_upgrade;
    Button m_browse;
    Button m_logBrowse;
    Checkbox m_reboot;
    LETextField m_path;
    LETextField m_logPath;
    TextArea m_log;
    Panel m_buttons;
    LEVector m_pms;
    File m_file;
    File m_upFile;
    PrintWriter m_prw;
    int m_dotCount;
    String m_lastMsg = SPACE;
    LEViewListener m_listener;

    public LEUpgradeView() {
        this.setInsets(5, 5, 5, 5);
        this.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        this.createMain(panel);
        this.add("Center", panel);
    }

    public void setSelection(LEPortMaster[] lEPortMasterArray) {
        this.m_pms = new LEVector();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < lEPortMasterArray.length) {
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(lEPortMasterArray[n].getHostname());
            this.m_pms.addElement(lEPortMasterArray[n]);
            ++n;
        }
        this.m_boxes.setText(new String(stringBuffer));
    }

    public Component getMainPanel() {
        return this;
    }

    public Component getBottomPanel() {
        if (this.m_buttons == null) {
            this.m_buttons = new Panel();
            this.m_buttons.setLayout(new FlowLayout(1));
            this.m_upgrade = new Button("Upgrade");
            this.m_buttons.add(this.m_upgrade);
            this.m_upgrade.addActionListener(this);
        }
        return this.m_buttons;
    }

    public void going() {
    }

    public void gone() {
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        this.m_prw = null;
        this.m_file = null;
    }

    public void addListener(LEViewListener lEViewListener) {
        this.m_listener = lEViewListener;
    }

    public void deleteListener(LEViewListener lEViewListener) {
        if (this.m_listener == lEViewListener) {
            this.m_listener = null;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.m_upgrade) {
            if (LEAppInfo.DemoMode()) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "This feature is disabled in demo mode.");
                return;
            }
            this.confirmLogFile();
            return;
        }
        if (object == this.m_browse) {
            this.browse("Upgrade File", this.m_path);
            return;
        }
        if (object == this.m_logBrowse) {
            this.browse("Upgrade Log File", this.m_logPath);
        }
    }

    public void update(LEObservable lEObservable, Object object) {
        if (object instanceof LEThreadStatus) {
            LEThreadStatus lEThreadStatus = (LEThreadStatus)object;
            String string = lEThreadStatus.getMessage();
            if (string.equals(this.m_lastMsg)) {
                ++this.m_dotCount;
                this.m_log.append(DOT);
                if (this.m_prw != null) {
                    this.m_prw.print(DOT);
                }
                if (this.m_dotCount % 50 == 0) {
                    this.m_log.append(NEWLINE);
                    if (this.m_prw != null) {
                        this.m_prw.println();
                    }
                }
            } else if (string.length() > 0) {
                if (this.m_dotCount > 0) {
                    this.m_log.append(NEWLINE);
                    if (this.m_prw != null) {
                        this.m_prw.println();
                    }
                }
                this.m_log.append(string);
                this.m_log.append(NEWLINE);
                if (this.m_prw != null) {
                    this.m_prw.println(string);
                }
                this.m_dotCount = 0;
            }
            this.m_lastMsg = string;
        }
    }

    public void confirmAction(String string, Object object) {
        if (string.equals(LEConfirmDialog.YES)) {
            this.setLogFile((File)object);
            return;
        }
        this.cancelAction(object);
    }

    public void cancelAction(Object object) {
        this.m_file = null;
        this.m_prw = null;
        ((TextComponent)this.m_logPath).setText("");
    }

    public void run() {
        this.lock();
        try {
            LEVector lEVector = new LEVector();
            lEVector.addVector(this.m_pms);
            int n = lEVector.size();
            int n2 = 0;
            while (n2 < n) {
                this.upgradePM((LEPortMaster)lEVector.elementAt(n2), this.m_upFile);
                ++n2;
            }
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
        }
        LEStatusManager.StatusComplete();
        this.unlock();
    }

    void lock() {
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(8, null));
        }
        this.m_browse.setEnabled(false);
        this.m_logBrowse.setEnabled(false);
        this.m_reboot.setEnabled(false);
        this.m_path.setEnabled(false);
        this.m_logPath.setEnabled(false);
        this.m_upgrade.setEnabled(false);
    }

    void unlock() {
        this.m_browse.setEnabled(true);
        this.m_logBrowse.setEnabled(true);
        this.m_reboot.setEnabled(true);
        this.m_path.setEnabled(true);
        this.m_logPath.setEnabled(true);
        this.m_upgrade.setEnabled(true);
        if (this.m_listener != null) {
            this.m_listener.onLEViewEvent(new LEViewEvent(9, null));
        }
    }

    void upgrade() {
        if (this.m_pms.size() == 0) {
            return;
        }
        String string = this.m_path.getText();
        if (string == null || string.length() < 1) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), "A file must be specified!");
            return;
        }
        this.m_upFile = new File(string);
        if (!this.m_upFile.exists()) {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(this.m_upFile.getAbsolutePath()) + " does not exist!");
            return;
        }
        new Thread(this).start();
    }

    void upgradePM(LEPortMaster lEPortMaster, File file) {
        block10: {
            this.m_log.setText("");
            String string = "Upgrading " + lEPortMaster.getHostname() + " using " + file.getAbsolutePath();
            LEStatusManager.SetStatus(string);
            this.m_log.append(string);
            this.m_log.append(NEWLINE);
            this.m_log.append(NEWLINE);
            if (this.m_prw != null) {
                this.m_prw.println(string);
                this.m_prw.println();
            }
            try {
                LEDSSPMUpgrade lEDSSPMUpgrade = new LEDSSPMUpgrade(file, lEPortMaster.getDSS());
                LEStatusManager lEStatusManager = lEDSSPMUpgrade.getStatusManager();
                lEStatusManager.addObserver(this);
                lEDSSPMUpgrade.doUpgrade();
                lEStatusManager.deleteObserver(this);
                this.m_log.append("Upgrade successful");
                this.m_log.append(NEWLINE);
                this.m_log.append(file.getAbsolutePath());
                this.m_log.append(" has been loaded onto ");
                this.m_log.append(lEPortMaster.getHostname());
                this.m_log.append(NEWLINE);
                if (this.m_prw != null) {
                    this.m_prw.println("Upgrade successful");
                    this.m_prw.print(file.getAbsolutePath());
                    this.m_prw.print(" has been loaded onto ");
                    this.m_prw.println(lEPortMaster.getHostname());
                }
                if (this.m_reboot.getState()) {
                    this.m_log.append(REBOOT);
                    this.m_log.append(NEWLINE);
                    if (this.m_prw != null) {
                        this.m_prw.println(REBOOT);
                    }
                    new LERebootThread(lEPortMaster);
                }
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, "Error from upgrade");
                if (!(exception instanceof LEDSSException)) {
                    LEDebug.getLog().logln(20, exception);
                }
                if ((string = exception.getMessage()) != null && string.length() > 0) {
                    this.m_log.append(string);
                    this.m_log.append(NEWLINE);
                    if (this.m_prw != null) {
                        this.m_prw.println(exception.getMessage());
                    }
                    new LEErrorDialog(LEUiUtils.GetBaseFrame(), exception.getMessage());
                }
                this.m_log.append(NEWLINE);
                this.m_log.append("An error occurred during upgrade.");
                this.m_log.append(NEWLINE);
                this.m_log.append("Do NOT reboot!");
                this.m_log.append(NEWLINE);
                this.m_log.append("Please try upgrading again");
                this.m_log.append(NEWLINE);
                if (this.m_prw == null) break block10;
                this.m_prw.println();
                this.m_prw.println("An error occurred during upgrade.");
                this.m_prw.println("Do NOT reboot!");
                this.m_prw.println("Please try upgrading again.");
            }
        }
        this.m_log.append(NEWLINE);
        if (this.m_prw != null) {
            this.m_prw.println();
        }
    }

    void browse(String string, LETextField lETextField) {
        FileDialog fileDialog = new FileDialog(LEUiUtils.GetBaseFrame(), string, 0);
        String string2 = LEAppInfo.getLastDirectory();
        if (string2 != null) {
            fileDialog.setDirectory(string2);
        }
        fileDialog.show();
        string2 = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (string3 != null) {
            String string4 = LEAppInfo.createFullPath(string2, string3);
            ((TextComponent)lETextField).setText(string4);
            LEAppInfo.setLastDirectory(string2);
        }
    }

    void createMain(Panel panel) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        panel.setLayout(gridBagLayout);
        Font font = LEFont.getBoldFont();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = s_defInsets;
        Label label = new Label("PortMaster(s):");
        label.setFont(font);
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = this.m_boxes = new Label();
        panel.add(label);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        label = new Label("Reboot after Upgrade:");
        label.setFont(font);
        panel.add(label);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.m_reboot = new Checkbox();
        panel.add(this.m_reboot);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.m_reboot, gridBagConstraints);
        label = new Label("Upgrade Using File:");
        label.setFont(font);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        this.m_path = new LETextField();
        panel2.add("Center", this.m_path);
        this.m_browse = new Button("Browse...");
        panel2.add("East", this.m_browse);
        this.m_browse.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        panel.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        label = new Label("Log to File:");
        label.setFont(font);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 5));
        this.m_logPath = new LETextField();
        panel2.add("Center", this.m_logPath);
        this.m_logBrowse = new Button("Browse...");
        panel2.add("East", this.m_logBrowse);
        this.m_logBrowse.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        panel.add(panel2);
        gridBagLayout.setConstraints(panel2, gridBagConstraints);
        label = new Label("Upgrade Log:");
        label.setFont(font);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        panel.add(label);
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.m_log = new TextArea();
        this.m_log.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        panel.add(this.m_log);
        gridBagLayout.setConstraints(this.m_log, gridBagConstraints);
    }

    void confirmLogFile() {
        String string = this.m_logPath.getText();
        if (string.length() == 0) {
            if (this.m_prw != null) {
                this.m_prw.close();
            }
            this.m_file = null;
            this.m_prw = null;
            this.upgrade();
            return;
        }
        File file = new File(string);
        if (this.m_file == null || !file.getAbsolutePath().equals(this.m_file.getAbsolutePath())) {
            if (file.exists()) {
                String[] stringArray = new String[]{LEConfirmDialog.YES, LEConfirmDialog.NO};
                LEConfirmDialog lEConfirmDialog = new LEConfirmDialog(LEUiUtils.GetBaseFrame(), (LEConfirmClient)this, String.valueOf(file.getAbsolutePath()) + " already exists. Overwrite it?", stringArray, (Object)file);
                ((Component)lEConfirmDialog).setVisible(true);
                return;
            }
            this.setLogFile(file);
            return;
        }
        this.upgrade();
    }

    void setLogFile(File file) {
        this.m_file = file;
        ((TextComponent)this.m_logPath).setText(this.m_file.getAbsolutePath());
        if (this.m_prw != null) {
            this.m_prw.close();
        }
        try {
            FileWriter fileWriter = new FileWriter(this.m_file);
            this.m_prw = new PrintWriter((Writer)fileWriter, true);
            this.upgrade();
            return;
        }
        catch (IOException iOException) {
            this.m_file = null;
            this.m_prw = null;
            ((TextComponent)this.m_logPath).setText("");
            LEDebug.getLog().logln(20, iOException);
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), iOException.getMessage());
            return;
        }
    }
}

