/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.backend;

import com.lucent.ra.nms.amf.LEAMManager_RI;
import com.lucent.ra.nms.backend.LEAlarmFacility_R;
import com.lucent.ra.nms.backend.LEAsyncCmdFacility_R;
import com.lucent.ra.nms.backend.LEDSS;
import com.lucent.ra.nms.backend.LEDSSException;
import com.lucent.ra.nms.backend.LEDSSPortMaster_R;
import com.lucent.ra.nms.backend.LEDebugFacility_R;
import com.lucent.ra.nms.backend.LELogFacility_R;
import com.lucent.ra.nms.backend.LEMonitorFacility_R;
import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.backend.LESendResponse;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.backend.LEUserAuthenticationMessage;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import java.io.IOException;
import java.rmi.RemoteException;

public class LEDSSPortMaster
implements LEDSS {
    public static final byte NC_INIT = 2;
    public static final byte NC_DISC = 3;
    public static final byte NC_COMMAND = 4;
    public static final byte NC_DOWNLOAD = 5;
    public static final byte NC_DOWNDATA = 6;
    public static final byte NC_RENAME = 7;
    public static final byte NC_STATUS = 8;
    public static final byte NC_REPLY = 9;
    public static final byte NC_RAW_WRITE = 10;
    public static final byte NC_IOSTAT = 11;
    public static final byte NC_UPLOAD = 12;
    public static final byte NC_UPDATA = 13;
    public static final byte NC_CDATA = 14;
    public static final byte NC_RESET = 15;
    public static final byte NC_NETSTATUS = 16;
    public static final byte NC_TABLE = 17;
    public static final byte NC_CHALLENGE = 18;
    public static final byte NC_MD5_PASS = 19;
    public static final byte NC_USER_PASS = 20;
    public static final byte NC_BK = 21;
    public static final byte NC_TOC = 22;
    public static final byte NC_MONITOR = 23;
    public static final byte NC_DEBUG = 24;
    public static final byte NC_DELTA = 25;
    public static final byte NC_MONMESSAGE = 26;
    public static final byte NC_DBGMESSAGE = 27;
    public static final byte NC_DELTAMSG = 28;
    public static final byte NC_ALARMS = 29;
    public static final byte NC_ALARMMSG = 30;
    public static final byte NC_ENTITY = 31;
    public static final byte NC_ENTITYMSG = 32;
    public static final byte NC_NEWCOMMAND = 33;
    public static final byte NC_NEWCMDMSG = 34;
    public static final byte NC_AUTHENTICATE = 35;
    public static final byte NC_ASYNC = 36;
    public static final byte NC_ASYNCMSG = 37;
    public static final byte NC_LOG = 38;
    public static final byte NC_LOGMSG = 39;
    public static final byte NC_RESPONSE = 40;
    public static final byte NC_USER_LOGIN = 41;
    public static final byte NC_DIAG_START = 42;
    public static final byte NC_DIAG_STOP = 43;
    public static final byte NC_DIAGMSG = 44;
    public static final byte NC_MON_START = 45;
    public static final byte NC_MON_STOP = 46;
    public static final byte NC_MONITORMSG = 47;
    public static final byte NC_RENEW_LEASE = 48;
    public static final byte NC_NEW_TOC = 49;
    public static final byte NC_METAINFO = 50;
    public static final byte NC_DATA = 51;
    public static final byte NC_SUCCESS = 115;
    public static final byte NC_FAIL = 102;
    public static final byte NC_ID = 101;
    public static final int CONTROL_PORT = 1643;
    LEDSSPortMaster_R m_pm;
    String m_server;
    String m_id;
    String m_host;
    String m_user;
    String m_pw;

    public LEDSSPortMaster(String server_id, String id, LEDSSPortMaster_R pm, String host, String user, String pw) {
        this.m_server = server_id;
        this.m_id = id;
        this.m_pm = pm;
        this.m_host = host;
        this.m_user = user;
        this.m_pw = pw;
    }

    public String getResourceID() {
        return this.m_id;
    }

    public String getHostname() {
        return this.m_host;
    }

    public String getUsername() {
        return this.m_user;
    }

    public String getPassword() {
        return this.m_pw;
    }

    public LEAlarmFacility_R getAlarmFacility() {
        LEAlarmFacility_R ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.getAlarmFacility();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LEDebugFacility_R getDebugFacility() {
        LEDebugFacility_R ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.getDebugFacility();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LEMonitorFacility_R getMonitorFacility() {
        LEMonitorFacility_R ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.getMonitorFacility();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LEAsyncCmdFacility_R getAsyncFacility() {
        LEAsyncCmdFacility_R ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.getAsyncFacility();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LELogFacility_R getLogFacility() {
        LELogFacility_R ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.getLogFacility();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public boolean supportsEntities() {
        boolean ret = false;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.supportsEntities();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public boolean isConnected() {
        boolean ret = false;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.isConnected();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void startUpgrade() {
        try {
            if (this.m_pm != null) {
                this.m_pm.startUpgrade();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public void stopUpgrade() {
        try {
            if (this.m_pm != null) {
                this.m_pm.stopUpgrade();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public boolean upgrading() {
        boolean ret = false;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.upgrading();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public boolean reconnecting() {
        boolean ret = false;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.reconnecting();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void disconnect() {
        try {
            if (this.m_pm != null) {
                this.m_pm.disconnect();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public boolean reconnect() throws IOException, LEDSSException {
        boolean ret = false;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.reconnect();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void setPassword(String password) {
        try {
            if (this.m_pm != null) {
                this.m_pm.setPassword(password);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public LEPMCommand execute(String command) {
        LEPMCommand ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.execute(command);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LEPMCommand execute(String command, int timeout) {
        LEPMCommand ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.execute(command, timeout);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LEVector getTOC(int entity) {
        LEVector ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.getTOC(entity);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public long debug(int entity, int context) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.debug(entity, context);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public long debug(int entity, int context, int board) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.debug(entity, context, board);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void killDebug(long request) throws LEDSSException {
        try {
            if (this.m_pm != null) {
                this.m_pm.killDebug(request);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public long delta(int entity, int interval) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.delta(entity, interval);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public long delta(int entity, int interval, int board) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.delta(entity, interval, board);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void killDelta(long request) throws LEDSSException {
        try {
            if (this.m_pm != null) {
                this.m_pm.killDelta(request);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public long monitor(int entity, int interval) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.monitor(entity, interval);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public long monitor(int entity, int interval, int board) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.monitor(entity, interval, board);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public long monitor(int entity, int interval, String adminGroup) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.monitor(entity, interval, adminGroup);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public long monitor(int entity, int interval, int board, String start, String end) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.monitor(entity, interval, board, start, end);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void killMonitor(long request) throws LEDSSException {
        try {
            if (this.m_pm != null) {
                this.m_pm.killMonitor(request);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public long async(int entity, int board, String command) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.async(entity, board, command);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void killAsync(long request) throws LEDSSException {
        try {
            if (this.m_pm != null) {
                this.m_pm.killAsync(request);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public long alarm(int entity) throws LEDSSException {
        long ret = 0L;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.alarm(entity);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void clearAlarm(long request) throws LEDSSException {
        try {
            if (this.m_pm != null) {
                this.m_pm.clearAlarm(request);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public void killAlarm(long request) throws LEDSSException {
        try {
            if (this.m_pm != null) {
                this.m_pm.killAlarm(request);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    public LEUserAuthenticationMessage userAuthenticate(String username, String password) {
        try {
            if (this.m_pm != null) {
                return this.m_pm.userAuthenticate(username, password);
            }
            return null;
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
            return null;
        }
    }

    public LESendResponse send(byte opCode, short length, String data, boolean multiPacket) {
        LESendResponse ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.send(opCode, length, data, multiPacket);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LESendResponse send(byte opCode, short length, String data, boolean multiPacket, int timeout) {
        LESendResponse ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.send(opCode, length, data, multiPacket, timeout);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LESendResponse send(byte opCode, short length, byte[] data, boolean multiPacket) {
        LESendResponse ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.send(opCode, length, data, multiPacket);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LESendResponse send(byte opCode, short length, byte[] data, boolean multiPacket, int timeout) {
        LESendResponse ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.send(opCode, length, data, multiPacket, timeout);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LESendResponse recv(boolean multiPacket) {
        LESendResponse ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.recv(multiPacket);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public LESendResponse recv(boolean multiPacket, int timeout) {
        LESendResponse ret = null;
        try {
            if (this.m_pm != null) {
                ret = this.m_pm.recv(multiPacket, timeout);
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
        return ret;
    }

    public void done() {
        try {
            if (this.m_pm != null) {
                this.m_pm.done();
            }
        }
        catch (RemoteException e) {
            this.handleRemoteException(e);
        }
    }

    void handleRemoteException(RemoteException e) {
        LEDebug.getLog().logln(20, e);
        LEStatusMessage msg = new LEStatusMessage(2);
        LEAMManager_RI.Process(this.m_server, "STATUS", msg);
        this.m_pm = null;
    }
}

