/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEDBLoginUser
extends LEConfig {
    public static final String IDLE_TIMEOUT = "297";
    public static final String TELEPHONE = "301";
    public static final String SESSION_LIMIT = "371";
    public static final int KEY_COUNT = 3;
    static String[] s_keys = null;
    String m_name;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[3];
            int i = 0;
            LEDBLoginUser.s_keys[i++] = IDLE_TIMEOUT;
            LEDBLoginUser.s_keys[i++] = TELEPHONE;
            LEDBLoginUser.s_keys[i++] = SESSION_LIMIT;
        }
        return s_keys;
    }

    public LEDBLoginUser(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
        this.m_tag = "user " + this.m_name;
    }

    public Object clone() {
        LEDBLoginUser config = new LEDBLoginUser(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_tag, IDLE_TIMEOUT, "idle");
        }
        if (allCmds || keys.contains(TELEPHONE)) {
            this.makeSetCommand(cmds, this.m_tag, TELEPHONE, "dialback");
        }
        if (allCmds || keys.contains(SESSION_LIMIT)) {
            this.makeSetCommand(cmds, this.m_tag, SESSION_LIMIT, "session-limit");
        }
        return cmds.size() > start;
    }
}

