/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEDLCITable;
import com.lucent.ra.nms.model.LEDialScript;
import com.lucent.ra.nms.util.LEVector;

public class LELocation
extends LEConfig {
    public static final String ADDRESS = "9";
    public static final String ANALOG = "292";
    public static final String ASYNC_MAP = "299";
    public static final String ASYNC_SCRIPT = "script";
    public static final String CHAP = "170";
    public static final String COMPRESSION = "290";
    public static final String COST = "242";
    public static final String DEADTIME = "244";
    public static final String DESTINATION = "74";
    public static final String DIAL_FILTER = "294";
    public static final String DOSBS = "293";
    public static final String GROUP = "129";
    public static final String HELLOINTERVAL = "243";
    public static final String HIGH_WATER = "298";
    public static final String IDLE_TIMEOUT = "297";
    public static final String INPUT_FILTER = "193";
    public static final String IP_DLCI = "ipdlci";
    public static final String IPSEC_ACTIVE_PROFILE = "501";
    public static final String IPSEC_LOG_CONSOLE = "499";
    public static final String IPSEC_LOG_FAILURE = "496";
    public static final String IPSEC_LOG_SUCCESS = "497";
    public static final String IPSEC_LOG_SYSLOG = "498";
    public static final String IPSEC_OUTSRC_PROFILE = "500";
    public static final String IPSEC_PASSIVE_PROFILE = "502";
    public static final String IPSEC_PDA = "503";
    public static final String IPX_DLCI = "ipxdlci";
    public static final String IPX_NETWORK = "189";
    public static final String LOCAL_IP = "177";
    public static final String MAX_PORTS = "296";
    public static final String MIGRATION = "241";
    public static final String MULTILINK = "291";
    public static final String MTU = "295";
    public static final String NAT_TCP_TIMEOUT = "353";
    public static final String NAT_OTHER_TIMEOUT = "354";
    public static final String NAT_FAIL_ACTION = "355";
    public static final String NAT_IN_MAP = "356";
    public static final String NAT_PROXY_IN_MAP = "357";
    public static final String NAT_OUT_MAP = "358";
    public static final String NAT_PROXY_OUT_MAP = "359";
    public static final String NAT_LOG_FAILURE = "360";
    public static final String NAT_LOG_SUCCESS = "361";
    public static final String NAT_LOG_SYSLOG = "362";
    public static final String NAT_LOG_CONSOLE = "363";
    public static final String NETMASK = "15";
    public static final String OSPF_STATUS = "246";
    public static final String OUTPUT_FILTER = "194";
    public static final String PASSWORD = "300";
    public static final String PPP_IP_TYPE = "PPPIPType";
    public static final String PPP_IPX_TYPE = "PPPIPXType";
    public static final String PROTOCOL = "289";
    public static final String REVERSE_DIAL = "525";
    public static final String RIP_COST = "198";
    public static final String RIP = "rip";
    public static final String RIP_V2 = "rip_v2";
    public static final String ROUTE_IFILTER = "533";
    public static final String ROUTE_OFILTER = "534";
    public static final String SECURITY_ASSN = "224";
    public static final String TELEPHONE = "301";
    public static final String TYPE = "288";
    public static final String USERNAME = "2";
    public static final String V25BIS_SCRIPT = "v25bis";
    public static final String WANTYPE = "245";
    public static final String XBAR_ADDR = "72";
    public static final int KEY_COUNT = 63;
    public static final String ASYNC_SCRIPT_TAG = "script";
    public static final String V25BIS_SCRIPT_TAG = "v25bis";
    public static final String LOCATION_TAG = "location";
    public static final String NEGOTIATED = "negotiated";
    public static final String SPECIFIED = "specified";
    public static final String CONTINUOUS = "continuous";
    public static final String MANUAL = "manual";
    public static final String ON_DEMAND = "on-demand";
    public static final String SUB_INTERFACE = "sub-interface";
    public static final String FRAME_RELAY = "frame-relay";
    public static final String PPP = "ppp";
    public static final String SLIP = "slip";
    public static final String X75_SYNC = "x75-sync";
    public static final String STAC = "stac";
    public static final String VJ = "vj";
    public static final String MINUTES = "minutes";
    public static final String SECONDS = "seconds";
    public static final String BROAD = "broadcast";
    public static final String LISTEN = "listen";
    public static final String V2 = "v2 enabled";
    public static final String MULTICAST = "multicast";
    public static final String COMPATABILITY = "v1-compatability";
    static String[] s_keys = null;
    String m_name;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[63];
            int i = 0;
            LELocation.s_keys[i++] = ADDRESS;
            LELocation.s_keys[i++] = ANALOG;
            LELocation.s_keys[i++] = ASYNC_MAP;
            LELocation.s_keys[i++] = "script";
            LELocation.s_keys[i++] = CHAP;
            LELocation.s_keys[i++] = COMPRESSION;
            LELocation.s_keys[i++] = COST;
            LELocation.s_keys[i++] = DEADTIME;
            LELocation.s_keys[i++] = DESTINATION;
            LELocation.s_keys[i++] = DIAL_FILTER;
            LELocation.s_keys[i++] = DOSBS;
            LELocation.s_keys[i++] = GROUP;
            LELocation.s_keys[i++] = HELLOINTERVAL;
            LELocation.s_keys[i++] = HIGH_WATER;
            LELocation.s_keys[i++] = IDLE_TIMEOUT;
            LELocation.s_keys[i++] = INPUT_FILTER;
            LELocation.s_keys[i++] = IP_DLCI;
            LELocation.s_keys[i++] = IPSEC_ACTIVE_PROFILE;
            LELocation.s_keys[i++] = IPSEC_LOG_FAILURE;
            LELocation.s_keys[i++] = IPSEC_LOG_SUCCESS;
            LELocation.s_keys[i++] = IPSEC_LOG_SYSLOG;
            LELocation.s_keys[i++] = IPSEC_LOG_CONSOLE;
            LELocation.s_keys[i++] = IPSEC_OUTSRC_PROFILE;
            LELocation.s_keys[i++] = IPSEC_PASSIVE_PROFILE;
            LELocation.s_keys[i++] = IPSEC_PDA;
            LELocation.s_keys[i++] = IPX_DLCI;
            LELocation.s_keys[i++] = IPX_NETWORK;
            LELocation.s_keys[i++] = LOCAL_IP;
            LELocation.s_keys[i++] = MAX_PORTS;
            LELocation.s_keys[i++] = MIGRATION;
            LELocation.s_keys[i++] = MULTILINK;
            LELocation.s_keys[i++] = MTU;
            LELocation.s_keys[i++] = NAT_TCP_TIMEOUT;
            LELocation.s_keys[i++] = NAT_OTHER_TIMEOUT;
            LELocation.s_keys[i++] = NAT_FAIL_ACTION;
            LELocation.s_keys[i++] = NAT_IN_MAP;
            LELocation.s_keys[i++] = NAT_PROXY_IN_MAP;
            LELocation.s_keys[i++] = NAT_OUT_MAP;
            LELocation.s_keys[i++] = NAT_PROXY_OUT_MAP;
            LELocation.s_keys[i++] = NAT_LOG_FAILURE;
            LELocation.s_keys[i++] = NAT_LOG_SUCCESS;
            LELocation.s_keys[i++] = NAT_LOG_SYSLOG;
            LELocation.s_keys[i++] = NAT_LOG_CONSOLE;
            LELocation.s_keys[i++] = NETMASK;
            LELocation.s_keys[i++] = OSPF_STATUS;
            LELocation.s_keys[i++] = OUTPUT_FILTER;
            LELocation.s_keys[i++] = PASSWORD;
            LELocation.s_keys[i++] = PPP_IP_TYPE;
            LELocation.s_keys[i++] = PPP_IPX_TYPE;
            LELocation.s_keys[i++] = PROTOCOL;
            LELocation.s_keys[i++] = REVERSE_DIAL;
            LELocation.s_keys[i++] = RIP_COST;
            LELocation.s_keys[i++] = RIP;
            LELocation.s_keys[i++] = RIP_V2;
            LELocation.s_keys[i++] = ROUTE_IFILTER;
            LELocation.s_keys[i++] = ROUTE_OFILTER;
            LELocation.s_keys[i++] = SECURITY_ASSN;
            LELocation.s_keys[i++] = TELEPHONE;
            LELocation.s_keys[i++] = TYPE;
            LELocation.s_keys[i++] = USERNAME;
            LELocation.s_keys[i++] = "v25bis";
            LELocation.s_keys[i++] = WANTYPE;
            LELocation.s_keys[i++] = XBAR_ADDR;
        }
        return s_keys;
    }

    public LELocation(LEConnectionFacade facade, String name) {
        super(facade);
        this.m_name = name;
        this.m_tag = "location " + this.m_name;
    }

    public Object clone() {
        LELocation config = new LELocation(this.m_facade, this.m_name);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    public void initialize() {
        this.setField(ADDRESS, "0.0.0.0");
        this.setField(ANALOG, "off");
        this.setField(ASYNC_MAP, "0x00000000");
        this.setField("script", this.createConfig("script"));
        this.setField(CHAP, "off");
        this.setField(COMPRESSION, VJ);
        this.setField(DESTINATION, SPECIFIED);
        this.setField(DOSBS, "off");
        this.setField(GROUP, "0");
        this.setField(HIGH_WATER, "0");
        this.setField(IDLE_TIMEOUT, "0 minutes");
        this.setField(INPUT_FILTER, "");
        this.setField(IP_DLCI, this.createConfig(IP_DLCI));
        this.setField(IPX_DLCI, this.createConfig(IPX_DLCI));
        this.setField(IPX_NETWORK, "");
        this.setField(LOCAL_IP, "0.0.0.0");
        this.setField(MTU, "1500");
        this.setField(MULTILINK, "off");
        this.setField(NETMASK, "0.0.0.0");
        this.setField(OUTPUT_FILTER, "");
        this.setField(PASSWORD, "");
        this.setField(PROTOCOL, PPP);
        this.setField(TELEPHONE, "");
        this.setField(TYPE, MANUAL);
        this.setField(USERNAME, "");
        this.setField("v25bis", this.createConfig("v25bis"));
    }

    public void initializeNAT() {
        this.setField(NAT_IN_MAP, "");
        this.setField(NAT_PROXY_IN_MAP, "");
        this.setField(NAT_OUT_MAP, "");
        this.setField(NAT_PROXY_OUT_MAP, "");
        this.setField(NAT_TCP_TIMEOUT, "1440 minutes");
        this.setField(NAT_OTHER_TIMEOUT, "15 seconds");
        this.setField(NAT_FAIL_ACTION, "drop");
        this.setField(NAT_LOG_CONSOLE, "off");
        this.setField(NAT_LOG_SYSLOG, "off");
        this.setField(NAT_LOG_FAILURE, "off");
        this.setField(NAT_LOG_SUCCESS, "off");
    }

    public void initializeOSPF() {
        this.setField(COST, "1");
        this.setField(DEADTIME, "40");
        this.setField(HELLOINTERVAL, "10");
        this.setField(OSPF_STATUS, "off");
        this.setField(WANTYPE, "nbma");
    }

    public void initializeIPSec() {
        this.setField(IPSEC_ACTIVE_PROFILE, "");
        this.setField(IPSEC_OUTSRC_PROFILE, "");
        this.setField(IPSEC_PASSIVE_PROFILE, "");
        this.setField(IPSEC_PDA, "drop");
        this.setField(IPSEC_LOG_CONSOLE, "off");
        this.setField(IPSEC_LOG_SYSLOG, "off");
        this.setField(IPSEC_LOG_FAILURE, "off");
        this.setField(IPSEC_LOG_SUCCESS, "off");
    }

    LEConfig createConfig(String key) {
        if (key.equals("script")) {
            return new LEDialScript(this.m_facade, String.valueOf(this.m_tag) + " " + "script");
        }
        if (key.equals("v25bis")) {
            return new LEDialScript(this.m_facade, String.valueOf(this.m_tag) + " " + "v25bis");
        }
        if (key.equals(IP_DLCI)) {
            return new LEDLCITable(this.m_facade, this.m_board, this.m_name, IP_DLCI);
        }
        if (key.equals(IPX_DLCI)) {
            return new LEDLCITable(this.m_facade, this.m_board, this.m_name, IPX_DLCI);
        }
        return new LEConfig(this.m_facade);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String protocol;
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(ADDRESS) || keys.contains(DESTINATION)) {
            String dest = (String)this.get(DESTINATION);
            if (dest != null && dest.equals(NEGOTIATED)) {
                StringBuffer buf = new StringBuffer("set ");
                buf.append(this.m_tag);
                buf.append(" destination ");
                buf.append("255.255.255.255");
                cmds.addElement(buf.toString());
            } else if (dest != null) {
                this.makeSetCommand(cmds, this.m_tag, ADDRESS, "destination");
            }
        }
        if (allCmds || keys.contains(ANALOG)) {
            this.makeSetCommand(cmds, this.m_tag, ANALOG, "analog");
        }
        if ((allCmds || keys.contains(ASYNC_MAP)) && (protocol = (String)this.get(PROTOCOL)).equals(PPP)) {
            this.makeSetCommand(cmds, this.m_tag, ASYNC_MAP, "map");
        }
        if (allCmds || keys.contains(CHAP)) {
            this.makeSetCommand(cmds, this.m_tag, CHAP, "chap");
        }
        if (allCmds || keys.contains(COMPRESSION)) {
            this.makeSetCommand(cmds, this.m_tag, COMPRESSION, "compression");
        }
        if (allCmds || keys.contains(DOSBS)) {
            this.makeSetCommand(cmds, this.m_tag, DOSBS, "voice");
        }
        if (allCmds || keys.contains(GROUP)) {
            this.makeSetCommand(cmds, this.m_tag, GROUP, "group");
        }
        if (allCmds || keys.contains(HIGH_WATER)) {
            this.makeSetCommand(cmds, this.m_tag, HIGH_WATER, "high_water");
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_tag, IDLE_TIMEOUT, "idle");
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, INPUT_FILTER, "ifilter");
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_tag, IPX_NETWORK, "ipxnet");
        }
        if (allCmds || keys.contains(LOCAL_IP)) {
            this.makeSetCommand(cmds, this.m_tag, LOCAL_IP, "local-ip-address");
        }
        if (allCmds || keys.contains(MAX_PORTS)) {
            this.makeSetCommand(cmds, this.m_tag, MAX_PORTS, "maxports");
        }
        if (allCmds || keys.contains(MULTILINK)) {
            this.makeSetCommand(cmds, this.m_tag, MULTILINK, "multilink");
        }
        if (allCmds || keys.contains(MTU)) {
            this.makeSetCommand(cmds, this.m_tag, MTU, "mtu");
        }
        if (allCmds || keys.contains(NAT_TCP_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_tag, NAT_TCP_TIMEOUT, NAT_TCP_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_OTHER_TIMEOUT)) {
            this.makeNATTimeOutCommand(cmds, this.m_tag, NAT_OTHER_TIMEOUT, NAT_OTHER_TIMEOUT);
        }
        if (allCmds || keys.contains(NAT_FAIL_ACTION)) {
            this.makeNATFailActionCommand(cmds, this.m_tag, NAT_FAIL_ACTION);
        }
        if (allCmds || keys.contains(NAT_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_tag, NAT_IN_MAP, true, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_IN_MAP)) {
            this.makeNATMapCommand(cmds, this.m_tag, NAT_PROXY_IN_MAP, true, true);
        }
        if (allCmds || keys.contains(NAT_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_tag, NAT_OUT_MAP, false, false);
        }
        if (allCmds || keys.contains(NAT_PROXY_OUT_MAP)) {
            this.makeNATMapCommand(cmds, this.m_tag, NAT_PROXY_OUT_MAP, false, true);
        }
        if (allCmds || keys.contains(NAT_LOG_FAILURE)) {
            this.makeNATLogCommand(cmds, this.m_tag, NAT_LOG_FAILURE, NAT_LOG_FAILURE);
        }
        if (allCmds || keys.contains(NAT_LOG_SUCCESS)) {
            this.makeNATLogCommand(cmds, this.m_tag, NAT_LOG_SUCCESS, NAT_LOG_SUCCESS);
        }
        if (allCmds || keys.contains(NAT_LOG_SYSLOG)) {
            this.makeNATLogCommand(cmds, this.m_tag, NAT_LOG_SYSLOG, NAT_LOG_SYSLOG);
        }
        if (allCmds || keys.contains(NAT_LOG_CONSOLE)) {
            this.makeNATLogCommand(cmds, this.m_tag, NAT_LOG_CONSOLE, NAT_LOG_CONSOLE);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_tag, NETMASK, "netmask");
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, OUTPUT_FILTER, "ofilter");
        }
        if (allCmds || keys.contains(PASSWORD)) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, "password");
        }
        if (allCmds || keys.contains(PROTOCOL)) {
            this.makeSetCommand(cmds, this.m_tag, PROTOCOL, "protocol");
        }
        if (allCmds || keys.contains(REVERSE_DIAL)) {
            this.makeSetCommand(cmds, this.m_tag, REVERSE_DIAL, "reverse-dial");
        }
        if (allCmds || keys.contains(SECURITY_ASSN)) {
            this.makeSetCommand(cmds, this.m_tag, SECURITY_ASSN, "sa");
        }
        if (allCmds || keys.contains(TELEPHONE)) {
            this.makeSetCommand(cmds, this.m_tag, TELEPHONE, "phone");
        }
        if (allCmds || keys.contains(USERNAME)) {
            this.makeSetCommand(cmds, this.m_tag, USERNAME, "username");
        }
        if (allCmds || keys.contains(XBAR_ADDR)) {
            this.makeSetCommand(cmds, this.m_tag, XBAR_ADDR, "crossbar-ip");
        }
        if ((allCmds || keys.contains(TYPE)) && (protocol = (String)this.get(PROTOCOL)) != null && !protocol.equals(FRAME_RELAY)) {
            String dialtype = (String)this.get(TYPE);
            if (dialtype.equals("on_demand")) {
                this.makeSetCommand(cmds, this.m_tag, ON_DEMAND, null);
            } else {
                this.makeSetCommand(cmds, this.m_tag, TYPE, null);
            }
        }
        if (allCmds || keys.contains(RIP) || keys.contains(RIP_V2)) {
            String rip = (String)this.get(RIP);
            if (allCmds) {
                this.makeRIPCommand(cmds, this.m_tag, RIP, (String)this.get(RIP));
                this.makeRIPv2Command(cmds, this.m_tag, "rip v2", (String)this.get(RIP), (String)this.get(RIP_V2));
            } else if (keys != null && keys.contains(RIP) && rip != null && !rip.equals(V2)) {
                this.makeRIPCommand(cmds, this.m_tag, RIP, (String)this.get(RIP));
            } else {
                this.makeRIPv2Command(cmds, this.m_tag, "rip v2", (String)this.get(RIP), (String)this.get(RIP_V2));
            }
        }
        if (allCmds || keys.contains(RIP_COST)) {
            this.makeSetCommand(cmds, this.m_tag, RIP_COST, "rip cost");
        }
        if ((allCmds || keys.contains(OSPF_STATUS) || keys.contains(COST) || keys.contains(MIGRATION) || keys.contains(HELLOINTERVAL) || keys.contains(DEADTIME) || keys.contains(WANTYPE)) && this.get(OSPF_STATUS) != null) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("set ");
            buf.append(this.m_tag);
            buf.append(" ospf ");
            String status = (String)this.get(OSPF_STATUS);
            buf.append(status);
            if (status.equals("on")) {
                String wantype;
                String dead;
                String hello;
                String migration;
                String cost = (String)this.get(COST);
                if (cost != null && cost.length() > 0) {
                    buf.append(" cost ");
                    buf.append(cost);
                }
                if ((migration = (String)this.get(MIGRATION)) != null && migration.length() > 0) {
                    buf.append(" accept-rip ");
                    buf.append(migration);
                }
                if ((hello = (String)this.get(HELLOINTERVAL)) != null && hello.length() > 0) {
                    buf.append(" hello-interval ");
                    buf.append(hello);
                }
                if ((dead = (String)this.get(DEADTIME)) != null && dead.length() > 0) {
                    buf.append(" dead-time ");
                    buf.append(dead);
                }
                if ((wantype = (String)this.get(WANTYPE)) != null && wantype.length() > 0) {
                    buf.append(" ");
                    buf.append(wantype);
                }
            }
            buf.append(" ");
            cmds.add(new String(buf));
        }
        if (allCmds || keys.contains(IPSEC_LOG_FAILURE)) {
            this.makeIPSecLogCommand(cmds, this.m_tag, IPSEC_LOG_FAILURE, IPSEC_LOG_FAILURE);
        }
        if (allCmds || keys.contains(IPSEC_LOG_SUCCESS)) {
            this.makeIPSecLogCommand(cmds, this.m_tag, IPSEC_LOG_SUCCESS, IPSEC_LOG_SUCCESS);
        }
        if (allCmds || keys.contains(IPSEC_LOG_SYSLOG)) {
            this.makeIPSecLogCommand(cmds, this.m_tag, IPSEC_LOG_SYSLOG, IPSEC_LOG_SYSLOG);
        }
        if (allCmds || keys.contains(IPSEC_LOG_CONSOLE)) {
            this.makeIPSecLogCommand(cmds, this.m_tag, IPSEC_LOG_CONSOLE, IPSEC_LOG_CONSOLE);
        }
        if (allCmds || keys.contains(IPSEC_OUTSRC_PROFILE)) {
            this.makeIPSecProfileCommand(cmds, this.m_tag, IPSEC_OUTSRC_PROFILE, IPSEC_OUTSRC_PROFILE);
        }
        if (allCmds || keys.contains(IPSEC_ACTIVE_PROFILE)) {
            this.makeIPSecProfileCommand(cmds, this.m_tag, IPSEC_ACTIVE_PROFILE, IPSEC_ACTIVE_PROFILE);
        }
        if (allCmds || keys.contains(IPSEC_PDA)) {
            this.makeIPSecPDACommand(cmds, this.m_tag, IPSEC_PDA, IPSEC_PDA);
        }
        if (allCmds || keys.contains(ROUTE_IFILTER)) {
            this.makeSetCommand(cmds, this.m_tag, ROUTE_IFILTER, "route-filter incoming");
        }
        if (allCmds || keys.contains(ROUTE_OFILTER)) {
            this.makeSetCommand(cmds, this.m_tag, ROUTE_OFILTER, "route-filter outgoing");
        }
        return cmds.size() > start;
    }
}

