/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEPMCommand;
import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEPort
extends LEConfig {
    public static final String DEVICE = "device";
    public static final String DIALIN = "dialin";
    public static final String DIALOUT = "dialout";
    public static final String HARDWIRED = "hardwired";
    public static final String LOGIN = "login";
    public static final String NONE = "none";
    public static final String TWOWAY = "twoway";
    String m_name;

    public LEPort(LEConnectionFacade facade, String board, String name) {
        super(facade, board);
        this.m_name = name;
    }

    public static final LEPMCommand ResetPort(LEConnectionFacade facade, String port) {
        String cmd = new String("reset " + port);
        return facade.execute(cmd);
    }

    public Object clone() {
        LEPort config = new LEPort(this.m_facade, this.m_board, this.m_name);
        config.copy(this);
        return config;
    }

    public LEVector reset() {
        LEVector errors = null;
        LEPMCommand ret = this.setView();
        if (ret == null || ret.getStatus()) {
            StringBuffer buf = new StringBuffer("reset ");
            buf.append(this.m_name);
            ret = this.m_facade.execute(buf.toString());
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public String getName() {
        return this.m_name;
    }

    boolean makeTypeCommand(LEVector cmds, String portType, String networkType, String device) {
        String suffix = this.getTypeCommandSuffix(portType, networkType, device);
        return this.makeTypeCommand(cmds, suffix);
    }

    boolean makeTypeCommand(LEVector cmds, String suffix) {
        if (suffix == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append(this.m_name);
        buf.append(' ');
        buf.append(suffix);
        cmds.addElement(new String(buf));
        return true;
    }

    String getTypeCommandSuffix(String portType, String networkType, String device) {
        if (networkType == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        if (networkType.equals(HARDWIRED)) {
            buf.append("network hardwired");
        } else {
            boolean isDevice = false;
            if (portType != null) {
                if (portType.equals(TWOWAY) && device.length() > 0) {
                    buf.append("twoway ");
                    buf.append(device);
                    buf.append(' ');
                } else if (portType.equals(DEVICE) && device.length() > 0) {
                    buf.append("device ");
                    buf.append(device);
                    buf.append(' ');
                } else {
                    buf.append("login ");
                }
            }
            if (networkType.equals(TWOWAY)) {
                buf.append("network twoway");
            } else if (networkType.equals(DIALIN)) {
                buf.append("network dialin");
            } else if (networkType.equals(DIALOUT)) {
                buf.append("network dialout");
            }
        }
        return new String(buf);
    }
}

