/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEIPIPSA;
import com.lucent.ra.nms.model.LEIPIPSAs;
import com.lucent.ra.nms.model.LEIPSecProfile;
import com.lucent.ra.nms.model.LEIPSecProfileRule;
import com.lucent.ra.nms.model.LEIPSecProfiles;
import com.lucent.ra.nms.model.LEIPSecSA;
import com.lucent.ra.nms.model.LEIPSecSAs;
import com.lucent.ra.nms.model.LEProxySA;
import com.lucent.ra.nms.model.LEProxySAs;
import com.lucent.ra.nms.model.LESA;
import com.lucent.ra.nms.model.LESAs;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEVector;
import com.oroinc.text.regex.MalformedPatternException;
import com.oroinc.text.regex.MatchResult;
import com.oroinc.text.regex.Pattern;
import com.oroinc.text.regex.Perl5Compiler;
import com.oroinc.text.regex.Perl5Matcher;
import com.oroinc.text.regex.Perl5Pattern;

public class LEVPNFileParser {
    private static final String ADD_SA_STRING = "add\\s+sa\\s+(\\S+)";
    private static final String PROPOSAL_STRING = "set\\s+sa\\s+(\\S+)\\s+sec-p\\w*\\s+(\\S+)\\s*(\\S*)";
    private static final String ESP_IN_KEY_STRING = "set\\s+sa\\s+(\\S+)\\s+esp-inb\\w*-key\\s+(\\S+)";
    private static final String ESP_OUT_KEY_STRING = "set\\s+sa\\s+(\\S+)\\s+esp-outb\\w*-key\\s+(\\S+)";
    private static final String ESP_IN_SPI_STRING = "set\\s+sa\\s+(\\S+)\\s+esp-inb\\w*-spi\\s+(\\S+)";
    private static final String ESP_OUT_SPI_STRING = "set\\s+sa\\s+(\\S+)\\s+esp-outb\\w*-spi\\s+(\\S+)";
    private static final String AH_IN_KEY_STRING = "set\\s+sa\\s+(\\S+)\\s+ah-inb\\w*-key\\s+(\\S+)";
    private static final String AH_OUT_KEY_STRING = "set\\s+sa\\s+(\\S+)\\s+ah-outb\\w*-key\\s+(\\S+)";
    private static final String AH_IN_SPI_STRING = "set\\s+sa\\s+(\\S+)\\s+ah-inb\\w*-spi\\s+(\\S+)";
    private static final String AH_OUT_SPI_STRING = "set\\s+sa\\s+(\\S+)\\s+ah-outb\\w*-spi\\s+(\\S+)";
    private static final String SA_LOCALADDR_STRING = "set\\s+sa\\s+(\\S+)\\s+local\\S*\\s+(\\S+)";
    private static final String SA_LOCALPROXY_STRING = "set\\s+sa\\s+(\\S+)\\s+proxy-localp\\w*\\s+(\\S+)";
    private static final String SA_DESTPROXY_STRING = "set\\s+sa\\s+(\\S+)\\s+proxy-destp\\w*\\s+(\\S+)";
    private static final String SA_IPSECMODE_STRING = "set\\s+sa\\s+(\\S+)\\s+mo\\w*\\s+sec-ipip\\S*";
    private static final String SA_IPIPMODE_STRING = "set\\s+sa\\s+(\\S+)\\s+mo\\w*\\s+ipip\\S*";
    private static final String SA_PROXYMODE_STRING = "set\\s+sa\\s+(\\S+)\\s+mo\\w*\\s+pr\\S*";
    private static final String SA_PROXY_SECRET_STRING = "set\\s+sa\\s+(\\S+)\\s+proxy-secret\\s+(\\S+)";
    private static final String SA_PEER_IDENT_STRING = "set\\s+sa\\s+(\\S+)\\s+peer\\S*\\s+(\\S+)";
    private static final String ADD_PROFILE_STRING = "add\\s+sec-prof\\w*\\s+(\\S+)";
    private static final String SEC_PFILTER_STRING = "set\\s+sec-prof\\w*\\s+(\\S+)\\s+(\\d+)\\s+p\\S*f\\w*\\s+(\\S+)";
    private static final String SEC_SA_STRING = "set\\s+sec-prof\\w*\\s+(\\S+)\\s+(\\d+)\\s+static\\S+\\s+(\\S+)";
    LESAs m_sas = new LESAs(null);
    LESA m_sa;
    LEIPSecSAs m_ipsecsas = new LEIPSecSAs(null);
    LEIPIPSAs m_ipipsas = new LEIPIPSAs(null);
    LEProxySAs m_proxysas = new LEProxySAs(null);
    LETable m_table;
    LEIPSecProfiles m_profiles;
    LEIPSecProfile m_profile;
    LEIPSecProfileRule m_profileRule;
    String m_name;
    String m_mode;
    Perl5Matcher m_matcher;
    MatchResult m_result;
    Perl5Pattern m_addsaPattern;
    Perl5Pattern m_proposalPattern;
    Perl5Pattern m_espinkeyPattern;
    Perl5Pattern m_espoutkeyPattern;
    Perl5Pattern m_espinspiPattern;
    Perl5Pattern m_espoutspiPattern;
    Perl5Pattern m_ahinkeyPattern;
    Perl5Pattern m_ahoutkeyPattern;
    Perl5Pattern m_ahinspiPattern;
    Perl5Pattern m_ahoutspiPattern;
    Perl5Pattern m_salocaladdrPattern;
    Perl5Pattern m_salocalproxyPattern;
    Perl5Pattern m_sadestproxyPattern;
    Perl5Pattern m_saipsecmodePattern;
    Perl5Pattern m_saipipmodePattern;
    Perl5Pattern m_saproxymodePattern;
    Perl5Pattern m_saproxysecretPattern;
    Perl5Pattern m_sapeeridentPattern;
    Perl5Pattern m_addprofilePattern;
    Perl5Pattern m_secfilterPattern;
    Perl5Pattern m_secsaPattern;

    public LEVPNFileParser() {
        this.m_sas.setField("ipsec", this.m_ipsecsas);
        this.m_sas.setField("ipip", this.m_ipipsas);
        this.m_sas.setField("proxy", this.m_proxysas);
        this.m_table = new LETable(null);
        this.m_profiles = new LEIPSecProfiles(null);
        this.m_matcher = new Perl5Matcher();
        this.m_name = "";
    }

    public boolean createPatterns() {
        Perl5Compiler compiler = new Perl5Compiler();
        try {
            this.m_addsaPattern = (Perl5Pattern)compiler.compile(ADD_SA_STRING, 1);
            this.m_proposalPattern = (Perl5Pattern)compiler.compile(PROPOSAL_STRING, 1);
            this.m_espinkeyPattern = (Perl5Pattern)compiler.compile(ESP_IN_KEY_STRING, 1);
            this.m_espoutkeyPattern = (Perl5Pattern)compiler.compile(ESP_OUT_KEY_STRING, 1);
            this.m_espinspiPattern = (Perl5Pattern)compiler.compile(ESP_IN_SPI_STRING, 1);
            this.m_espoutspiPattern = (Perl5Pattern)compiler.compile(ESP_OUT_SPI_STRING, 1);
            this.m_ahinkeyPattern = (Perl5Pattern)compiler.compile(AH_IN_KEY_STRING, 1);
            this.m_ahoutkeyPattern = (Perl5Pattern)compiler.compile(AH_OUT_KEY_STRING, 1);
            this.m_ahinspiPattern = (Perl5Pattern)compiler.compile(AH_IN_SPI_STRING, 1);
            this.m_ahoutspiPattern = (Perl5Pattern)compiler.compile(AH_OUT_SPI_STRING, 1);
            this.m_salocaladdrPattern = (Perl5Pattern)compiler.compile(SA_LOCALADDR_STRING, 1);
            this.m_salocalproxyPattern = (Perl5Pattern)compiler.compile(SA_LOCALPROXY_STRING, 1);
            this.m_sadestproxyPattern = (Perl5Pattern)compiler.compile(SA_DESTPROXY_STRING, 1);
            this.m_saipsecmodePattern = (Perl5Pattern)compiler.compile(SA_IPSECMODE_STRING, 1);
            this.m_saipipmodePattern = (Perl5Pattern)compiler.compile(SA_IPIPMODE_STRING, 1);
            this.m_saproxymodePattern = (Perl5Pattern)compiler.compile(SA_PROXYMODE_STRING, 1);
            this.m_saproxysecretPattern = (Perl5Pattern)compiler.compile(SA_PROXY_SECRET_STRING, 1);
            this.m_sapeeridentPattern = (Perl5Pattern)compiler.compile(SA_PEER_IDENT_STRING, 1);
            this.m_addprofilePattern = (Perl5Pattern)compiler.compile(ADD_PROFILE_STRING, 1);
            this.m_secfilterPattern = (Perl5Pattern)compiler.compile(SEC_PFILTER_STRING, 1);
            this.m_secsaPattern = (Perl5Pattern)compiler.compile(SEC_SA_STRING, 1);
        }
        catch (MalformedPatternException e) {
            LEDebug.getLog().logln(20, e);
            return false;
        }
        return true;
    }

    public void readVPN(LEVector cmds) {
        int len = cmds.size();
        try {
            int i = 0;
            while (i < len) {
                String line = (String)cmds.elementAt(i);
                if (!line.startsWith("#") && line.length() >= 3 && !line.equals("save all")) {
                    int strlen = line.length();
                    String begin = line.substring(3, strlen).toLowerCase();
                    if (line.regionMatches(true, 0, "add ", 0, 4)) {
                        MatchResult result;
                        if (this.m_matcher.contains(line, (Pattern)this.m_addsaPattern)) {
                            result = this.m_matcher.getMatch();
                            this.addSA(result.group(1));
                        } else if (this.m_matcher.contains(line, (Pattern)this.m_addprofilePattern)) {
                            result = this.m_matcher.getMatch();
                            this.addSecProfile(result.group(1));
                        }
                    } else if (line.regionMatches(true, 0, "set ", 0, 4)) {
                        this.parseVPN(line);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }

    public LESAs getSecurityAssociations() {
        return this.m_sas;
    }

    public LEIPSecProfiles getSecProfiles() {
        return this.m_profiles;
    }

    protected void setSA(MatchResult result) {
        String name = result.group(1);
        if (!name.equals(this.m_name)) {
            this.m_sa = this.m_sas.getSA(name);
            this.m_name = name;
        }
        if (this.m_sa == null) {
            this.m_sa = (LESA)this.m_table.get(name);
        }
    }

    protected void setSAParameter(String attribute, MatchResult result) {
        this.setSA(result);
        String group2 = result.group(2);
        if (group2 != null && this.m_sa != null) {
            this.m_sa.setField(attribute, result.group(2));
        }
    }

    protected void setIPSecModeParameter(MatchResult result) {
        String name = result.group(1);
        this.setSA(result);
        LEIPSecSA sa = new LEIPSecSA(null, name);
        sa.copy(this.m_sa);
        sa.setField("289", "sec-ipip-tunnel");
        this.m_ipsecsas.setField(name, sa);
        this.m_sa = sa;
    }

    protected void setIPIPModeParameter(MatchResult result) {
        String name = result.group(1);
        this.setSA(result);
        LEIPIPSA sa = new LEIPIPSA(null, name);
        sa.copy(this.m_sa);
        sa.setField("289", "ipip-tunnel");
        this.m_ipipsas.setField(name, sa);
        this.m_sa = sa;
    }

    protected void setProxyModeParameter(MatchResult result) {
        String name = result.group(1);
        this.setSA(result);
        LEProxySA sa = new LEProxySA(null, name);
        sa.copy(this.m_sa);
        sa.setField("289", "proxy-tunnel");
        this.m_proxysas.setField(name, sa);
        this.m_sa = sa;
    }

    protected void addSA(String name) {
        this.m_sa = new LESA(null, name);
        this.m_table.set(name, this.m_sa);
    }

    protected void addSecProfile(String name) {
        this.m_profile = new LEIPSecProfile(null, name);
        this.m_profiles.setField(name, this.m_profile);
    }

    protected void setProfileRule(MatchResult result) {
        String name = result.group(1);
        this.m_profile = (LEIPSecProfile)this.m_profiles.get(name);
        String number = result.group(2);
        this.m_profileRule = (LEIPSecProfileRule)this.m_profile.get(number);
        if (this.m_profileRule == null) {
            this.m_profileRule = new LEIPSecProfileRule(null, name, number);
            this.m_profile.setField(number, this.m_profileRule);
        }
    }

    protected void setProfileParameter(String attribute, MatchResult result) {
        this.setProfileRule(result);
        if (this.m_profileRule != null) {
            String value = result.group(3);
            this.m_profileRule.setField(attribute, value);
        }
    }

    protected void parseVPN(String line) {
        try {
            if (this.m_matcher.contains(line, (Pattern)this.m_proposalPattern)) {
                MatchResult result = this.m_matcher.getMatch();
                String prop1 = result.group(2);
                String prop2 = result.group(3);
                this.setSA(result);
                if (prop1.startsWith("esp")) {
                    this.m_sa.setField("226", prop1);
                    if (prop2 != null) {
                        this.m_sa.setField("227", prop2);
                    }
                } else {
                    this.m_sa.setField("227", prop1);
                }
            } else if (this.m_matcher.contains(line, (Pattern)this.m_saipsecmodePattern)) {
                this.setIPSecModeParameter(this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_saipipmodePattern)) {
                this.setIPIPModeParameter(this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_saproxymodePattern)) {
                this.setProxyModeParameter(this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_espinkeyPattern)) {
                this.setSAParameter("232", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_espoutkeyPattern)) {
                this.setSAParameter("234", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_espinspiPattern)) {
                this.setSAParameter("228", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_espoutspiPattern)) {
                this.setSAParameter("230", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_ahinkeyPattern)) {
                this.setSAParameter("233", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_ahoutkeyPattern)) {
                this.setSAParameter("235", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_ahinspiPattern)) {
                this.setSAParameter("229", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_ahoutspiPattern)) {
                this.setSAParameter("231", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_salocaladdrPattern)) {
                this.setSAParameter("236", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_salocalproxyPattern)) {
                this.setSAParameter("238", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_sadestproxyPattern)) {
                this.setSAParameter("239", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_sapeeridentPattern)) {
                this.setSAParameter("74", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_secfilterPattern)) {
                this.setProfileParameter("505", this.m_matcher.getMatch());
            } else if (this.m_matcher.contains(line, (Pattern)this.m_secsaPattern)) {
                this.setProfileParameter("506", this.m_matcher.getMatch());
            }
        }
        catch (Exception e) {
            LEDebug.getLog().logln(20, e);
        }
    }
}

