/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.dTree;

import oracle.ewt.dTree.DTree;
import oracle.ewt.dTree.DTreeChildManager;
import oracle.ewt.dTree.DTreeDeferringParent;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeItemFactory;
import oracle.ewt.dTree.OneDSparseArray;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;

public class DTreeSparseChildManager
implements DTreeChildManager,
OneDDataSourceListener {
    private DTreeDeferringParent _parent;
    private OneDSparseArray _children;
    private DTreeItem[] _expandedchildren;
    private int _nexpanded;
    private int _subht;

    public DTreeSparseChildManager(DTreeDeferringParent dTreeDeferringParent) {
        this._parent = dTreeDeferringParent;
        OneDDataSource oneDDataSource = dTreeDeferringParent.getDataSource();
        if (oneDDataSource != null) {
            oneDDataSource.addDataSourceListener(this);
        }
    }

    public void childExpansionChanged(DTreeItem dTreeItem) {
        if (dTreeItem.isExpanded()) {
            this._addExpandedChild(dTreeItem);
            return;
        }
        this._removeExpandedChild(dTreeItem);
    }

    public int getChildX(int n) {
        DTree dTree = this._parent.getTree();
        int n2 = this._parent.getX();
        if (this._parent == dTree.getRoot()) {
            return n2;
        }
        return n2 + this.getChildrenXOffset(dTree.getIndentWidth());
    }

    public int getChildY(int n) {
        int n2 = this._parent.getY();
        int n3 = this._parent.getHeight();
        int n4 = this._parent.getChildHeight();
        int n5 = 0;
        int n6 = n2 + this.getChildrenYOffset(n3);
        if (this._parent.isExpanded() && this._nexpanded != 0) {
            int n7 = 0;
            while (n7 < this._nexpanded) {
                DTreeItem dTreeItem = this._expandedchildren[n7];
                int n8 = dTreeItem.getIndex();
                if (n <= n8) break;
                n6 += (n8 - n5) * n4 + dTreeItem.getSubTreeHeight();
                n5 = n8 + 1;
                ++n7;
            }
        }
        return n6 + (n - n5) * n4;
    }

    public DTreeItem getItem(int n) {
        DTreeItemFactory dTreeItemFactory;
        DTreeItem dTreeItem;
        if (this._children == null) {
            this._children = new OneDSparseArray();
        }
        if ((dTreeItem = (DTreeItem)this._children.getElement(n)) == null && (dTreeItem = (dTreeItemFactory = this._parent.getItemFactory()).createItem(this._parent, n)) != null) {
            this._children.setElement(dTreeItem, n);
            dTreeItem.itemAdded(this._parent, n);
        }
        return dTreeItem;
    }

    public DTreeItem getItemAt(int n, int n2) {
        int n3 = this._parent.getSubTreeHeight();
        if (n2 >= n3) {
            return null;
        }
        int n4 = this._parent.getHeight();
        if (n2 < n4) {
            return this._parent;
        }
        int n5 = this._parent.getChildHeight();
        int n6 = 0;
        int n7 = this.getChildrenYOffset(n4);
        if (this._parent.isExpanded() && this._nexpanded != 0) {
            this._parent.getY();
            int n8 = 0;
            while (n8 < this._nexpanded) {
                DTreeItem dTreeItem = this._expandedchildren[n8];
                int n9 = dTreeItem.getIndex();
                int n10 = n7 + (n9 - n6) * n5;
                n3 = dTreeItem.getSubTreeHeight();
                if (n2 < n10) break;
                if (n2 < n10 + n3) {
                    return dTreeItem.getItemAt(n, n2 - n10);
                }
                n7 = n10 + n3;
                n6 = n9 + 1;
                ++n8;
            }
        }
        return this._parent.getItem(n6 + (n2 - n7) / n5);
    }

    public DTreeItem getNextExpandedChild(DTreeItem dTreeItem) {
        DTreeItem dTreeItem2 = null;
        if (dTreeItem == null) {
            if (this._nexpanded > 0) {
                dTreeItem2 = this._expandedchildren[0];
            }
        } else {
            int n = 0;
            while (n < this._nexpanded) {
                if (this._expandedchildren[n] == dTreeItem) break;
                ++n;
            }
            if (n < this._nexpanded - 1) {
                dTreeItem2 = this._expandedchildren[n + 1];
            }
        }
        return dTreeItem2;
    }

    public int getSubTreeHeight() {
        return this._subht;
    }

    public void invalidateItems(OneDDataSourceEvent oneDDataSourceEvent) {
        DTree dTree = this._parent.getTree();
        dTree.itemsInvalidated(this._parent, oneDDataSourceEvent.getStartIndex(), oneDDataSourceEvent.getItemCount());
    }

    public void itemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
        int n = oneDDataSourceEvent.getStartIndex();
        int n2 = oneDDataSourceEvent.getItemCount();
        OneDDataSource oneDDataSource = this._parent.getDataSource();
        oneDDataSource.getItemCount();
        if (this._children != null) {
            this._children.insertElements(n, n2);
            int n3 = this._children.getNextIndex(n);
            while (n3 != -1) {
                DTreeItem dTreeItem = (DTreeItem)this._children.getElement(n3);
                if (dTreeItem != null) {
                    dTreeItem.setIndex(n3);
                }
                n3 = this._children.getNextIndex(n3);
            }
        }
        DTree dTree = this._parent.getTree();
        dTree.itemsAdded(this._parent, n, n2);
    }

    public void itemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
        int n = oneDDataSourceEvent.getStartIndex();
        int n2 = oneDDataSourceEvent.getItemCount();
        OneDDataSource oneDDataSource = this._parent.getDataSource();
        oneDDataSource.getItemCount();
        if (this._children != null) {
            Object object;
            int n3 = n;
            while (n3 != -1 && n3 < n + n2) {
                object = (DTreeItem)this._children.getElement(n3);
                if (object != null) {
                    if (object.isExpanded()) {
                        object.setExpanded(false);
                    }
                    object.itemRemoved();
                }
                n3 = this._children.getNextIndex(n3);
            }
            this._children.removeElements(n, n2);
            n3 = n;
            while (n3 != -1) {
                object = (DTreeItem)this._children.getElement(n3);
                if (object != null) {
                    object.setIndex(n3);
                }
                n3 = this._children.getNextIndex(n3);
            }
            object = this._parent.getTree();
            ((DTree)object).itemsRemoved(this._parent, n, n2);
        }
    }

    public void layout(int n, int n2) {
        int n3 = this._parent.getHeight();
        if (this._parent.isExpanded() && this._parent.getItemCount() != 0) {
            DTree dTree = this._parent.getTree();
            int n4 = this.getChildrenYOffset(n3);
            int n5 = 0;
            if (this._parent != dTree.getRoot()) {
                n5 = this.getChildrenXOffset(dTree.getIndentWidth());
            }
            int n6 = this._layoutChildren(n + n5, n2 + n4);
            this._subht = Math.max(n3, n4 + n6);
            return;
        }
        this._subht = n3;
    }

    protected int getChildrenXOffset(int n) {
        return n;
    }

    protected int getChildrenYOffset(int n) {
        return n;
    }

    protected DTreeItem getParent() {
        return this._parent;
    }

    private void _addExpandedChild(DTreeItem dTreeItem) {
        if (this._expandedchildren == null) {
            this._expandedchildren = new DTreeItem[1];
        }
        if (this._nexpanded == this._expandedchildren.length) {
            DTreeItem[] dTreeItemArray = new DTreeItem[this._expandedchildren.length * 2];
            System.arraycopy(this._expandedchildren, 0, dTreeItemArray, 0, this._nexpanded);
            this._expandedchildren = dTreeItemArray;
        }
        int n = dTreeItem.getIndex();
        int n2 = 0;
        while (n2 < this._nexpanded) {
            if (n < this._expandedchildren[n2].getIndex()) {
                System.arraycopy(this._expandedchildren, n2, this._expandedchildren, n2 + 1, this._nexpanded - n2);
                break;
            }
            ++n2;
        }
        this._expandedchildren[n2] = dTreeItem;
        ++this._nexpanded;
    }

    private int _layoutChildren(int n, int n2) {
        int n3 = 0;
        int n4 = this._parent.getChildHeight();
        if (this._parent.isExpanded() && this._nexpanded != 0) {
            int n5 = 0;
            int n6 = 0;
            while (n6 < this._nexpanded) {
                DTreeItem dTreeItem = this._expandedchildren[n6];
                n5 = (dTreeItem.getIndex() - n6) * n4 + n3;
                dTreeItem.layout(n, n2 + n5);
                n3 += dTreeItem.getSubTreeHeight();
                ++n6;
            }
        }
        return n3 + (this._parent.getItemCount() - this._nexpanded) * n4;
    }

    private void _removeExpandedChild(DTreeItem dTreeItem) {
        int n = 0;
        while (n < this._nexpanded) {
            if (this._expandedchildren[n] == dTreeItem) {
                if (n != this._nexpanded - 1) {
                    System.arraycopy(this._expandedchildren, n + 1, this._expandedchildren, n, this._nexpanded - n - 1);
                }
                --this._nexpanded;
                this._expandedchildren[this._nexpanded] = null;
                return;
            }
            ++n;
        }
    }
}

