/*
 * Decompiled with CFR 0.152.
 */
package oracle.ewt.multiLineLabel;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Locale;
import oracle.ewt.EwtComponent;
import oracle.ewt.multiLineLabel.LabelGeometry;
import oracle.ewt.multiLineLabel.LineInfo;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.textWrapper.NoWrapper;
import oracle.ewt.textWrapper.TextWrapper;

public class MultiLineLabel
extends EwtComponent {
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_RIGHT = 1;
    public static final int ALIGNMENT_CENTER = 2;
    public static final float ASPECTRATIO_NONE = 0.0f;
    private boolean _isWrappingLocked;
    private int _alignment;
    private boolean _useFullJustification;
    private float _preferredAspectRatio;
    private LabelGeometry _geometry;
    private Adjustable _hAdjustable;
    private Adjustable _vAdjustable;

    public MultiLineLabel() {
        this("");
    }

    public MultiLineLabel(String string) {
        this(NoWrapper.getTextWrapper(), string);
    }

    public MultiLineLabel(TextWrapper textWrapper, String string) {
        this._geometry = new LabelGeometry(this, textWrapper, string);
        this._alignment = 0;
        this._isWrappingLocked = true;
        this._preferredAspectRatio = 4.0f;
    }

    public void setText(String string) {
        this._geometry._setText(string);
    }

    public String getText() {
        return this._geometry._getText();
    }

    public void setTextWrapper(TextWrapper textWrapper) {
        this._geometry._setTextWrapper(textWrapper);
    }

    public TextWrapper getTextWrapper() {
        return this._geometry._getTextWrapper();
    }

    public void setWrappingLocked(boolean bl) {
        if (this._isWrappingLocked != bl) {
            this._isWrappingLocked = bl;
            if (bl) {
                this.setWrapWidth(this.getInnerSize().width);
            }
        }
    }

    public boolean isWrappingLocked() {
        return this._isWrappingLocked;
    }

    public void setWrapWidth(int n) {
        this._setWrapWidthNoResize(n);
        if (this.isWrappingLocked()) {
            super.setSize(this.convertInnerToOuterSize((int)n, (int)0).width, this.getSize().height);
        }
    }

    public int getWrapWidth() {
        return this._geometry.getWrapWidth();
    }

    public void setAlignment(int n) {
        if (this._alignment != n) {
            this._alignment = n;
            this.repaint();
        }
    }

    public int getAlignment() {
        return this._alignment;
    }

    public void setFullJustification(boolean bl) {
        if (this._useFullJustification != bl) {
            this._useFullJustification = bl;
            this.repaint();
        }
    }

    public boolean isFullyJustified() {
        return this._useFullJustification;
    }

    public void setPreferredAspectRatio(float f) {
        if (this._preferredAspectRatio != f) {
            this._preferredAspectRatio = f;
            this.invalidate();
        }
    }

    public float getPreferredAspectRatio() {
        return this._preferredAspectRatio;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this._geometry._setFontMetrics(this.getFontMetrics(this.getFont()));
    }

    public void setLocale(Locale locale) {
        if (locale != this.getLocale()) {
            super.setLocale(locale);
            this.invalidate();
        }
    }

    public void doLayout() {
        this._geometry._validate();
        super.doLayout();
    }

    public boolean isHScrollable() {
        return true;
    }

    public boolean isVScrollable() {
        return true;
    }

    public Adjustable getHAdjustable() {
        return this._hAdjustable;
    }

    public Adjustable getVAdjustable() {
        return this._vAdjustable;
    }

    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable != null) {
            throw new ScrollableException();
        }
        this._hAdjustable = adjustable;
    }

    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._vAdjustable != null) {
            throw new ScrollableException();
        }
        this._vAdjustable = adjustable;
    }

    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this._hAdjustable == adjustable) {
            this._hAdjustable = null;
            return;
        }
        if (this._vAdjustable == adjustable) {
            this._vAdjustable = null;
            return;
        }
        throw new ScrollableException();
    }

    protected int getVMaximum() {
        return this._geometry.getLineCount();
    }

    protected int getVOffsetOfValue(int n) {
        return -this._geometry.getFontMetrics().getHeight() * n;
    }

    protected int getVValueOfOffset(int n) {
        return -n / this._geometry.getFontMetrics().getHeight();
    }

    protected Dimension layoutCanvas() {
        FontMetrics fontMetrics = this._geometry.getFontMetrics();
        int n = 0;
        if (fontMetrics != null) {
            n = this._geometry.getLineCount() * fontMetrics.getHeight();
        }
        return new Dimension(Math.min(this._geometry.getWrapWidth(), this._geometry.getMaxPixelWidth()), n);
    }

    public void borderResizeNotify() {
        super.borderResizeNotify();
        if (this.isWrappingLocked()) {
            this.setWrapWidth(this.getInnerSize().width);
        }
    }

    public void addNotify() {
        super.addNotify();
        this._geometry._setFontMetrics(this.getFontMetrics(this.getFont()));
    }

    protected void paintCanvasInterior(Graphics graphics) {
        LabelGeometry labelGeometry = this._geometry;
        FontMetrics fontMetrics = labelGeometry.getFontMetrics();
        int n = fontMetrics.getHeight();
        Rectangle rectangle = graphics.getClipBounds();
        int n2 = rectangle.y / n;
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2 * n + fontMetrics.getAscent() + fontMetrics.getLeading();
        int n4 = labelGeometry.getLineCount();
        int n5 = labelGeometry.getWrapWidth();
        int n6 = rectangle.y + rectangle.height;
        LineInfo lineInfo = new LineInfo();
        while (n2 < n4) {
            labelGeometry.getLineInfo(n2, lineInfo);
            String string = lineInfo.text;
            if (string != null) {
                if (this._useFullJustification && !lineInfo.isNotWrapped) {
                    this._paintFullJustified(graphics, 0, n3, lineInfo);
                } else {
                    int n7 = 0;
                    if (this._alignment != 0) {
                        n7 = n5 - lineInfo.pixelWidth;
                        if (this._alignment == 2) {
                            n7 >>= 1;
                        }
                    }
                    graphics.drawString(string, n7, n3);
                }
            }
            if (n3 > n6) break;
            n3 += n;
            ++n2;
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        if (this.isWrappingLocked()) {
            this._setWrapWidthNoResize(this.getInnerSize().width);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this._getPreferredInnerSize();
        return this.convertInnerToOuterSize(dimension.width, dimension.height);
    }

    public Dimension getMinimumSize() {
        int n;
        Dimension dimension = this._getPreferredInnerSize();
        FontMetrics fontMetrics = this._geometry.getFontMetrics();
        if (fontMetrics != null && (n = fontMetrics.getHeight()) < dimension.height) {
            dimension.height = n;
        }
        return dimension;
    }

    void invalidateMultiLineLabelCanvas() {
        this.invalidateCanvas();
    }

    private void _setWrapWidthNoResize(int n) {
        this._geometry._setWrapWidth(n);
    }

    private Dimension _getPreferredAspectInnerSize() {
        Dimension dimension = new Dimension();
        FontMetrics fontMetrics = this._geometry.getFontMetrics();
        if (fontMetrics != null) {
            int n = fontMetrics.getHeight();
            float f = this.getPreferredAspectRatio();
            int n2 = f != 0.0f ? (int)Math.sqrt((float)fontMetrics.stringWidth(this.getText()) * (float)n * f) + 1 : this.getInnerSize().width;
            this._geometry._setWrapWidth(n2);
            dimension.width = this._geometry.getMaxPixelWidth();
            dimension.height = this._geometry.getLineCount() * n;
        }
        return dimension;
    }

    private Dimension _getPreferredInnerSize() {
        Dimension dimension;
        if (this.isWrappingLocked()) {
            LabelGeometry labelGeometry = this._geometry;
            synchronized (labelGeometry) {
                int n = this._geometry.getWrapWidth();
                dimension = this._getPreferredAspectInnerSize();
                this._geometry._setWrapWidth(n);
            }
        } else {
            dimension = this.layoutCanvas();
        }
        return dimension;
    }

    private static int _getWhiteSpacePixels(FontMetrics fontMetrics, char[] cArray, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        while (n3 <= n2) {
            char c = cArray[n3];
            if (Character.isWhitespace(c)) {
                n4 += fontMetrics.charWidth(c);
            }
            ++n3;
        }
        return n4;
    }

    private static int _getFirstNonWhiteSpaceIndex(char[] cArray) {
        int n = 0;
        int n2 = cArray.length;
        while (n < n2 && Character.isWhitespace(cArray[n])) {
            ++n;
        }
        return n;
    }

    private int _getLastNonWhiteSpaceIndex(char[] cArray) {
        int n = cArray.length - 1;
        while (n >= 0 && Character.isWhitespace(cArray[n])) {
            --n;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private void _paintFullJustified(Graphics var1_1, int var2_2, int var3_3, LineInfo var4_4) {
        var5_5 = this._geometry;
        var6_6 = var4_4.text;
        var7_7 = var6_6.toCharArray();
        var8_8 = var7_7.length;
        var9_9 = MultiLineLabel._getFirstNonWhiteSpaceIndex(var7_7);
        if (var9_9 == var8_8) {
            return;
        }
        var10_10 = this._getLastNonWhiteSpaceIndex(var7_7);
        var11_11 = var5_5.getWrapWidth() - var4_4.pixelWidth;
        if (var11_11 == 0 && var9_9 == 0 && var10_10 == var8_8 - 1) {
            var1_1.drawString(var6_6, var2_2, var3_3);
            return;
        }
        var12_12 = var5_5.getFontMetrics();
        if (var9_9 != 0) {
            var13_13 = var12_12.charsWidth(var7_7, 0, var9_9);
            if (var4_4.isNewParagraph) {
                var2_2 += var13_13;
            } else {
                var11_11 += var13_13;
            }
        }
        if (var10_10 != var8_8 - 1) {
            var11_11 += var12_12.charsWidth(var7_7, var10_10 + 1, var8_8 - (var10_10 + 1));
        }
        if ((var14_14 = (float)var11_11 / (float)(var13_13 = MultiLineLabel._getWhiteSpacePixels(var12_12, var7_7, var9_9, var10_10)) + 1.0f) < 0.0f) {
            var14_14 = 0.0f;
        }
        var13_13 += var11_11;
        var15_15 = 0.0f;
        var16_16 = false;
        var17_17 = var9_9;
        var18_18 = var9_9;
        var19_19 = var9_9;
        while (var17_17 <= var10_10) {
            block12: {
                if (!var16_16) ** GOTO lbl50
                while (Character.isWhitespace(var7_7[var18_18])) {
                    if (++var18_18 <= var10_10) continue;
                    var1_1.drawChars(var7_7, var19_19, var18_18 - var19_19, var2_2 += var13_13, var3_3);
                    return;
                }
                var20_20 = var12_12.charsWidth(var7_7, var17_17, var18_18 - var17_17);
                if (var20_20 != (var22_22 = (int)(var21_21 = (float)var20_20 * var14_14 + var15_15))) {
                    if (var19_19 != var17_17) {
                        var1_1.drawChars(var7_7, var19_19, var17_17 - var19_19, var2_2, var3_3);
                        var2_2 += var12_12.charsWidth(var7_7, var19_19, var17_17 - var19_19);
                    }
                    var2_2 += var22_22;
                    var17_17 = var18_18;
                    var19_19 = var18_18;
                }
                var13_13 -= var22_22;
                var15_15 = var21_21 - (float)var22_22;
                break block12;
lbl-1000:
                // 1 sources

                {
                    if (++var18_18 <= var10_10) continue;
                    var1_1.drawChars(var7_7, var19_19, var18_18 - var19_19, var2_2 += var13_13, var3_3);
                    return;
lbl50:
                    // 2 sources

                    ** while (!Character.isWhitespace((char)var7_7[var18_18]))
                }
lbl51:
                // 1 sources

                var17_17 = var18_18;
            }
            v0 = var16_16 = var16_16 == false;
        }
    }
}

