/*
 * Decompiled with CFR 0.152.
 */
import com.lucent.ra.nms.amf.LEAMFactory;
import com.lucent.ra.nms.amf.LEAMObserver;
import com.lucent.ra.nms.backend.LEMonSessionsMessage;
import com.lucent.ra.nms.backend.LEMonitorFactory;
import com.lucent.ra.nms.backend.LEStatusFactory;
import com.lucent.ra.nms.backend.LEStatusMessage;
import com.lucent.ra.nms.model.LEAsyncPort;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.model.LEISDNPort;
import com.lucent.ra.nms.model.LEPMConnectionFacade;
import com.lucent.ra.nms.model.LEPort;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LEPorts;
import com.lucent.ra.nms.ui.LEColor;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LELEDs;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEResource;
import com.lucent.ra.nms.view.LEViewListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class LEPM_2eiDisplay
implements LEMonitorDisplay,
LEAMObserver,
ImageObserver {
    public static final int MAX_SESSIONS = 30;
    public static final String ESTAB = "Established";
    static Image s_pm2ei = null;
    static Image s_async = null;
    static Image s_isdn = null;
    LEPortMaster m_pm;
    String m_host;
    int m_height = -1;
    int m_width = -1;
    int m_nameHeight;
    int m_x;
    int m_y;
    int m_flags;
    boolean m_blink;
    boolean m_active;
    boolean m_connected;
    boolean m_drawHeartbeat;
    boolean m_drawInterfaces;
    boolean m_drawPorts;
    boolean m_drawSessions;
    Image m_slot1;
    Image m_slot2;
    Image m_hb;
    Image m_etherTop;
    Image m_etherBottom;
    Image[] m_sessions = new Image[30];

    public LEPM_2eiDisplay() {
        if (s_pm2ei == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (!toolkit.prepareImage(s_pm2ei = LEResource.GetImage("pm2ei.gif"), -1, -1, this)) {
                this.m_flags = 2;
            }
            if (!toolkit.prepareImage(s_async = LEResource.GetImage("async-slot.gif"), -1, -1, this)) {
                this.m_flags = 2;
            }
            if (!toolkit.prepareImage(s_isdn = LEResource.GetImage("isdn-slot.gif"), -1, -1, this)) {
                this.m_flags = 2;
            }
        }
        this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
        this.m_etherTop = LELEDs.GetLED(LELEDs.GREEN);
        this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
        int n = 0;
        while (n < this.m_sessions.length) {
            this.m_sessions[n] = LELEDs.GetLED(LELEDs.GRAY);
            ++n;
        }
    }

    public void setPortMaster(LEPortMaster lEPortMaster) {
        this.m_pm = lEPortMaster;
        this.m_host = this.m_pm.getDescription();
        this.m_connected = this.m_pm.isConnected();
        LEStatusFactory.GetFactory().addObserver(this.m_pm.getResourceID(), this);
        LEMonitorFactory.GetFactory().addObserver(this.m_pm.getResourceID(), this);
        if (!this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
            this.m_etherTop = LELEDs.GetLED(LELEDs.GRAY);
            this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
        } else {
            this.determineSlotContents();
        }
        this.m_active = this.m_pm.getConnectionFacade().supportsEntities();
        this.startMonitoring();
    }

    public void select(int n, int n2, LEViewListener lEViewListener) {
    }

    public int getHeight(Graphics graphics) {
        if (this.m_height < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_height;
    }

    public int getWidth(Graphics graphics) {
        if (this.m_width < 1) {
            this.determineSize(graphics);
            this.m_flags |= 4;
        }
        return this.m_width;
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.m_width == -1 || this.m_height == -1) {
            this.determineSize(graphics);
        }
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        graphics.setColor(LEColor.getBackground());
        graphics.fillRect(n, n2, this.m_width, this.m_height);
        Font font = LEFont.getBoldFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n3 = n + (this.m_width - fontMetrics.stringWidth(this.m_host)) / 2;
        graphics.setColor(LEColor.getForeground());
        graphics.drawString(this.m_host, n3, n2 + fontMetrics.getAscent());
        this.m_nameHeight = fontMetrics.getHeight() + 2;
        this.m_x = n;
        this.m_y = n2 + this.m_nameHeight;
        graphics.drawImage(s_pm2ei, this.m_x, this.m_y, this);
        this.drawHeartbeat(graphics);
        this.drawInterfaces(graphics);
        this.drawPorts(graphics);
        if (this.m_active && this.m_connected) {
            this.drawSessions(graphics);
            return;
        }
        if (!this.m_connected) {
            graphics.setFont(LEFont.getFont());
            fontMetrics = graphics.getFontMetrics();
            int n4 = fontMetrics.stringWidth("Not connected") + 20;
            int n5 = fontMetrics.getHeight() + 20;
            n3 = this.m_x + (this.m_width - n4) / 2;
            int n6 = this.m_y + (this.m_height - this.m_nameHeight - n5) / 2;
            this.drawBox(graphics, n3, n6, n4, n5);
            graphics.drawString("Not connected", n3 + 10, n6 + 10 + fontMetrics.getAscent());
            return;
        }
        graphics.setFont(LEFont.getFont());
        fontMetrics = graphics.getFontMetrics();
        int n7 = fontMetrics.stringWidth("Monitoring requires ComOS 3.8 or later") + 20;
        int n8 = fontMetrics.getHeight() + 20;
        n3 = this.m_x + (this.m_width - n7) / 2;
        int n9 = this.m_y + (this.m_height - this.m_nameHeight - n8) / 2;
        this.drawBox(graphics, n3, n9, n7, n8);
        graphics.drawString("Monitoring requires ComOS 3.8 or later", n3 + 10, n9 + 10 + fontMetrics.getAscent());
    }

    public synchronized int heartbeat(Graphics graphics) {
        if (this.m_connected) {
            this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
            this.drawHeartbeat(graphics);
            this.m_drawHeartbeat = true;
            return 1;
        }
        return 0;
    }

    public synchronized int blink(Graphics graphics, boolean bl) {
        this.m_blink = bl;
        if (this.m_connected && this.m_drawHeartbeat) {
            this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
            this.drawHeartbeat(graphics);
        }
        if (this.m_active && this.m_connected && this.m_drawInterfaces) {
            this.drawInterfaces(graphics);
        }
        if (this.m_active && this.m_drawPorts) {
            this.drawPorts(graphics);
        }
        if (this.m_connected) {
            this.drawISDN(graphics, 0);
            this.drawISDN(graphics, 1);
            this.drawISDN(graphics, 2);
        }
        if (this.m_connected && this.m_drawSessions) {
            this.drawSessions(graphics);
        }
        int n = this.m_flags;
        this.m_flags = 0;
        return n;
    }

    public void shutdown() {
        LEStatusFactory.GetFactory().deleteObserver(this.m_pm.getResourceID(), this);
        LEMonitorFactory.GetFactory().deleteObserver(this.m_pm.getResourceID(), this);
        this.stopMonitoring();
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.m_flags |= 2;
            return false;
        }
        return true;
    }

    public synchronized void update(LEAMFactory lEAMFactory, String string, Object object) {
        if (object instanceof LEMonSessionsMessage) {
            this.updateSession((LEMonSessionsMessage)object);
            return;
        }
        if (object instanceof LEStatusMessage) {
            this.updateStatus((LEStatusMessage)object);
        }
    }

    void determineSize(Graphics graphics) {
        this.m_width = s_pm2ei.getWidth(this);
        this.m_height = s_pm2ei.getHeight(this);
        if (this.m_width == -1 || this.m_height == -1) {
            return;
        }
        Font font = LEFont.getBoldFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        this.m_height += fontMetrics.getHeight() + 4;
    }

    void determineSlotContents() {
        LEPorts lEPorts = (LEPorts)this.m_pm.get("262144");
        if (lEPorts == null) {
            return;
        }
        LEPort lEPort = lEPorts.getPort("S10");
        this.m_slot1 = lEPort instanceof LEAsyncPort ? s_async : (lEPort instanceof LEISDNPort ? s_isdn : null);
        lEPort = lEPorts.getPort("S20");
        this.m_slot2 = lEPort instanceof LEAsyncPort ? s_async : (lEPort instanceof LEISDNPort ? s_isdn : null);
        this.m_drawPorts = true;
    }

    void startMonitoring() {
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        lEPMConnectionFacade.startMonitor(65536, -1, LEPMConnectionFacade.NO_GROUP, 15000);
    }

    void stopMonitoring() {
        LEConnectionFacade lEConnectionFacade = this.m_pm.getConnectionFacade();
        if (!(lEConnectionFacade instanceof LEPMConnectionFacade)) {
            return;
        }
        LEPMConnectionFacade lEPMConnectionFacade = (LEPMConnectionFacade)lEConnectionFacade;
        lEPMConnectionFacade.stopMonitor(65536, -1, LEPMConnectionFacade.NO_GROUP, 15000);
    }

    void updateSession(LEMonSessionsMessage lEMonSessionsMessage) {
        String string = lEMonSessionsMessage.getPortName();
        if (string.charAt(0) != 'S') {
            return;
        }
        try {
            int n = Integer.parseInt(string.substring(1, string.length()));
            this.updateSession(n, lEMonSessionsMessage.getStatus());
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void updateSession(int n, String string) {
        try {
            this.m_sessions[n] = string.equalsIgnoreCase(ESTAB) ? LELEDs.GetLED(LELEDs.BLUE) : LELEDs.GetLED(LELEDs.GRAY);
            this.m_drawSessions = true;
            return;
        }
        catch (Exception exception) {
            LEDebug.getLog().logln(20, exception);
            return;
        }
    }

    void updateStatus(LEStatusMessage lEStatusMessage) {
        switch (lEStatusMessage.getStatus()) {
            case 1: {
                this.m_active = this.m_pm.getConnectionFacade().supportsEntities();
                this.m_connected = true;
                this.m_hb = LELEDs.GetLED(LELEDs.GREEN);
                this.m_etherTop = LELEDs.GetLED(LELEDs.GREEN);
                this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
                this.determineSlotContents();
                this.m_flags |= 2;
                return;
            }
            case 2: 
            case 4: {
                this.m_connected = false;
                this.m_hb = LELEDs.GetLED(LELEDs.GRAY);
                this.m_etherTop = LELEDs.GetLED(LELEDs.GRAY);
                this.m_etherBottom = LELEDs.GetLED(LELEDs.GRAY);
                this.m_flags |= 2;
                return;
            }
        }
    }

    void drawHeartbeat(Graphics graphics) {
        graphics.drawImage(this.m_hb, this.m_x + 183, this.m_y + 146, null);
        this.m_drawHeartbeat = false;
        this.m_flags |= 1;
    }

    void drawInterfaces(Graphics graphics) {
        graphics.drawImage(this.m_etherTop, this.m_x + 296, this.m_y + 141, null);
        graphics.drawImage(this.m_etherBottom, this.m_x + 296, this.m_y + 152, null);
        this.m_flags |= 1;
        this.m_drawInterfaces = false;
    }

    void drawPorts(Graphics graphics) {
        if (this.m_slot1 != null) {
            graphics.drawImage(this.m_slot1, this.m_x + 105, this.m_y + 52, null);
            if (this.m_slot1 == s_isdn) {
                this.drawISDN(graphics, 1);
            }
        }
        if (this.m_slot2 != null) {
            graphics.drawImage(this.m_slot2, this.m_x + 105, this.m_y + 8, null);
            if (this.m_slot2 == s_isdn) {
                this.drawISDN(graphics, 2);
            }
        }
        this.drawISDN(graphics, 0);
        this.m_drawPorts = false;
    }

    void drawISDN(Graphics graphics, int n) {
        int n2 = this.m_x;
        int n3 = this.m_y;
        switch (n) {
            case 0: {
                n2 += 146;
                n3 += 123;
                break;
            }
            case 1: {
                n2 += 142;
                n3 += 74;
                break;
            }
            case 2: {
                n2 += 142;
                n3 += 31;
                break;
            }
        }
        Image image = this.m_blink && this.m_connected ? LELEDs.GetLED(LELEDs.GREEN) : LELEDs.GetLED(LELEDs.GRAY);
        graphics.drawImage(image, n2, n3, null);
        graphics.drawImage(image, n2 += 48, n3, null);
        graphics.drawImage(image, n2 += 44, n3, null);
        graphics.drawImage(image, n2 += 45, n3, null);
        graphics.drawImage(image, n2 += 44, n3, null);
    }

    void drawSessions(Graphics graphics) {
        int n = 0;
        while (n < this.m_sessions.length) {
            this.drawSession(graphics, n);
            ++n;
        }
        this.m_flags |= 1;
        this.m_drawSessions = false;
    }

    void drawSession(Graphics graphics, int n) {
        if (this.m_sessions[n] == null) {
            return;
        }
        if (n < 10) {
            this.drawISDNSession(graphics, n);
        }
        if (this.m_slot1 == s_isdn && this.m_slot2 == s_isdn) {
            this.drawISDNSession(graphics, n);
            return;
        }
        if (this.m_slot1 == s_async && this.m_slot2 == s_async) {
            this.drawModemSession(graphics, n);
            return;
        }
        if (this.m_slot2 == s_isdn && n > 19) {
            this.drawISDNSession(graphics, n);
            return;
        }
        if (this.m_slot1 == s_isdn && n < 20) {
            this.drawISDNSession(graphics, n);
            return;
        }
        this.drawModemSession(graphics, n);
    }

    void drawModemSession(Graphics graphics, int n) {
        int n2 = n / 5;
        int n3 = n % 5;
        int n4 = this.m_x + 125 + n3 * 59;
        int n5 = this.m_y;
        n5 = n2 < 2 ? (n2 < 1 ? (n5 += 104) : (n5 += 124)) : (n2 < 4 ? (n2 < 3 ? (n5 += 60) : (n5 += 80)) : (n2 < 5 ? (n5 += 16) : (n5 += 36)));
        graphics.drawImage(this.m_sessions[n], n4, n5, null);
    }

    void drawISDNSession(Graphics graphics, int n) {
        if (n % 2 == 1) {
            return;
        }
        int n2 = n / 2 % 5;
        int n3 = this.m_x + 142;
        switch (n2) {
            case 1: {
                n3 += 48;
                break;
            }
            case 2: {
                n3 += 92;
                break;
            }
            case 3: {
                n3 += 137;
                break;
            }
            case 4: {
                n3 += 181;
                break;
            }
        }
        int n4 = this.m_y;
        if (n > 19) {
            n4 += 23;
        } else if (n < 10) {
            n3 += 4;
            n4 += 115;
        } else {
            n4 += 66;
        }
        graphics.drawImage(this.m_sessions[n], n3, n4, null);
    }

    void drawBox(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.setColor(Color.white);
        graphics.fillRect(n, n2, n3, n4);
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }
}

