/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEAddDialog;
import com.lucent.ra.nms.forms.LECmdErrorDialog;
import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineFactory;
import com.lucent.ra.nms.forms.LENewEntry;
import com.lucent.ra.nms.forms.LETableForm;
import com.lucent.ra.nms.model.LEBinding;
import com.lucent.ra.nms.model.LEBindings;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.model.LETable;
import com.lucent.ra.nms.ui.LECompGrid;
import com.lucent.ra.nms.ui.LEErrorDialog;
import com.lucent.ra.nms.ui.LEFont;
import com.lucent.ra.nms.ui.LEUiUtils;
import com.lucent.ra.nms.util.LEVector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;

public class LEBindingsForm
extends LETableForm {
    static final String PORTMASTER = "Device";
    static final String BLANK = "";
    String m_ipaddress;
    String m_macaddress;

    public LEBindingsForm() {
        this.m_simpleTable = true;
    }

    boolean addNewEntry(LEDataSpec lEDataSpec, LEDataSpec lEDataSpec2) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Component[][] componentArray = new Component[2][2];
        componentArray[0][0] = new Label(String.valueOf(lEDataSpec.getDescription()) + ":");
        componentArray[0][0].setFont(LEFont.getBoldFont());
        componentArray[0][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec);
        LEDataSpec lEDataSpec3 = lEDataSpec2.getSpecFor("195");
        componentArray[1][0] = new Label(String.valueOf(lEDataSpec3.getDescription()) + ":");
        componentArray[1][0].setFont(LEFont.getBoldFont());
        componentArray[1][1] = LEFormLineFactory.BuildFormLine(null, null, null, lEDataSpec3);
        panel.add("Center", new LECompGrid(componentArray, 2, false));
        LEAddDialog lEAddDialog = new LEAddDialog(LEUiUtils.GetBaseFrame(), "Add DHCP Binding", panel);
        if (lEAddDialog.okay()) {
            this.m_ipaddress = ((LEFormLine)((Object)componentArray[0][1])).getValue();
            this.m_macaddress = ((LEFormLine)((Object)componentArray[1][1])).getValue();
            if (this.m_ipaddress.length() == 0 || this.m_macaddress.length() == 0) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Both entries must be specified");
            } else if (this.m_ipaddress.equals("0.0.0.0") || this.m_macaddress.equals("0:0:0:0:0:0")) {
                new LEErrorDialog(LEUiUtils.GetBaseFrame(), "Entries must be non zero values");
            } else {
                return true;
            }
        }
        return false;
    }

    LENewEntry addNewEntryTo(LEPortMaster lEPortMaster) {
        LENewEntry lENewEntry = null;
        LETable lETable = this.getTable(lEPortMaster);
        if (lETable.get(this.m_ipaddress) == null) {
            LEVector lEVector = ((LEBindings)lETable).add(this.m_ipaddress, this.m_macaddress);
            if (lEVector != null) {
                new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            } else {
                this.addEntry(lEPortMaster.getDescription(), lETable, this.m_ipaddress);
                lENewEntry = new LENewEntry(lEPortMaster, lETable, this.m_ipaddress);
            }
        } else {
            new LEErrorDialog(LEUiUtils.GetBaseFrame(), String.valueOf(lEPortMaster.getDescription()) + " already contains DHCP binding for " + this.m_ipaddress);
        }
        return lENewEntry;
    }

    void delete(LEPortMaster lEPortMaster, LETable lETable, String string) {
        if (!(lETable instanceof LEBindings)) {
            return;
        }
        LEBindings lEBindings = (LEBindings)lETable;
        LEVector lEVector = lEBindings.delete(string);
        if (lEVector != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
        }
    }

    String getPasteKey(LEPortMaster lEPortMaster, Object object) {
        LEVector lEVector;
        if (!(object instanceof LEBinding)) {
            return null;
        }
        LEBinding lEBinding = (LEBinding)object;
        LEBindings lEBindings = (LEBindings)this.getTable(lEPortMaster);
        String string = lEBinding.getName();
        String string2 = (String)lEBinding.get("195");
        if (lEBindings.get(string) != null) {
            string = LETableForm.GetUniqueKey(lEBindings, string, 16);
        }
        if ((lEVector = lEBindings.add(string, string2)) != null) {
            new LECmdErrorDialog(LEUiUtils.GetBaseFrame(), lEPortMaster.getConnectionFacade(), lEVector);
            string = null;
            string2 = null;
        }
        return string;
    }
}

