/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.forms;

import com.lucent.ra.nms.forms.LEFormLine;
import com.lucent.ra.nms.forms.LEFormLineEvent;
import com.lucent.ra.nms.forms.LEFormLineListener;
import com.lucent.ra.nms.model.LEAttributes;
import com.lucent.ra.nms.model.LEDataSpec;
import com.lucent.ra.nms.model.LEPortMaster;
import com.lucent.ra.nms.ui.LETextField;
import com.lucent.ra.nms.util.LEDebug;
import com.lucent.ra.nms.util.LEHelpManager;
import com.lucent.ra.nms.util.LEVector;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LELeaseFormLine
extends Panel
implements LEFormLine,
ActionListener,
MouseListener {
    public static final String MINUTES_STR = new String("minutes");
    public static final String HOURS_STR = new String("hours");
    public static final String INFINITY_STR = new String("Infinity");
    static final int MINUTES = 0;
    static final int SECONDS = 1;
    LETextField m_hours;
    LETextField m_minutes;
    Button m_infinity;
    String m_valid;
    Label m_hourLabel;
    Label m_minLabel;
    long m_min;
    long m_max = 3817748L;
    long m_min2;
    long m_max2 = 63651L;
    LEFormLineListener m_listener;

    public LELeaseFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_hours = new LETextField(5);
        this.m_hours.setNumeric(true);
        this.m_hours.addActionListener(this);
        this.m_hours.addMouseListener(this);
        this.add(this.m_hours);
        this.m_hourLabel = new Label("  " + HOURS_STR);
        this.m_hourLabel.addMouseListener(this);
        this.add(this.m_hourLabel);
        this.m_minutes = new LETextField(2);
        this.m_minutes.setNumeric(true);
        this.m_minutes.addActionListener(this);
        this.m_minutes.addMouseListener(this);
        this.add(this.m_minutes);
        this.m_minLabel = new Label("  " + MINUTES_STR);
        this.m_minLabel.addMouseListener(this);
        this.add(this.m_minLabel);
        this.m_infinity = new Button(INFINITY_STR);
        this.m_infinity.addActionListener(this);
        this.m_infinity.addMouseListener(this);
        this.add(this.m_infinity);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
        String string;
        if (lEDataSpec == null) {
            return;
        }
        Object object = lEDataSpec.getAttribute(LEAttributes.MINIMUM);
        if (object instanceof String) {
            try {
                string = (String)object;
                this.m_min2 = this.m_min = (long)Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
        } else if (object instanceof LEVector) {
            try {
                string = (String)((LEVector)object).elementAt(0);
                this.m_min2 = this.m_min = (long)Integer.parseInt(string);
                string = (String)((LEVector)object).elementAt(1);
                this.m_min2 = Integer.parseInt(string);
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        if ((object = lEDataSpec.getAttribute(LEAttributes.MAXIMUM)) instanceof String) {
            try {
                string = (String)object;
                this.m_max2 = this.m_max = Long.parseLong(string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
                return;
            }
        }
        if (object instanceof LEVector) {
            try {
                string = (String)((LEVector)object).elementAt(0);
                this.m_max2 = this.m_max = Long.parseLong(string);
                string = (String)((LEVector)object).elementAt(1);
                this.m_max2 = Long.parseLong(string);
                return;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
                return;
            }
        }
    }

    public void setValue(Object object) {
        String string = object.toString();
        try {
            long l = Long.parseLong(string);
            long l2 = l / 60L;
            long l3 = l % 60L;
            this.m_hours.setText(Long.toString(l2));
            this.m_minutes.setText(Long.toString(l3));
            return;
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
            return;
        }
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public String getValue() {
        String string = this.m_hours.getText();
        String string2 = this.m_minutes.getText();
        long l = 0L;
        try {
            int n = 0;
            int n2 = 0;
            if (string.length() > 0) {
                n = Integer.parseInt(string);
            }
            if (string2.length() > 0) {
                n2 = Integer.parseInt(string2);
            }
            l = n * 60;
            l += (long)n2;
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
        }
        return Long.toString(l);
    }

    public String getValidValues() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_min2);
        stringBuffer.append(" to ");
        stringBuffer.append(this.m_max2);
        stringBuffer.append(" hours or ");
        stringBuffer.append(this.m_min);
        stringBuffer.append(" to ");
        stringBuffer.append(this.m_max);
        stringBuffer.append(" minutes");
        return stringBuffer.toString();
    }

    public boolean isValueValid() {
        String string = this.m_hours.getText();
        String string2 = this.m_minutes.getText();
        try {
            long l = Long.parseLong(string);
            if (l < this.m_min2 || l > this.m_max2) {
                return false;
            }
            long l2 = l * 60L;
            if ((l2 += Long.parseLong(string2)) < this.m_min || l2 > this.m_max) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public boolean equalsField(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        String string2 = this.m_hours.getText();
        String string3 = this.m_minutes.getText();
        try {
            long l = 0L;
            l += Long.parseLong(string2);
            l *= 60L;
            String string4 = Long.toString(l += Long.parseLong(string3));
            if (string4.equals(string)) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return false;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(INFINITY_STR)) {
            this.m_hours.setText("0");
            this.m_minutes.setText("0");
        }
        this.notifyListener();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(lEFormLineEvent);
        }
    }
}

