/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEBGPPolicyRule
extends LEConfig {
    public static final String ACTION = "417";
    public static final String AS_PATH = "422";
    public static final String COMMUNITY_ACTION = "431";
    public static final String DEG_OF_PREF = "426";
    public static final String EXACT = "420";
    public static final String IF_COMMUNITY = "423";
    public static final String IGNORE_RESTRICT = "429";
    public static final String INCLUDE_POLICY = "418";
    public static final String INPUT_MED = "424";
    public static final String LOCAL_PREF = "427";
    public static final String NEXT_HOP = "430";
    public static final String OUTPUT_MED = "425";
    public static final String PREFIX = "419";
    public static final String PREFIX_GT = "421";
    public static final String THEN_COMMUNITY = "428";
    public static final String PERMIT = "permit";
    public static final String DENY = "deny";
    public static final String INCLUDE = "include";
    String m_name;
    String m_number;

    public LEBGPPolicyRule(LEConnectionFacade facade, String name, String number) {
        super(facade);
        this.m_name = name;
        this.m_number = number;
    }

    public void initialize(String action) {
        this.setField(ACTION, action);
        this.setField(AS_PATH, "");
        this.setField(COMMUNITY_ACTION, "");
        this.setField(DEG_OF_PREF, "");
        this.setField(EXACT, "off");
        this.setField(IF_COMMUNITY, "");
        this.setField(IGNORE_RESTRICT, "off");
        this.setField(INCLUDE_POLICY, "");
        this.setField(INPUT_MED, "");
        this.setField(LOCAL_PREF, "");
        this.setField(NEXT_HOP, "");
        this.setField(OUTPUT_MED, "");
        this.setField(PREFIX, "");
        this.setField(PREFIX_GT, "");
        this.setField(THEN_COMMUNITY, "");
    }

    public Object clone() {
        LEBGPPolicyRule config = new LEBGPPolicyRule(this.m_facade, this.m_name, this.m_number);
        config.copy(this);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNumber() {
        return this.m_number;
    }

    public void setName(String name) {
        this.m_name = name;
        if (this.m_changed == null) {
            this.m_changed = new LEVector();
        }
    }

    public void setNumber(String number) {
        this.m_number = number;
        if (this.m_changed == null) {
            this.m_changed = new LEVector();
        }
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String deg_of_pref;
        String ignore_restrict;
        String community2;
        String next_hop;
        String omed;
        String imed;
        String local_pref;
        String community1;
        String as_path;
        String prefix_gt;
        String prefix;
        String action = (String)this.get(ACTION);
        if (this.m_name == null || this.m_number == null || action == null) {
            return false;
        }
        boolean bgp_if = false;
        boolean bgp_then = false;
        StringBuffer buf = new StringBuffer(30);
        buf.append("set ");
        buf.append("bgp policy ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(this.m_number);
        buf.append(" ");
        buf.append(action);
        if (action.equals(INCLUDE)) {
            buf.append(" ");
            buf.append((String)this.get(INCLUDE_POLICY));
        }
        if (!(prefix = (String)this.get(PREFIX)).equals("")) {
            if (!bgp_if) {
                buf.append(" if ");
                bgp_if = true;
            }
            buf.append("prefix ");
            String exact = (String)this.get(EXACT);
            if (exact.equals("on")) {
                buf.append("exact ");
            }
            buf.append(prefix);
            buf.append(" ");
        }
        if (!(prefix_gt = (String)this.get(PREFIX_GT)).equals("")) {
            if (!bgp_if) {
                buf.append(" if ");
                bgp_if = true;
            }
            buf.append("prefix-longer-than ");
            buf.append(prefix_gt);
            buf.append(" ");
        }
        if (!(as_path = (String)this.get(AS_PATH)).equals("")) {
            if (!bgp_if) {
                buf.append(" if ");
                bgp_if = true;
            }
            buf.append("as-path ");
            buf.append(as_path);
            buf.append(" ");
        }
        if (!(community1 = (String)this.get(IF_COMMUNITY)).equals("")) {
            if (!bgp_if) {
                buf.append(" if ");
                bgp_if = true;
            }
            buf.append("community ");
            buf.append(community1);
            buf.append(" ");
        }
        if (!(local_pref = (String)this.get(LOCAL_PREF)).equals("")) {
            if (!bgp_then) {
                buf.append(" then ");
                bgp_then = true;
            }
            buf.append("local-pref ");
            buf.append(local_pref);
            buf.append(" ");
        }
        if (!(imed = (String)this.get(INPUT_MED)).equals("")) {
            if (!bgp_then) {
                buf.append(" then ");
                bgp_then = true;
            }
            buf.append("input-multi-exit-disc ");
            buf.append(imed);
            buf.append(" ");
        }
        if (!(omed = (String)this.get(OUTPUT_MED)).equals("")) {
            if (!bgp_then) {
                buf.append(" then ");
                bgp_then = true;
            }
            buf.append("output-multi-exit-disc ");
            buf.append(omed);
            buf.append(" ");
        }
        if (!(next_hop = (String)this.get(NEXT_HOP)).equals("")) {
            if (!bgp_then) {
                buf.append(" then ");
                bgp_then = true;
            }
            buf.append("next-hop ");
            buf.append(next_hop);
            buf.append(" ");
        }
        if (!(community2 = (String)this.get(THEN_COMMUNITY)).equals("")) {
            if (!bgp_then) {
                buf.append(" then ");
                bgp_then = true;
            }
            buf.append("community ");
            buf.append((String)this.get(COMMUNITY_ACTION));
            buf.append(" ");
            buf.append(community2);
            buf.append(" ");
        }
        if ((ignore_restrict = (String)this.get(IGNORE_RESTRICT)).equals("on")) {
            if (!bgp_then) {
                buf.append(" then ");
                bgp_then = true;
            }
            buf.append("ignore-community-restrictions ");
        }
        if (!(deg_of_pref = (String)this.get(DEG_OF_PREF)).equals("")) {
            if (!bgp_then) {
                buf.append(" then ");
                bgp_then = true;
            }
            buf.append("degree-of-preference ");
            buf.append(deg_of_pref);
            buf.append(" ");
        }
        cmds.addElement(buf.toString());
        return true;
    }

    void markChanged() {
        if (this.m_changed == null) {
            this.m_changed = new LEVector();
        }
    }
}

