/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.model.LEConfig;
import com.lucent.ra.nms.model.LEConnectionFacade;
import com.lucent.ra.nms.util.LEVector;

public class LEIMT
extends LEConfig {
    public static final String GATEWAY = "75";
    public static final String PORT = "370";
    public static final String BASE_PORT = "523";
    public static final String SWITCH = "172";
    public static final String REJECT_CAUSE = "526";
    public static final String ALT_GW_1 = "173";
    public static final String ALT_GW_2 = "174";
    public static final String ALT_GW_3 = "175";
    public static final int KEY_COUNT = 8;
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[8];
            int i = 0;
            LEIMT.s_keys[i++] = GATEWAY;
            LEIMT.s_keys[i++] = PORT;
            LEIMT.s_keys[i++] = BASE_PORT;
            LEIMT.s_keys[i++] = SWITCH;
            LEIMT.s_keys[i++] = REJECT_CAUSE;
            LEIMT.s_keys[i++] = ALT_GW_1;
            LEIMT.s_keys[i++] = ALT_GW_2;
            LEIMT.s_keys[i++] = ALT_GW_3;
        }
        return s_keys;
    }

    public LEIMT(LEConnectionFacade facade) {
        super(facade);
    }

    public LEIMT(LEConnectionFacade facade, String board, String key) {
        super(facade, board, key);
    }

    public Object clone() {
        LEIMT config = new LEIMT(this.m_facade, this.m_board, this.m_fetchKey);
        config.copy(this);
        return config;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(GATEWAY) || keys.contains(PORT) || keys.contains(BASE_PORT) || keys.contains(SWITCH)) {
            String gateway = (String)this.get(GATEWAY);
            String port = (String)this.get(PORT);
            if (gateway != null && port != null) {
                StringBuffer buf = new StringBuffer();
                buf.append("set ");
                buf.append("imt ");
                buf.append(gateway);
                buf.append(" ");
                buf.append(port);
                buf.append(" ");
                buf.append((String)this.get(BASE_PORT));
                buf.append(" ");
                buf.append((String)this.get(SWITCH));
                cmds.addElement(buf.toString());
            }
        }
        if (allCmds || keys.contains(REJECT_CAUSE)) {
            this.makeSetCommand(cmds, null, REJECT_CAUSE, "imt-rej");
        }
        if (allCmds || keys.contains(ALT_GW_1)) {
            this.makeSetCommand(cmds, null, ALT_GW_1, "imt-alt 1");
        }
        if (allCmds || keys.contains(ALT_GW_2)) {
            this.makeSetCommand(cmds, null, ALT_GW_2, "imt-alt 2");
        }
        if (allCmds || keys.contains(ALT_GW_3)) {
            this.makeSetCommand(cmds, null, ALT_GW_3, "imt-alt 3");
        }
        return cmds.size() > start;
    }
}

