/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

public class LEISDNSwitch {
    public static final int BRI_NUM = 8;
    public static final int PRI_NUM = 8;
    static final String[] s_BRIswitches = new String[8];
    static final String[] s_BRIswitchLabels = new String[8];
    static final String[] s_PRIswitches = new String[8];
    static final String[] s_PRIswitchLabels = new String[8];

    public static String GetBRISwitchType(String switch_label) {
        String switch_type;
        int num = -1;
        boolean found = false;
        int i = 0;
        try {
            while (i < 8 && !found) {
                String label = s_BRIswitchLabels[i];
                if (label.equalsIgnoreCase(switch_label)) {
                    num = i;
                    found = true;
                }
                ++i;
            }
            switch_type = num < 8 ? s_BRIswitches[num] : new String("");
        }
        catch (Exception exception) {
            switch_type = new String("");
        }
        return switch_type;
    }

    public static String GetBRISwitchType(int index) {
        return s_BRIswitches[index];
    }

    public static String GetBRISwitchLabel(String switch_type) {
        String switch_label;
        int num = -1;
        boolean found = false;
        int i = 0;
        try {
            while (i < 8 && !found) {
                String label = s_BRIswitches[i];
                if (label.equalsIgnoreCase(switch_type)) {
                    num = i;
                    found = true;
                }
                ++i;
            }
            switch_label = num > -1 && num < 8 ? s_BRIswitchLabels[num] : new String("");
        }
        catch (Exception exception) {
            switch_label = new String("");
        }
        return switch_label;
    }

    public static String GetBRISwitchLabel(int index) {
        return s_BRIswitchLabels[index];
    }

    public static String GetPRISwitchType(String switch_label) {
        String switch_type;
        int num = -1;
        boolean found = false;
        int i = 0;
        try {
            while (i < 8 && !found) {
                String label = s_PRIswitchLabels[i];
                if (label.equalsIgnoreCase(switch_label)) {
                    num = i;
                    found = true;
                }
                ++i;
            }
            switch_type = num < 8 ? s_PRIswitches[num] : new String("");
        }
        catch (Exception exception) {
            switch_type = new String("");
        }
        return switch_type;
    }

    public static String GetPRISwitchType(int index) {
        return s_PRIswitches[index];
    }

    public static String GetPRISwitchLabel(String switch_type) {
        String switch_label;
        int num = -1;
        boolean found = false;
        int i = 0;
        try {
            while (i < 8 && !found) {
                String label = s_PRIswitches[i];
                if (label.equalsIgnoreCase(switch_type)) {
                    num = i;
                    found = true;
                }
                ++i;
            }
            switch_label = num > -1 && num < 8 ? s_PRIswitchLabels[num] : new String("");
        }
        catch (Exception exception) {
            switch_label = new String("");
        }
        return switch_label;
    }

    public static String GetPRISwitchLabel(int index) {
        return s_PRIswitchLabels[index];
    }

    public static boolean NeedSPIDs(String switch_type) {
        return switch_type.equalsIgnoreCase("att-5ess") || switch_type.equalsIgnoreCase("ni-1") || switch_type.equalsIgnoreCase("dms-100");
    }

    public static boolean Need1Dir(String switch_type) {
        return switch_type.equalsIgnoreCase("5ess-ptp");
    }

    public static boolean IsUSSwitch(String switch_type) {
        if (LEISDNSwitch.NeedSPIDs(switch_type) || LEISDNSwitch.Need1Dir(switch_type)) {
            return true;
        }
        return switch_type.equalsIgnoreCase("ni-2") || switch_type.equalsIgnoreCase("att-4ess") || switch_type.equalsIgnoreCase("dms-100");
    }

    static {
        LEISDNSwitch.s_BRIswitches[0] = new String("ni-1");
        LEISDNSwitch.s_BRIswitchLabels[0] = new String("National ISDN-1 (NI-1)");
        LEISDNSwitch.s_PRIswitches[0] = new String("ni-2");
        LEISDNSwitch.s_PRIswitchLabels[0] = new String("National ISDN-2 (NI-2)");
        LEISDNSwitch.s_PRIswitches[1] = LEISDNSwitch.s_BRIswitches[1] = new String("dms-100");
        LEISDNSwitch.s_PRIswitchLabels[1] = LEISDNSwitch.s_BRIswitchLabels[1] = new String("Northern Telecom DMS-100");
        LEISDNSwitch.s_PRIswitches[2] = new String("att-4ess");
        LEISDNSwitch.s_PRIswitchLabels[2] = new String("Lucent 4ESS");
        LEISDNSwitch.s_BRIswitches[2] = new String("att-5ess");
        LEISDNSwitch.s_BRIswitchLabels[2] = new String("Lucent 5ESS");
        LEISDNSwitch.s_PRIswitches[3] = new String("att-5ess");
        LEISDNSwitch.s_PRIswitchLabels[3] = new String("Lucent 5ESS");
        LEISDNSwitch.s_BRIswitches[3] = new String("5ess-ptp");
        LEISDNSwitch.s_BRIswitchLabels[3] = new String("Lucent 5ESS Point to point");
        LEISDNSwitch.s_PRIswitches[4] = new String("net5");
        LEISDNSwitch.s_PRIswitchLabels[4] = new String("European ISDN Net5");
        LEISDNSwitch.s_BRIswitches[4] = new String("net3");
        LEISDNSwitch.s_BRIswitchLabels[4] = new String("European ISDN Net3");
        LEISDNSwitch.s_PRIswitches[5] = LEISDNSwitch.s_BRIswitches[5] = new String("ntt");
        LEISDNSwitch.s_PRIswitchLabels[5] = LEISDNSwitch.s_BRIswitchLabels[5] = new String("Japan NTT");
        LEISDNSwitch.s_PRIswitches[6] = LEISDNSwitch.s_BRIswitches[6] = new String("kdd");
        LEISDNSwitch.s_PRIswitchLabels[6] = LEISDNSwitch.s_BRIswitchLabels[6] = new String("Japan KDD");
        LEISDNSwitch.s_BRIswitches[7] = new String("vn4");
        LEISDNSwitch.s_BRIswitchLabels[7] = new String("France VN4 ");
        LEISDNSwitch.s_PRIswitches[7] = new String("etsi");
        LEISDNSwitch.s_PRIswitchLabels[7] = new String("EuroISDN");
    }
}

