/*
 * Decompiled with CFR 0.152.
 */
package com.lucent.ra.nms.model;

import com.lucent.ra.nms.backend.LEDeltaModemsMessage;
import com.lucent.ra.nms.backend.LEMonModemsMessage;

public class LEModem {
    public static final int DEAD = 0;
    public static final int ERROR = 1;
    public static final int ADMIN = 2;
    public static final int TEST = 3;
    public static final int READY = 4;
    public static final int BOUND = 5;
    public static final int CONNECTING = 6;
    public static final int CONNECTED = 7;
    public static final int TX = 8;
    public static final int RX = 9;
    public static final int TXRX = 10;
    public static final String ADMIN_STR = new String("ADM");
    public static final String HALT_STR = new String("HAL");
    public static final String READY_STR = new String("REA");
    public static final String DOWN_STR = new String("DOW");
    public static final String BOUND_STR = new String("BOU");
    public static final String ACTIVE_STR = new String("NRM");
    public static final String CONN_STR = new String("CON");
    public static final String HUNT_STR = new String("HUN");
    public static final String INIT_STR = new String("INI");
    public static final String HALT_DISP_STR = new String("Halt");
    public static final String ERROR_DISP_STR = new String("Error");
    public static final String ADMIN_DISP_STR = new String("Admin");
    public static final String TEST_DISP_STR = new String("Test");
    public static final String READY_DISP_STR = new String("Ready");
    public static final String BOUND_DISP_STR = new String("Bound");
    public static final String CONNECTING_DISP_STR = new String("Connecting");
    public static final String CONNECTED_DISP_STR = new String("Active");
    int m_state;
    int m_rxCount;
    int m_txCount;

    public static int ConvertState(int state, boolean tx, boolean rx) {
        int ret = tx && rx && state >= 7 ? 10 : (tx && state >= 7 ? 8 : (rx && state >= 7 ? 9 : state));
        return ret;
    }

    public static int ConvertState(String state, boolean tx, boolean rx) {
        int ret = state.startsWith(HALT_STR) || state.startsWith(INIT_STR) ? LEModem.ConvertState(0, tx, rx) : (state.startsWith(ACTIVE_STR) ? LEModem.ConvertState(7, tx, rx) : (state.startsWith(ADMIN_STR) ? LEModem.ConvertState(2, tx, rx) : (state.startsWith(READY_STR) ? LEModem.ConvertState(4, tx, rx) : (state.startsWith(DOWN_STR) ? LEModem.ConvertState(1, tx, rx) : (state.startsWith(BOUND_STR) ? LEModem.ConvertState(5, tx, rx) : (state.startsWith(CONN_STR) ? LEModem.ConvertState(6, tx, rx) : (state.startsWith(HUNT_STR) ? LEModem.ConvertState(6, tx, rx) : LEModem.ConvertState(3, tx, rx))))))));
        return ret;
    }

    public static String GetStateString(int state) {
        String disp = READY_DISP_STR;
        switch (state) {
            case 0: {
                disp = HALT_DISP_STR;
                break;
            }
            case 1: {
                disp = ERROR_DISP_STR;
                break;
            }
            case 2: {
                disp = ADMIN_DISP_STR;
                break;
            }
            case 3: {
                disp = TEST_DISP_STR;
                break;
            }
            case 4: {
                disp = READY_DISP_STR;
                break;
            }
            case 5: {
                disp = BOUND_DISP_STR;
                break;
            }
            case 6: {
                disp = CONNECTING_DISP_STR;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                disp = CONNECTED_DISP_STR;
                break;
            }
        }
        return disp;
    }

    public LEModem(int state) {
        this.m_state = state;
    }

    public LEModem(String state) {
        this.m_state = LEModem.ConvertState(state, false, false);
    }

    public LEModem(LEMonModemsMessage msg) {
        String state = msg.getState();
        if (state != null) {
            this.m_state = LEModem.ConvertState(state, false, false);
        }
    }

    public int getState() {
        return this.m_state;
    }

    public String getStateString() {
        return LEModem.GetStateString(this.m_state);
    }

    public void setState(LEDeltaModemsMessage msg) {
        String state = msg.getState();
        boolean rx = false;
        boolean tx = false;
        if (msg.getRXCountChanged()) {
            rx = true;
            this.m_rxCount = msg.getRXCount();
        }
        if (msg.getTXCountChanged()) {
            tx = true;
            this.m_txCount = msg.getRXCount();
        }
        this.m_state = state == null ? LEModem.ConvertState(this.m_state, rx, tx) : LEModem.ConvertState(state, rx, tx);
    }

    public void setState(LEMonModemsMessage msg) {
        int txCount;
        String state = msg.getState();
        boolean rx = false;
        boolean tx = false;
        int rxCount = msg.getRXCount();
        if (this.m_rxCount != rxCount) {
            rx = true;
        }
        if (this.m_txCount != (txCount = msg.getTXCount())) {
            tx = true;
        }
        this.m_rxCount = rxCount;
        this.m_txCount = txCount;
        this.m_state = state == null ? LEModem.ConvertState(this.m_state, rx, tx) : LEModem.ConvertState(state, rx, tx);
    }

    public void setState(String state, boolean tx, boolean rx) {
        this.m_state = LEModem.ConvertState(state, tx, rx);
    }

    public void setState(int state, boolean tx, boolean rx) {
        this.m_state = LEModem.ConvertState(state, tx, rx);
    }
}

