/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.amf;

import COM.livingston.amf.LEAMObserver;
import COM.livingston.amf.LEAsyncMessage;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.util.Hashtable;

public class LEAMFactory {
    public static final String ALL_HOSTS = "";
    private static LEAMFactory s_factory = null;
    protected Hashtable m_factories = new Hashtable();
    protected Hashtable m_hostObservers = new Hashtable();

    public static LEAMFactory GetFactory() {
        if (s_factory == null) {
            s_factory = new LEAMFactory();
        }
        return s_factory;
    }

    public void addObserver(String string, LEAMObserver lEAMObserver) {
        LEVector lEVector;
        if (lEAMObserver == null) {
            return;
        }
        if (string == null) {
            string = ALL_HOSTS;
        }
        if ((lEVector = (LEVector)this.m_hostObservers.get(string)) == null) {
            lEVector = new LEVector();
            this.m_hostObservers.put(string, lEVector);
        }
        lEVector.addElement(lEAMObserver);
    }

    public void deleteObserver(String string, LEAMObserver lEAMObserver) {
        LEVector lEVector;
        if (lEAMObserver == null) {
            return;
        }
        if (string == null) {
            string = ALL_HOSTS;
        }
        if ((lEVector = (LEVector)this.m_hostObservers.get(string)) != null) {
            lEVector.removeElement(lEAMObserver);
        }
    }

    public void register(String string, LEAMFactory lEAMFactory) {
        if (string != null && lEAMFactory != null) {
            this.m_factories.put(string, lEAMFactory);
        }
    }

    public void process(LEAsyncMessage lEAsyncMessage, LEVector lEVector) {
        String string;
        if (lEAsyncMessage == null) {
            return;
        }
        LEVector lEVector2 = (LEVector)this.m_hostObservers.get(ALL_HOSTS);
        if (lEVector2 != null && lEVector2.size() > 0) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addVector(lEVector2);
        }
        if ((lEVector2 = (LEVector)this.m_hostObservers.get(string = lEAsyncMessage.getHost())) != null && lEVector2.size() > 0) {
            if (lEVector == null) {
                lEVector = new LEVector();
            }
            lEVector.addVector(lEVector2);
        }
        this.produce(lEAsyncMessage, lEVector);
    }

    protected LEAMFactory() {
    }

    protected void produce(LEAsyncMessage lEAsyncMessage, LEVector lEVector) {
        if (!this.dispatch(lEAsyncMessage, lEVector)) {
            String string = lEAsyncMessage.getHost();
            String string2 = lEAsyncMessage.getType();
            LEDebug.getLog().logln(20, "No factory for async message of type " + string2 + " from " + string);
            this.notify(lEVector, lEAsyncMessage.getHost(), lEAsyncMessage);
        }
    }

    protected boolean dispatch(LEAsyncMessage lEAsyncMessage, LEVector lEVector) {
        String string = lEAsyncMessage.getType();
        if (string == null) {
            return false;
        }
        LEAMFactory lEAMFactory = (LEAMFactory)this.m_factories.get(string);
        if (lEAMFactory == null) {
            return false;
        }
        lEAMFactory.process(lEAsyncMessage, lEVector);
        return true;
    }

    protected void notify(LEVector lEVector, String string, Object object) {
        if (lEVector == null) {
            return;
        }
        int n = lEVector.size();
        int n2 = 0;
        while (n2 < n) {
            LEAMObserver lEAMObserver = (LEAMObserver)lEVector.elementAt(n2);
            lEAMObserver.update(this, string, object);
            ++n2;
        }
    }
}

