/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.util.LEAppInfo;
import COM.livingston.util.LECipher;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEVector;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class LEDSSFlatFile {
    public static final int READ = 0;
    public static final int WRITE = 1;
    private static final String PASSWORD_KEY = "## PASS_ENC ";
    private static final String PASSWORD = "password";
    String m_fullpath;
    BufferedReader m_reader;
    BufferedWriter m_writer;
    int m_mode;

    public LEDSSFlatFile(String fullpath, int mode) {
        this.m_fullpath = fullpath;
        this.m_mode = mode;
    }

    public void writeHeader() {
        if (this.m_writer == null) {
            return;
        }
        PrintWriter prw = new PrintWriter(this.m_writer);
        prw.println('#');
        prw.println("# PortMaster Configuration File");
        prw.println('#');
        prw.print("# This file was generated by: ");
        prw.print(LEAppInfo.getAppName());
        prw.print(" v");
        prw.println(LEAppInfo.getAppVersion());
        prw.print("# ");
        Date date = new Date();
        DateFormat format = DateFormat.getDateTimeInstance(3, 1);
        prw.println(format.format(date));
        prw.println('#');
        prw.println("# NOTE: User passwords, RADIUS, ChoiceNet and OSPF area");
        prw.println("#       secrets are not saved.");
        prw.println("#       Location passwords are encrypted and saved.");
        prw.println('#');
        prw.println("# DO NOT EDIT");
        prw.println('#');
    }

    /*
     * Unable to fully structure code
     */
    public void writeComments(String comments) {
        if (this.m_writer == null || comments == null) {
            return;
        }
        prw = new PrintWriter(this.m_writer);
        len = comments.length();
        ptr = 0;
        last = 0;
        ** GOTO lbl14
        {
            ++ptr;
            do {
                if (ptr < len && comments.charAt(ptr) != '\n') continue block0;
                prw.print("# ");
                prw.println(comments.substring(last, ptr++));
                last = ptr;
lbl14:
                // 2 sources

            } while (ptr < len);
        }
        prw.println('#');
        prw.flush();
    }

    public synchronized void writeSection(String section, LEVector commands) {
        if (this.m_writer == null) {
            return;
        }
        PrintWriter prw = new PrintWriter(this.m_writer);
        prw.println('#');
        prw.print("# ");
        prw.println(section);
        prw.println('#');
        int len = 0;
        if (commands != null) {
            len = commands.size();
        }
        int i = 0;
        while (i < len) {
            this.writeCommand(prw, (String)commands.elementAt(i));
            ++i;
        }
        prw.flush();
        prw = null;
    }

    public synchronized void writeConfig(LEVector commands) {
        if (this.m_writer == null || commands == null) {
            return;
        }
        PrintWriter prw = new PrintWriter(this.m_writer);
        int len = commands.size();
        int i = 0;
        while (i < len) {
            String command = (String)commands.elementAt(i);
            this.writeCommand(prw, command);
            ++i;
        }
        prw.flush();
        prw = null;
    }

    public synchronized LEVector getCommands() {
        return this.loadCommands();
    }

    public boolean isConnected() {
        return this.m_reader != null || this.m_writer != null;
    }

    public void disconnect() throws IOException {
        if (this.m_reader != null) {
            this.m_reader.close();
            this.m_reader = null;
        } else if (this.m_writer != null) {
            this.m_writer.close();
            this.m_writer = null;
        }
    }

    public void connect() throws IOException {
        if (this.m_mode == 0 && this.m_reader == null) {
            if (this.m_fullpath == null) {
                throw new IOException("Null path");
            }
            File file = new File(this.m_fullpath);
            try {
                FileReader reader = new FileReader(file);
                this.m_reader = new BufferedReader(reader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.m_reader = null;
                String msg = String.valueOf(this.m_fullpath) + " not found";
                throw new IOException(msg);
            }
            catch (SecurityException securityException) {
                this.m_reader = null;
                String msg = "No permission to read " + this.m_fullpath;
                throw new IOException(msg);
            }
        } else if (this.m_mode == 1 && this.m_writer == null) {
            if (this.m_fullpath == null) {
                PrintWriter pw = new PrintWriter(System.out, true);
                try {
                    this.m_writer = new BufferedWriter(pw);
                    this.writeHeader();
                }
                catch (SecurityException securityException) {
                    this.m_writer = null;
                    String msg = "No permission to write to stdout";
                    throw new IOException(msg);
                }
            } else {
                File file = new File(this.m_fullpath);
                try {
                    FileWriter writer = new FileWriter(file);
                    this.m_writer = new BufferedWriter(writer);
                    this.writeHeader();
                }
                catch (IOException e) {
                    this.m_writer = null;
                    throw e;
                }
                catch (SecurityException securityException) {
                    this.m_writer = null;
                    String msg = "No permission to write to " + this.m_fullpath;
                    throw new IOException(msg);
                }
            }
        } else {
            LEDebug.getLog().log(30, "Connect called when already connected to: ");
            LEDebug.getLog().log(30, this.m_fullpath);
        }
    }

    protected LEVector loadCommands() {
        LEVector cmds = new LEVector();
        try {
            String line = this.m_reader.readLine();
            while (line != null) {
                if (line.length() > 3) {
                    if (line.startsWith(PASSWORD_KEY)) {
                        int loc = line.indexOf(PASSWORD) + PASSWORD.length() + 1;
                        String password = line.substring(PASSWORD_KEY.length(), loc);
                        String encrypt = line.substring(loc);
                        line = password = String.valueOf(password) + LECipher.Decrypt(encrypt);
                    }
                    cmds.addElement(line);
                }
                line = this.m_reader.readLine();
            }
        }
        catch (IOException e) {
            LEDebug.getLog().logln(20, e);
        }
        return cmds;
    }

    private void writeCommand(PrintWriter prw, String command) {
        int loc = command.indexOf(PASSWORD);
        if (loc != -1) {
            String password = new String(PASSWORD_KEY);
            password = String.valueOf(password) + command.substring(0, loc += PASSWORD.length() + 1);
            String pass = command.substring(loc);
            command = password = String.valueOf(password) + LECipher.Encrypt(pass);
        }
        prw.println(command);
    }
}

