/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPMOpFailureException;
import COM.livingston.backend.LEDSSPMTftpUpgrade;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LESendResponse;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEInteger;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEStatusManager;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;

public class LEDSSPMUpgrade
extends LEObservable {
    static final int UpgradeModeOpCode = 0;
    static final int UpgradeModeOpDownHeader = 1;
    static final int UpgradeModeOpDownData = 2;
    static final int UpgradeModeOpRenameHeader = 3;
    static final int UpgradeModeOpDownLoaderStart = 4;
    static final int UpgradeModeOpDownLoaderData = 5;
    static final int UpgradeModeOpPatch = 6;
    static final int UpgradeModeOpPatchData = 7;
    static final int UpgradeModeOpNoopNew = 8;
    static final int UpgradeInstOpDownload = 1;
    static final int UpgradeInstOpRename = 2;
    static final int UpgradeInstOpLoader = 3;
    static final int UpgradeInstOpPatch = 4;
    static final int UpgradeInstOpNoop = 5;
    static final int TIMEOUT = 80000;
    int m_mode;
    int m_toRead;
    int m_flashSpecialHandling;
    int m_loadingOS;
    int m_nBytes;
    int m_totalBytes;
    byte[] m_data;
    File m_inputFile;
    FileInputStream m_inStream;
    String m_fileName;
    String m_release;
    int m_sendCount;
    int m_nRead;
    LEDSSPortMaster m_dss;
    LEStatusManager m_status;

    public LEDSSPMUpgrade(File in, LEDSSPortMaster pm) throws FileNotFoundException {
        this.m_inputFile = in;
        this.m_dss = pm;
        this.m_status = new LEStatusManager();
    }

    public LEStatusManager getStatusManager() {
        return this.m_status;
    }

    public void doUpgrade() throws LEDSSException, IOException {
        this.m_inStream = new FileInputStream(this.m_inputFile);
        if (this.isTftpFile()) {
            this.doTFTPUpgrade();
        } else {
            this.doBinaryUpgrade();
        }
        this.m_inStream.close();
        this.m_inStream = null;
        this.m_status = null;
    }

    boolean isTftpFile() throws IOException {
        boolean isit = true;
        int count = 512;
        this.m_data = new byte[count];
        this.m_nRead = this.m_inStream.read(this.m_data, 0, count);
        int ii = 0;
        while (ii < count) {
            if (this.m_data[ii] != 10 && this.m_data[ii] != 13 && !this.isPrint(this.m_data[ii])) {
                isit = false;
                break;
            }
            ++ii;
        }
        this.m_inStream.close();
        this.m_inStream = new FileInputStream(this.m_inputFile);
        return isit;
    }

    void doTFTPUpgrade() throws LEDSSException {
        InputStreamReader reader = new InputStreamReader(this.m_inStream);
        BufferedReader breader = new BufferedReader(reader);
        LEDSSPMTftpUpgrade tftpUp = new LEDSSPMTftpUpgrade(this.m_dss, breader, this.m_status);
        tftpUp.doTftpUpgrade();
    }

    void doBinaryUpgrade() throws LEDSSException, IOException {
        Object sMode = null;
        this.m_data = new byte[256];
        int oldMode = -1;
        this.dump("Doing Upgrade");
        this.m_status.setStatus(0);
        this.m_mode = 0;
        this.m_toRead = 1;
        while (this.m_toRead > 0) {
            this.m_nRead = this.m_inStream.read(this.m_data, 0, this.m_toRead);
            LEDebug.getLog().logln(40, "Read " + Integer.toString(this.m_nRead) + " bytes");
            if (this.m_nRead == -1) {
                if (this.m_mode != 0) {
                    throw new EOFException();
                }
                return;
            }
            this.m_toRead = 0;
            switch (this.m_mode) {
                case 0: {
                    if (oldMode != this.m_mode) {
                        this.m_status.setStatus("Reading OP Code", 0);
                    }
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpCode();
                    break;
                }
                case 1: {
                    if (oldMode != this.m_mode) {
                        this.m_status.setStatus("Downloading Header", 0);
                    }
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpDownHeader();
                    break;
                }
                case 2: {
                    if (oldMode != this.m_mode) {
                        this.m_status.setStatus("Downloading Data", 0);
                    }
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpDownData();
                    break;
                }
                case 3: {
                    if (oldMode != this.m_mode) {
                        this.m_status.setStatus("Renaming Header", 0);
                    }
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpRenameHeader();
                    break;
                }
                case 4: {
                    if (oldMode != this.m_mode) {
                        this.m_status.setStatus("Starting Downloader", 0);
                    }
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpDownLoaderStart();
                    break;
                }
                case 5: {
                    if (oldMode != this.m_mode) {
                        this.m_status.setStatus("Downloading Data", 0);
                    }
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpDownLoaderData();
                    break;
                }
                case 6: {
                    if (oldMode != this.m_mode) {
                        this.m_status.setStatus("Starting Patch", 0);
                    }
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpPatch();
                    break;
                }
                case 7: {
                    if (oldMode != this.m_mode) {
                        this.m_status.setStatus("Patching Data", 0);
                    }
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpPatchData();
                    break;
                }
                case 8: {
                    oldMode = this.m_mode;
                    this.doUpgradeModeOpNoopNew();
                    break;
                }
                default: {
                    this.dump("Mode: Unknown");
                    break;
                }
            }
        }
    }

    void doUpgradeModeOpCode() throws LEDSSException, IOException {
        switch (this.m_data[0]) {
            case 1: {
                this.dump("OP Code: UpgradeInstOpDownload");
                this.m_mode = 1;
                this.m_toRead = 36;
                break;
            }
            case 2: {
                this.dump("OP Code: UpgradeInstOpRename");
                this.m_mode = 3;
                this.m_toRead = 64;
                break;
            }
            case 3: {
                this.dump("OP Code: UpgradeInstOpLoader");
                this.m_mode = 4;
                this.m_toRead = 36;
                break;
            }
            case 4: {
                this.dump("OP Code: UpgradeInstOpPatch");
                this.m_mode = 6;
                this.m_toRead = 4;
                break;
            }
            case 5: {
                this.dump("OP Code: UpgradeInstOpNoop");
                this.m_mode = 0;
                this.m_toRead = 1;
                break;
            }
            default: {
                this.m_toRead = 0;
            }
        }
    }

    void doUpgradeModeOpDownHeader() throws LEDSSException, IOException {
        this.m_fileName = new String(this.m_data, 0, 16);
        this.m_release = new String(this.m_data, 16, 16);
        this.m_nBytes = this.m_totalBytes = LEInteger.ParseInt(this.m_data, 32);
        this.dump("Download Header Filename: " + this.m_fileName + " Release: " + this.m_release);
        this.dump("Num Bytes = " + Integer.toString(this.m_totalBytes));
        this.send((byte)5, this.m_fileName);
        this.m_toRead = this.m_totalBytes > 256 ? 256 : this.m_totalBytes;
        this.m_mode = 2;
        this.m_sendCount = 0;
    }

    void doUpgradeModeOpDownData() throws LEDSSException, IOException {
        int pct;
        LEDebug.getLog().logln(40, "Sending " + Integer.toString(this.m_nRead) + " bytes");
        this.send((byte)6, (short)this.m_nRead, this.m_data);
        this.m_nBytes -= this.m_nRead;
        int n = this.m_toRead = this.m_nBytes > 256 ? 256 : this.m_nBytes;
        if (this.m_toRead == 0) {
            this.send((byte)6, (short)0, this.m_data);
            this.m_mode = 0;
            this.m_toRead = 1;
        }
        if ((pct = (this.m_totalBytes - this.m_nBytes) * 100 / this.m_totalBytes) != this.m_status.getPercent()) {
            this.m_status.setStatus(pct);
        }
    }

    void doUpgradeModeOpRenameHeader() throws LEDSSException, IOException {
        String oldFile = new String(this.m_data, 0, 32);
        String newFile = new String(this.m_data, 32, 32);
        int olen = oldFile.length();
        int nlen = newFile.length();
        byte[] bytes = new byte[olen + nlen + 2];
        byte[] tmp = oldFile.getBytes();
        System.arraycopy(tmp, 0, bytes, 0, olen);
        tmp = newFile.getBytes();
        System.arraycopy(tmp, 0, bytes, olen + 1, nlen);
        this.send((byte)7, (short)(olen + nlen + 2), bytes);
    }

    void doUpgradeModeOpDownLoaderStart() {
    }

    void doUpgradeModeOpDownLoaderData() {
    }

    void doUpgradeModeOpPatch() {
        this.m_mode = 7;
        this.m_toRead = this.m_totalBytes = LEInteger.ParseInt(this.m_data);
    }

    void doUpgradeModeOpPatchData() throws LEDSSException, IOException {
        this.send((byte)10, (short)(this.m_data[3] + 4), this.m_data);
        this.m_mode = 0;
        this.m_toRead = 1;
    }

    void doUpgradeModeOpNoopNew() {
    }

    void dump(String string) {
    }

    void send(byte cmd, String data) throws LEDSSException, IOException {
        byte[] dst = data.getBytes();
        this.send(cmd, (short)data.length(), dst);
    }

    void send(byte cmd, short len, byte[] data) throws LEDSSException, IOException {
        LEDebug.getLog().logln(40, "Sending " + LEDSSPortMaster.GetOpCodeString(cmd) + " Length: " + Integer.toString(this.m_nRead) + " bytes");
        LESendResponse resp = this.m_dss.send(cmd, len, data, false, 80000);
        if (!resp.successful()) {
            throw new LEDSSPMOpFailureException("Data Send Failed: " + LEDSSPortMaster.GetOpCodeString(cmd));
        }
    }

    boolean isPrint(byte b) {
        if (b >= 32 && b <= 126) {
            return true;
        }
        return b == 9 || b == 10 || b == 13;
    }
}

