/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.backend;

import COM.livingston.util.LEDebug;
import java.io.PrintWriter;

public class LESendBuf {
    public byte m_idByte;
    public byte m_opCode = (byte)102;
    public short m_sendLength;
    public byte[] m_data;
    byte[] m_tmp;
    int m_size;

    public synchronized byte[] getBytes() {
        if (this.m_tmp == null) {
            this.m_tmp = new byte[this.m_size + 4];
        }
        this.m_tmp[0] = this.m_idByte;
        this.m_tmp[1] = this.m_opCode;
        this.m_tmp[2] = (byte)(this.m_sendLength / 256);
        this.m_tmp[3] = (byte)(this.m_sendLength % 256);
        System.arraycopy(this.m_data, 0, this.m_tmp, 4, this.m_sendLength);
        return this.m_tmp;
    }

    public synchronized void reset() {
        if (this.m_data == null) {
            return;
        }
        int i = 0;
        while (i < this.m_data.length) {
            this.m_data[i] = 0;
            ++i;
        }
    }

    public synchronized void dump(PrintWriter pw) {
        pw.println();
        pw.println(this.toString());
        pw.println();
    }

    public synchronized String toString() {
        StringBuffer sBuf = new StringBuffer();
        if (this.m_data != null) {
            int ii = 0;
            while (ii < this.m_data.length) {
                int jj = 0;
                while (jj < 60 && ii < this.m_data.length) {
                    switch (this.m_data[ii]) {
                        default: {
                            sBuf.append((char)this.m_data[ii]);
                        }
                        case 0: 
                        case 10: 
                    }
                    ++jj;
                    ++ii;
                }
                if (ii < this.m_data.length && this.m_data[ii] == 0) break;
            }
        }
        return sBuf.toString();
    }

    public void setSize(int size) {
        if (size > 2048) {
            LEDebug.getLog().logln(20, "Creating a LESendBuf of size: " + size);
        }
        this.m_data = new byte[size];
        this.m_size = size;
    }
}

