/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineEvent;
import COM.livingston.forms.LEFormLineListener;
import COM.livingston.model.LEAttributes;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEPortMaster;
import COM.livingston.ui.LETextField;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEHelpManager;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LEIdleFormLine
extends Panel
implements LEFormLine,
ActionListener,
ItemListener,
MouseListener {
    public static final String MINUTES_STR = new String("minutes");
    public static final String SECONDS_STR = new String("seconds");
    static final int MINUTES = 0;
    static final int SECONDS = 1;
    LETextField m_idle;
    Checkbox m_seconds;
    Checkbox m_minutes;
    int m_state;
    int m_min;
    int m_max = 240;
    String m_valid;
    LEFormLineListener m_listener;

    public LEIdleFormLine() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.m_idle = new LETextField(3);
        this.m_idle.setNumeric(true);
        this.m_idle.addActionListener(this);
        this.add(this.m_idle);
        this.add(new Label(""));
        CheckboxGroup checkboxGroup = new CheckboxGroup();
        this.m_state = 1;
        this.m_seconds = new Checkbox(SECONDS_STR, checkboxGroup, true);
        this.m_seconds.addItemListener(this);
        this.m_minutes = new Checkbox(MINUTES_STR, checkboxGroup, false);
        this.m_minutes.addItemListener(this);
        this.add(this.m_seconds);
        this.add(this.m_minutes);
        this.addMouseListener(this);
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
        if (lEDataSpec == null) {
            return;
        }
        String string = (String)lEDataSpec.getAttribute(LEAttributes.MINIMUM);
        if (string != null) {
            try {
                this.m_min = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
        }
        if ((string = (String)lEDataSpec.getAttribute(LEAttributes.MAXIMUM)) != null) {
            try {
                this.m_max = Integer.parseInt(string);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
                return;
            }
        }
    }

    public void setValue(Object object) {
        String string = object.toString();
        String string2 = null;
        int n = string.indexOf(32);
        if (n > -1) {
            string2 = string.substring(n + 1, string.length());
            string = string.substring(0, n);
        }
        ((TextComponent)this.m_idle).setText(string);
        if (string2 != null && string2.equalsIgnoreCase(SECONDS_STR)) {
            this.m_seconds.setState(true);
            return;
        }
        this.m_minutes.setState(true);
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.m_idle.getText();
        if (string.length() > 0) {
            try {
                int n = Integer.parseInt(string);
                n = Math.max(n, this.m_min);
                n = Math.min(n, this.m_max);
                stringBuffer.append(Integer.toString(n));
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
                stringBuffer.append(Integer.toString(this.m_min));
            }
        } else {
            stringBuffer.append(Integer.toString(0));
        }
        stringBuffer.append(' ');
        if (this.m_seconds.getState()) {
            stringBuffer.append(SECONDS_STR);
        } else {
            stringBuffer.append(MINUTES_STR);
        }
        return new String(stringBuffer);
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.m_min);
            stringBuffer.append(" - ");
            stringBuffer.append(this.m_max);
            stringBuffer.append(" minutes or seconds");
            this.m_valid = stringBuffer.toString();
        }
        return this.m_valid;
    }

    public boolean isValueValid() {
        int n = 0;
        try {
            String string = this.m_idle.getText();
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            LEDebug.getLog().logln(20, numberFormatException);
        }
        if (n < this.m_min) {
            return false;
        }
        return n <= this.m_max;
    }

    public boolean equalsField(Object object) {
        if (object != null) {
            String string = object.toString();
            String string2 = this.getValue();
            return string2.equalsIgnoreCase(string);
        }
        return false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.notifyListener();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.notifyListener();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        LEHelpManager.SetHelp(this.getValidValues());
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    void notifyListener() {
        if (this.m_listener != null) {
            LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(lEFormLineEvent);
        }
    }
}

