/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEStringFormLine;
import COM.livingston.model.LEAttributes;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEDebug;

public class LEIntegerFormLine
extends LEStringFormLine {
    public static final int MAX_WIDTH = 12;
    boolean m_minFlag;
    long m_min;
    boolean m_maxFlag;
    long m_max = 65535L;
    int m_pad;
    String m_valid;

    public LEIntegerFormLine() {
        this.setColumns(12);
        this.setNumeric(true);
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
        super.initFormLine(lEPortMaster, lEDataSpec);
        if (lEDataSpec != null) {
            String string;
            if (lEDataSpec.getAttribute(LEAttributes.HEX) != null) {
                this.setHex(true);
            }
            if ((string = (String)lEDataSpec.getAttribute(LEAttributes.MAXIMUM)) != null) {
                try {
                    this.m_max = this.isHex() ? Long.parseLong(string, 16) : Long.parseLong(string);
                    this.m_maxFlag = true;
                    this.setColumns(string.length());
                }
                catch (NumberFormatException numberFormatException) {
                    LEDebug.getLog().logln(20, numberFormatException);
                }
            }
            if ((string = (String)lEDataSpec.getAttribute(LEAttributes.MINIMUM)) != null) {
                try {
                    this.m_min = this.isHex() ? Long.parseLong(string, 16) : Long.parseLong(string);
                    this.m_minFlag = true;
                }
                catch (NumberFormatException numberFormatException) {
                    LEDebug.getLog().logln(20, numberFormatException);
                }
            }
            if ((string = (String)lEDataSpec.getAttribute(LEAttributes.PADLENGTH)) != null) {
                try {
                    this.m_pad = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    LEDebug.getLog().logln(20, numberFormatException);
                }
            }
            if (this.m_minFlag || this.m_maxFlag) {
                this.setBounds(this.m_min, this.m_max);
            }
        }
    }

    public String getValue() {
        String string = this.getText();
        int n = string.length();
        if (this.m_minFlag && n == 0) {
            string = Long.toString(this.getLongValue());
        }
        n = string.length();
        if (this.m_pad > 0 && (this.m_minFlag || n > 0)) {
            n = Math.min(n, this.m_pad);
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = n;
            while (n2 < this.m_pad) {
                stringBuffer.append('0');
                ++n2;
            }
            stringBuffer.append(string.substring(0, n));
            string = new String(stringBuffer);
        }
        return string;
    }

    public String getValidValues() {
        if (this.m_valid == null) {
            StringBuffer stringBuffer = new StringBuffer("Any integer");
            if (this.m_minFlag && this.m_maxFlag) {
                stringBuffer.append(" between ");
                stringBuffer.append(this.m_min);
                stringBuffer.append(" and ");
                stringBuffer.append(this.m_max);
            } else if (this.m_minFlag) {
                stringBuffer.append(" greater than ");
                stringBuffer.append(this.m_min);
            } else if (this.m_maxFlag) {
                stringBuffer.append(" less than ");
                stringBuffer.append(this.m_min);
            }
            this.m_valid = stringBuffer.toString();
        }
        return this.m_valid;
    }

    public boolean equalsField(Object object) {
        if (object != null) {
            String string = object.toString();
            String string2 = this.getText();
            if (string2.length() == 0 && string.length() == 0) {
                return true;
            }
            long l = this.getLongValue();
            try {
                long l2 = 0L;
                l2 = this.isHex() ? Long.parseLong(string, 16) : Long.parseLong(string);
                return l2 == l;
            }
            catch (Exception exception) {
                LEDebug.getLog().logln(20, exception);
            }
        }
        return false;
    }

    public boolean isValueValid() {
        long l = this.getLongValue();
        if (this.m_minFlag && l < this.m_min) {
            return false;
        }
        return !this.m_maxFlag || l <= this.m_max;
    }

    long getLongValue() {
        long l;
        block4: {
            String string = this.getText();
            long l2 = l = this.m_minFlag ? this.m_min : 0L;
            if (string.length() <= 0) break block4;
            try {
                l = this.isHex() ? Long.parseLong(string, 16) : Long.parseLong(string);
                if (this.m_minFlag) {
                    l = Math.max(l, this.m_min);
                }
                if (this.m_maxFlag) {
                    l = Math.min(l, this.m_max);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LEDebug.getLog().logln(20, numberFormatException);
            }
        }
        return l;
    }
}

