/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.forms;

import COM.livingston.forms.LEFormLine;
import COM.livingston.forms.LEFormLineEvent;
import COM.livingston.forms.LEFormLineListener;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEPortMaster;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;

public class LESyslogFormLine
extends Panel
implements LEFormLine,
ItemListener {
    public static final String DISABLED = new String("disabled");
    public static final String FACILITY = new String("facility");
    public static final String PRIORITY = new String("priority");
    public static final String VALID = "";
    Checkbox m_disabled;
    Choice m_facility;
    Choice m_priority;
    LEFormLineListener m_listener;

    public LESyslogFormLine() {
        this.setLayout(new FlowLayout());
        this.m_disabled = new Checkbox("Enable");
        this.add(this.m_disabled);
        this.m_disabled.addItemListener(this);
        this.m_facility = new Choice();
        this.add(this.m_facility);
        this.m_facility.addItemListener(this);
        this.add(new Label("."));
        this.m_priority = new Choice();
        this.add(this.m_priority);
        this.m_priority.addItemListener(this);
        this.setState();
    }

    public void initFormLine(LEPortMaster lEPortMaster, LEDataSpec lEDataSpec) {
        if (lEDataSpec != null) {
            int n;
            int n2;
            Vector vector;
            Object object = lEDataSpec.getAttribute(FACILITY);
            if (object instanceof Vector) {
                vector = (Vector)object;
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    this.m_facility.addItem((String)vector.elementAt(n));
                    ++n;
                }
            } else if (object instanceof String) {
                this.m_facility.addItem((String)object);
            }
            object = lEDataSpec.getAttribute(PRIORITY);
            if (object instanceof Vector) {
                vector = (Vector)object;
                n2 = vector.size();
                n = 0;
                while (n < n2) {
                    this.m_priority.addItem((String)vector.elementAt(n));
                    ++n;
                }
                return;
            }
            if (object instanceof String) {
                this.m_priority.addItem((String)object);
            }
        }
    }

    public void setState() {
        if (this.m_disabled.getState()) {
            this.m_facility.setEnabled(true);
            this.m_priority.setEnabled(true);
            return;
        }
        this.m_facility.setEnabled(false);
        this.m_priority.setEnabled(false);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.setState();
        if (this.m_listener != null) {
            LEFormLineEvent lEFormLineEvent = new LEFormLineEvent(this, this.getValue());
            this.m_listener.formLineValueChanged(lEFormLineEvent);
        }
    }

    public void setListener(LEFormLineListener lEFormLineListener) {
        this.m_listener = lEFormLineListener;
    }

    public void setValue(Object object) {
        if (object instanceof String) {
            String string = ((String)object).toLowerCase();
            if (string.length() == 0 || string.equalsIgnoreCase(DISABLED)) {
                this.m_disabled.setState(false);
            } else {
                this.m_disabled.setState(true);
                int n = string.indexOf(46);
                if (n == -1) {
                    this.m_facility.select(string);
                    this.m_priority.select(string);
                } else {
                    this.m_facility.select(string.substring(0, n));
                    this.m_priority.select(string.substring(n + 1, string.length()));
                }
            }
        } else {
            this.m_disabled.setState(false);
        }
        this.setState();
    }

    public String getValue() {
        if (!this.m_disabled.getState()) {
            return DISABLED;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.m_facility.getSelectedItem());
        stringBuffer.append(".");
        stringBuffer.append(this.m_priority.getSelectedItem());
        return stringBuffer.toString();
    }

    public String getValidValues() {
        return VALID;
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean equalsField(Object object) {
        if (object != null) {
            String string = object.toString();
            String string2 = this.getValue();
            return string2.equalsIgnoreCase(string);
        }
        return false;
    }
}

