/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEDataSpec;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEAlphaNumericCompare;
import COM.livingston.util.LEObservable;
import COM.livingston.util.LEVector;
import java.util.Enumeration;
import java.util.Hashtable;

public class LEConfig
extends LEObservable
implements Cloneable {
    public static final String BLANK = "";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final String FALSE = "false";
    public static final String OFF = "off";
    public static final String ON = "on";
    public static final String SPACE = " ";
    public static final String TRUE = "true";
    public static final String ADD = "add ";
    public static final String DELETE = "delete ";
    public static final String REBOOT = "reboot";
    public static final String SAVE_ALL = "save all";
    public static final String SET = "set ";
    public static final String VERSION = "version";
    LEPortMaster m_pm;
    Hashtable m_fields = new Hashtable();
    LEVector m_changes;
    LEDataSpec m_spec;
    LEConfig m_owner;

    public LEConfig(LEPortMaster pm) {
        this.m_pm = pm;
    }

    public Object clone() {
        LEConfig config = new LEConfig(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public void copyTo(LEConfig config) {
        LEVector keys = this.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            String key = (String)keys.elementAt(i);
            Object obj = this.get(key);
            if (obj instanceof LEConfig) {
                LEConfig newConfig = config.getConfig(key);
                ((LEConfig)obj).copyTo(newConfig);
            } else {
                config.set(key, obj);
            }
            ++i;
        }
    }

    public void cloneFrom(LEConfig config) {
        LEVector keys = config.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            String key = (String)keys.elementAt(i);
            Object obj = config.get(key);
            if (obj instanceof LEConfig) {
                LEConfig newConfig = this.getConfig(key);
                newConfig.cloneFrom((LEConfig)obj);
            } else {
                this.set(key, obj);
            }
            ++i;
        }
    }

    public LEVector getKeys() {
        LEVector keys = new LEVector();
        Enumeration enumeration = this.m_fields.keys();
        while (enumeration.hasMoreElements()) {
            keys.addElement((String)enumeration.nextElement());
        }
        keys.quickSort(LEAlphaNumericCompare.GetCompareObject());
        return keys;
    }

    public LEPortMaster getPortMaster() {
        return this.m_pm;
    }

    public LEConfig getOwner() {
        return this.m_owner;
    }

    public boolean requiresReboot(String key) {
        return false;
    }

    public Object get(String key) {
        return this.m_fields.get(key);
    }

    public boolean getChanges(LEVector cmds) {
        boolean gen = this.getChangedCommands(cmds);
        if (gen) {
            cmds.addElement(SAVE_ALL);
        }
        return gen;
    }

    public boolean getCommands(LEVector cmds) {
        boolean gen = this.getAllCommands(cmds);
        if (gen) {
            cmds.addElement(SAVE_ALL);
        }
        return gen;
    }

    public void set(String key, Object value) {
        if (this.m_changes == null) {
            this.m_changes = new LEVector();
        }
        this.m_changes.addUnique(key);
        this.m_fields.put(key, value);
        if (value instanceof LEConfig) {
            ((LEConfig)value).setOwner(this);
        }
        this.setChanged();
        this.notifyObservers(key);
    }

    public void setPortMaster(LEPortMaster pm) {
        this.m_pm = pm;
        LEVector keys = this.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            String key = (String)keys.elementAt(i);
            Object obj = this.get(key);
            if (obj instanceof LEConfig) {
                ((LEConfig)obj).setPortMaster(pm);
            }
            ++i;
        }
    }

    public void setOwner(LEConfig owner) {
        this.m_owner = owner;
    }

    public void refresh() {
        this.refresh(this);
    }

    public LEVector saveChanges() {
        return this.saveChanges(true);
    }

    public LEVector saveChanges(boolean reboot) {
        LEVector errors = null;
        LEVector cmds = new LEVector();
        if (this.getChanges(cmds)) {
            int len = cmds.size();
            int i = 0;
            while (i < len) {
                LEPMCommand ret;
                String cmd = (String)cmds.elementAt(i);
                if (!(LEPMCommand.IsReboot(cmd) && !reboot || (ret = this.m_pm.execute(cmd)).getStatus())) {
                    if (errors == null) {
                        errors = new LEVector();
                    }
                    errors.addElement(ret);
                }
                ++i;
            }
        }
        return errors;
    }

    public void setSpec(LEDataSpec spec) {
        this.m_spec = spec;
    }

    public String getDescription() {
        String des = BLANK;
        if (this.m_spec != null) {
            des = this.m_spec.getDescription();
        }
        return des;
    }

    public LEDataSpec getSpec() {
        return this.m_spec;
    }

    public LEDataSpec getSpecFor(String key) {
        LEDataSpec spec = null;
        if (this.m_spec != null) {
            spec = this.m_spec.getSpecFor(key);
        }
        return spec;
    }

    public String getDescriptionFor(String key) {
        String des = BLANK;
        LEDataSpec spec = this.getSpecFor(key);
        if (spec != null) {
            des = spec.getDescription();
        }
        return des;
    }

    public String getTypeFor(String key) {
        String type = BLANK;
        LEDataSpec spec = this.getSpecFor(key);
        if (spec != null) {
            type = spec.getDescription();
        }
        return type;
    }

    public Object getAttributeFor(String key, String attrName) {
        Object attr = null;
        LEDataSpec spec = this.getSpecFor(key);
        if (spec != null) {
            attr = spec.getAttribute(attrName);
        }
        return attr;
    }

    public boolean hasDependencies(String key) {
        boolean dep = false;
        LEDataSpec spec = this.getSpecFor(key);
        if (spec != null) {
            dep = spec.hasDependencies();
        }
        return dep;
    }

    void refresh(LEConfig config) {
        if (this.m_owner != null) {
            this.m_owner.refresh(this);
        }
    }

    boolean getChangedCommands(LEVector cmds) {
        LEVector children;
        if (cmds == null) {
            return false;
        }
        boolean gen = false;
        if (this.m_changes != null) {
            gen = this.generateCommands(this.m_changes, cmds);
            this.m_changes.removeAllElements();
            this.m_changes = null;
        }
        if ((children = this.getChildren()) != null) {
            int len = children.size();
            int i = 0;
            while (i < len) {
                gen |= this.getChildChanges((LEConfig)children.elementAt(i), cmds);
                ++i;
            }
        }
        return gen;
    }

    boolean getAllCommands(LEVector cmds) {
        if (cmds == null) {
            return false;
        }
        boolean gen = this.generateCommands(null, cmds);
        LEVector children = this.getChildren();
        if (children != null) {
            int len = children.size();
            int i = 0;
            while (i < len) {
                gen |= this.getChildCommands((LEConfig)children.elementAt(i), cmds);
                ++i;
            }
        }
        return gen;
    }

    boolean getChildChanges(LEConfig child, LEVector cmds) {
        return child.getChangedCommands(cmds);
    }

    boolean getChildCommands(LEConfig child, LEVector cmds) {
        return child.getAllCommands(cmds);
    }

    LEVector getChildren() {
        LEVector children = null;
        LEVector keys = this.getKeys();
        int len = keys.size();
        int i = 0;
        while (i < len) {
            Object obj = this.get((String)keys.elementAt(i));
            if (obj instanceof LEConfig) {
                if (children == null) {
                    children = new LEVector();
                }
                children.addElement(obj);
            }
            ++i;
        }
        return children;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        return false;
    }

    void setField(String key, Object value) {
        if (this.m_changes != null && this.m_changes.contains(key)) {
            return;
        }
        this.m_fields.put(key, value);
        this.setChanged();
        this.notifyObservers(key);
    }

    LEConfig getConfig(String key) {
        Object obj = this.m_fields.get(key);
        if (obj instanceof LEConfig) {
            return (LEConfig)obj;
        }
        LEConfig config = this.createConfig(key);
        config.setSpec(this.getSpecFor(key));
        config.setOwner(this);
        this.setField(key, config);
        return config;
    }

    LEConfig createConfig(String key) {
        return new LEConfig(this.m_pm);
    }

    boolean makeAddCommand(LEVector cmds, String name, String key, String tag) {
        return this.makeCommand(ADD, cmds, name, key, tag);
    }

    boolean makeDeleteCommand(LEVector cmds, String name, String key, String tag) {
        return this.makeCommand(DELETE, cmds, name, key, tag);
    }

    boolean makeSetCommand(LEVector cmds, String name, String key, String tag) {
        return this.makeCommand(SET, cmds, name, key, tag);
    }

    boolean makeCommand(String cmd, LEVector cmds, String name, String key, String tag) {
        boolean gen = false;
        Object value = this.get(key);
        if (value instanceof String) {
            StringBuffer buf = new StringBuffer(cmd);
            if (name != null) {
                buf.append(name);
                buf.append(SPACE);
            }
            if (tag != null) {
                buf.append(tag);
                buf.append(SPACE);
            }
            buf.append((String)value);
            cmds.addElement(new String(buf));
            gen = true;
        }
        return gen;
    }

    boolean makeRIPCommand(LEVector cmds, String name, String tag, String broadcast, String listen) {
        boolean broad = false;
        boolean list = false;
        if (broadcast != null && broadcast.equals(ON)) {
            broad = true;
        }
        if (listen != null && listen.equals(ON)) {
            list = true;
        }
        StringBuffer buf = new StringBuffer(SET);
        if (name != null) {
            buf.append(name);
            buf.append(SPACE);
        }
        buf.append(tag);
        buf.append(SPACE);
        if (broad && list) {
            buf.append(ON);
        } else if (broad) {
            buf.append("broadcast");
        } else if (list) {
            buf.append("listen");
        } else {
            buf.append(OFF);
        }
        cmds.addElement(new String(buf));
        return true;
    }

    boolean makeServiceCommand(LEVector cmds, String name, String key, String tag) {
        if (key == null) {
            return false;
        }
        String svc = (String)this.get(key);
        if (svc == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer(SET);
        if (name != null) {
            buf.append(name);
            buf.append(SPACE);
        }
        if (tag != null) {
            buf.append(tag);
            buf.append(SPACE);
        }
        buf.append(svc.replace('@', ' '));
        cmds.addElement(new String(buf));
        return true;
    }

    void updateSaveStatus(String command, int total, int count) {
        int percent = 0;
        if (total > 0) {
            percent = count / total * 100;
        }
    }
}

