/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDBLoginUser;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LEDBLoginUsers
extends LETable {
    public LEDBLoginUsers(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LEDBLoginUsers config = new LEDBLoginUsers(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String name, String phone) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("user", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            cmd = this.makeSetCommand("user", name, "dialback", phone);
            ret = this.m_pm.execute(cmd);
        }
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("user", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LEDBLoginUser(this.m_pm, key);
    }

    boolean getChildCommands(LEConfig child, LEVector cmds) {
        LEDBLoginUser user = (LEDBLoginUser)child;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("user ");
        buf.append(user.getName());
        cmds.addElement(new String(buf));
        child.getAllCommands(cmds);
        return true;
    }
}

