/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.util.LEVector;
import java.util.Hashtable;

public class LEDataSpec {
    public static final String BLANK = "";
    public static final String ENTRY = "entry";
    public static final String KEY = "key";
    String m_tag = "";
    String m_description = "";
    String m_type = "";
    LEVector m_specs;
    Hashtable m_attributes;
    boolean m_dependencies;

    LEDataSpec(String tag, String description, String type, Hashtable attributes) {
        this.m_tag = tag;
        this.m_description = description;
        this.m_type = type;
        this.m_attributes = attributes;
        if (this.m_attributes != null && this.m_attributes.containsKey("#")) {
            this.m_dependencies = true;
            this.m_attributes.remove("#");
        }
    }

    public String getTag() {
        return this.m_tag;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Hashtable getAttributes() {
        return this.m_attributes;
    }

    public Object getAttribute(String name) {
        Object attr = null;
        if (this.m_attributes != null) {
            attr = this.m_attributes.get(name);
        }
        return attr;
    }

    public String getType() {
        return this.m_type;
    }

    public boolean hasDependencies() {
        return this.m_dependencies;
    }

    public LEDataSpec getSpecFor(String tag) {
        if (tag == null || this.m_specs == null) {
            return null;
        }
        LEDataSpec spec = null;
        int len = this.m_specs.size();
        int i = 0;
        while (spec == null && i < len) {
            spec = (LEDataSpec)this.m_specs.elementAt(i);
            String tmp = spec.getTag();
            if (!tag.equals(tmp) && !tmp.equals(ENTRY)) {
                spec = null;
            }
            ++i;
        }
        return spec;
    }

    public LEVector getAllSpecs() {
        return this.m_specs;
    }

    void addSpec(LEDataSpec spec) {
        if (this.m_specs == null) {
            this.m_specs = new LEVector();
        }
        this.m_specs.addElement(spec);
    }
}

