/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEFilterRule;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;
import java.util.Enumeration;

public class LEFilterRules
extends LETable {
    String m_name;
    String m_key;

    public LEFilterRules(LEPortMaster pm, String name, String key) {
        super(pm);
        this.m_name = name;
        this.m_key = key;
    }

    public Object clone() {
        LEFilterRules config = new LEFilterRules(this.m_pm, this.m_name, this.m_key);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String action) {
        LEVector errors = null;
        int num = this.size() + 1;
        StringBuffer buf = new StringBuffer("set ");
        buf.append(this.m_key);
        buf.append(" ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(num);
        buf.append(" ");
        buf.append(action);
        LEPMCommand ret = this.m_pm.execute(new String(buf));
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            if (ret.getStatus()) {
                LEFilterRule rule = (LEFilterRule)this.getConfig(Integer.toString(num));
                rule.initialize(action);
            } else {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(int ruleNum) {
        int numRules = this.size();
        if (ruleNum > numRules) {
            return null;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append(this.m_key);
        buf.append(" ");
        buf.append(this.m_name);
        buf.append(" blank");
        LEPMCommand ret = this.m_pm.execute(new String(buf));
        if (!ret.getStatus()) {
            LEVector errors = new LEVector();
            errors.addElement(ret);
            return errors;
        }
        int i = 1;
        while (i <= numRules) {
            LEFilterRule rule = (LEFilterRule)this.remove(Integer.toString(i));
            String num = i < ruleNum ? Integer.toString(i) : (i > ruleNum ? Integer.toString(i - 1) : null);
            if (num != null) {
                rule.setNumber(num);
                this.set(num, rule);
            }
            ++i;
        }
        LEVector errors = this.saveChanges();
        if (errors != null) {
            this.refresh();
        }
        return errors;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
        Enumeration enumeration = this.m_fields.elements();
        while (enumeration.hasMoreElements()) {
            ((LEFilterRule)enumeration.nextElement()).setName(this.m_name);
        }
    }
}

