/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEFilterRule;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LEIPXRule
extends LEFilterRule {
    public static final String ACTION = "action";
    public static final String DST_COMPARE = "dst_cmp";
    public static final String DST_HOST = "dst_host";
    public static final String DST_NET = "dst_net";
    public static final String DST_SOCKET = "dst_socket";
    public static final String SRC_COMPARE = "src_cmp";
    public static final String SRC_HOST = "src_host";
    public static final String SRC_NET = "src_net";
    public static final String SRC_SOCKET = "src_socket";
    public static final int KEY_COUNT = 9;
    public static final String DENY = "deny";
    public static final String PERMIT = "permit";
    static final String DEFAULT_NUM = "1";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[9];
            LEIPXRule.s_keys[0] = ACTION;
            LEIPXRule.s_keys[1] = DST_COMPARE;
            LEIPXRule.s_keys[2] = DST_HOST;
            LEIPXRule.s_keys[3] = DST_NET;
            LEIPXRule.s_keys[4] = DST_SOCKET;
            LEIPXRule.s_keys[5] = SRC_COMPARE;
            LEIPXRule.s_keys[6] = SRC_HOST;
            LEIPXRule.s_keys[7] = SRC_NET;
            LEIPXRule.s_keys[8] = SRC_SOCKET;
        }
        return s_keys;
    }

    public LEIPXRule(LEPortMaster pm, String name, String number) {
        super(pm, name, number);
    }

    public Object clone() {
        LEIPXRule config = new LEIPXRule(this.m_pm, this.m_name, this.m_number);
        this.copyTo(config);
        return config;
    }

    void initialize(String action) {
        this.setField(ACTION, action);
        this.setField(DST_COMPARE, "");
        this.setField(DST_HOST, "");
        this.setField(DST_NET, "");
        this.setField(DST_SOCKET, DEFAULT_NUM);
        this.setField(SRC_COMPARE, "");
        this.setField(SRC_HOST, "");
        this.setField(SRC_NET, "");
        this.setField(SRC_SOCKET, DEFAULT_NUM);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String action = (String)this.get(ACTION);
        if (this.m_name == null || this.m_number == null || action == null) {
            return false;
        }
        StringBuffer buf = new StringBuffer("set ");
        buf.append("ipxfilter ");
        buf.append(this.m_name);
        buf.append(" ");
        buf.append(this.m_number);
        buf.append(" ");
        buf.append(action);
        String tmp = (String)this.get(SRC_NET);
        if (tmp != null && tmp.length() > 0) {
            buf.append(" srcnet ");
            buf.append(tmp);
        }
        if ((tmp = (String)this.get(SRC_HOST)) != null && tmp.length() > 0) {
            buf.append(" srchost ");
            buf.append(tmp);
        }
        tmp = (String)this.get(SRC_COMPARE);
        String sck = (String)this.get(SRC_SOCKET);
        if (tmp != null && tmp.length() > 0 && sck != null && sck.length() > 0) {
            buf.append(" srcsocket ");
            buf.append(tmp);
            buf.append(" ");
            buf.append(sck);
        }
        if ((tmp = (String)this.get(DST_NET)) != null && tmp.length() > 0) {
            buf.append(" dstnet ");
            buf.append(tmp);
        }
        if ((tmp = (String)this.get(DST_HOST)) != null && tmp.length() > 0) {
            buf.append(" dsthost ");
            buf.append(tmp);
        }
        tmp = (String)this.get(DST_COMPARE);
        sck = (String)this.get(DST_SOCKET);
        if (tmp != null && tmp.length() > 0 && sck != null && sck.length() > 0) {
            buf.append(" dstsocket ");
            buf.append(tmp);
            buf.append(" ");
            buf.append(sck);
        }
        cmds.addElement(new String(buf));
        return true;
    }
}

