/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEGroup;
import COM.livingston.model.LEGroups;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LELine
extends LEConfig {
    public static final String CONFIG = "37";
    public static final String ENCODING = "26";
    public static final String FRAMING = "25";
    public static final String GROUPS = "groups";
    public static final String PCM = "27";
    public static final String LOOPBACK = "39";
    public static final String SIGNALING = "38";
    public static final String STATUS = "17";
    public static final int KEY_COUNT = 8;
    public static final String LINE = "line";
    public static final String DOWN = "down";
    public static final String UP = "up";
    public static final String ISDN = "isdn";
    public static final String T1 = "t1";
    public static final String E1 = "e1";
    public static final String FRACTIONAL = "fractional";
    public static final String INBAND = "inband";
    public static final String SIG_NONE = "none";
    public static final String SIG_TRUNK = "trunk";
    public static final String SIG_EM = "em";
    public static final String SIG_WINK = "wink";
    public static final String SIG_FXS = "fxs";
    public static final String SIG_LOOP = "loop";
    public static final String SIG_IMMEDIATE = "immediate";
    static String[] s_keys = null;
    String m_name;
    boolean m_reboot;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[8];
            int i = 0;
            LELine.s_keys[i++] = CONFIG;
            LELine.s_keys[i++] = ENCODING;
            LELine.s_keys[i++] = FRAMING;
            LELine.s_keys[i++] = GROUPS;
            LELine.s_keys[i++] = PCM;
            LELine.s_keys[i++] = LOOPBACK;
            LELine.s_keys[i++] = SIGNALING;
            LELine.s_keys[i++] = STATUS;
        }
        return s_keys;
    }

    public LELine(LEPortMaster pm, String name) {
        super(pm);
        this.m_name = name;
    }

    public Object clone() {
        LELine config = new LELine(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    public boolean requiresReboot(String key) {
        return key.equals(CONFIG);
    }

    LEConfig createConfig(String key) {
        if (key.equals(GROUPS)) {
            return new LEGroups(this.m_pm, this.m_name);
        }
        return new LEConfig(this.m_pm);
    }

    boolean getAllCommands(LEVector cmds) {
        boolean ret = super.getAllCommands(cmds);
        if (ret && this.m_reboot) {
            cmds.addElement("save all");
            cmds.addElement("reboot");
            this.m_reboot = false;
        }
        return ret;
    }

    boolean getChangedCommands(LEVector cmds) {
        boolean ret = super.getChangedCommands(cmds);
        if (ret && this.m_reboot) {
            cmds.addElement("save all");
            cmds.addElement("reboot");
            this.m_reboot = false;
        }
        return ret;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        String sig;
        StringBuffer buf;
        boolean allCmds = keys == null;
        int start = cmds.size();
        this.m_reboot = false;
        if (allCmds || keys.contains(CONFIG)) {
            this.m_reboot = this.makeSetCommand(cmds, this.m_name, CONFIG, null);
            String config = (String)this.get(CONFIG);
            if (config != null && config.equals(FRACTIONAL) && !this.checkForChannels()) {
                buf = new StringBuffer(28);
                buf.append("set ");
                buf.append(this.m_name);
                buf.append(" group 2 channels 1");
                cmds.addElement(buf.toString());
                LEGroups groups = (LEGroups)this.getConfig(GROUPS);
                LEGroup group = (LEGroup)groups.getConfig("2");
                group.setField("132", "1");
            }
        }
        if (allCmds || keys.contains(ENCODING)) {
            this.makeSetCommand(cmds, this.m_name, ENCODING, "encoding");
        }
        if (allCmds || keys.contains(FRAMING)) {
            this.makeSetCommand(cmds, this.m_name, FRAMING, "framing");
        }
        if (allCmds || keys.contains(LOOPBACK)) {
            this.makeSetCommand(cmds, this.m_name, LOOPBACK, "loopback");
        }
        if (allCmds || keys.contains(PCM)) {
            this.makeSetCommand(cmds, this.m_name, PCM, "pcm");
        }
        if ((allCmds || keys.contains(SIGNALING)) && (sig = (String)this.get(SIGNALING)) != null && !sig.equals(SIG_NONE)) {
            buf = new StringBuffer("set ");
            buf.append(this.m_name);
            buf.append(" signaling ");
            if (sig.indexOf(SIG_FXS) > -1) {
                buf.append(SIG_FXS);
            } else if (sig.indexOf(SIG_WINK) > -1) {
                buf.append(SIG_WINK);
            } else {
                buf.append(SIG_IMMEDIATE);
            }
            cmds.addElement(new String(buf));
        }
        return cmds.size() > start;
    }

    boolean checkForChannels() {
        LEGroups groups = (LEGroups)this.get(GROUPS);
        if (groups == null || groups.size() == 0) {
            return false;
        }
        boolean found = false;
        LEVector keys = groups.getKeys();
        int len = keys.size();
        int i = 0;
        while (!found && i < len) {
            String key = (String)keys.elementAt(i);
            LEGroup group = (LEGroup)groups.get(key);
            String channels = (String)group.get("132");
            if (channels != null && channels.length() > 0) {
                found = true;
            }
            ++i;
        }
        return found;
    }
}

