/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDialScript;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LELocation
extends LEConfig {
    public static final String ADDRESS = "IPAddress";
    public static final String ANALOG = "analog";
    public static final String ASYNC_MAP = "map";
    public static final String ASYNC_SCRIPT = "script";
    public static final String CHAP = "chap";
    public static final String COMPRESSION = "compression";
    public static final String DESTINATION = "destination";
    public static final String DOSBS = "voice";
    public static final String GROUP = "group";
    public static final String HIGH_WATER = "high_water";
    public static final String IDLE_TIMEOUT = "idle";
    public static final String INPUT_FILTER = "ifilter";
    public static final String IPX_NETWORK = "ipxnet";
    public static final String LOCAL_IP = "local-ip-address";
    public static final String MAX_PORTS = "maxports";
    public static final String MULTILINK = "multilink";
    public static final String MTU = "mtu";
    public static final String NETMASK = "netmask";
    public static final String OUTPUT_FILTER = "ofilter";
    public static final String PASSWORD = "password";
    public static final String PPP_IP_TYPE = "PPPIPType";
    public static final String PPP_IPX_TYPE = "PPPIPXType";
    public static final String PROTOCOL = "protocol";
    public static final String RIP_BROAD = "RIPBroadcast";
    public static final String RIP_LISTEN = "RIPListen";
    public static final String TELEPHONE = "phone";
    public static final String TYPE = "type";
    public static final String USERNAME = "username";
    public static final String V25BIS_SCRIPT = "v25bis";
    public static final int KEY_COUNT = 29;
    public static final String ASYNC_SCRIPT_TAG = "script";
    public static final String V25BIS_SCRIPT_TAG = "v25bis";
    public static final String LOCATION_TAG = "location";
    public static final String NEGOTIATED = "negotiated";
    public static final String SPECIFIED = "specified";
    public static final String CONTINUOUS = "continuous";
    public static final String MANUAL = "manual";
    public static final String ON_DEMAND = "on_demand";
    public static final String FRAME_RELAY = "frame-relay";
    public static final String PPP = "ppp";
    public static final String SLIP = "slip";
    public static final String STAC = "stac";
    public static final String VJ = "vj";
    public static final String MINUTES = "minutes";
    public static final String SECONDS = "seconds";
    static String[] s_keys = null;
    String m_name;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[29];
            int i = 0;
            LELocation.s_keys[i++] = ADDRESS;
            LELocation.s_keys[i++] = ANALOG;
            LELocation.s_keys[i++] = ASYNC_MAP;
            LELocation.s_keys[i++] = "script";
            LELocation.s_keys[i++] = CHAP;
            LELocation.s_keys[i++] = COMPRESSION;
            LELocation.s_keys[i++] = DESTINATION;
            LELocation.s_keys[i++] = DOSBS;
            LELocation.s_keys[i++] = GROUP;
            LELocation.s_keys[i++] = HIGH_WATER;
            LELocation.s_keys[i++] = IDLE_TIMEOUT;
            LELocation.s_keys[i++] = INPUT_FILTER;
            LELocation.s_keys[i++] = IPX_NETWORK;
            LELocation.s_keys[i++] = LOCAL_IP;
            LELocation.s_keys[i++] = MAX_PORTS;
            LELocation.s_keys[i++] = MULTILINK;
            LELocation.s_keys[i++] = MTU;
            LELocation.s_keys[i++] = NETMASK;
            LELocation.s_keys[i++] = OUTPUT_FILTER;
            LELocation.s_keys[i++] = PASSWORD;
            LELocation.s_keys[i++] = PPP_IP_TYPE;
            LELocation.s_keys[i++] = PPP_IPX_TYPE;
            LELocation.s_keys[i++] = PROTOCOL;
            LELocation.s_keys[i++] = RIP_BROAD;
            LELocation.s_keys[i++] = RIP_LISTEN;
            LELocation.s_keys[i++] = TELEPHONE;
            LELocation.s_keys[i++] = TYPE;
            LELocation.s_keys[i++] = USERNAME;
            LELocation.s_keys[i++] = "v25bis";
        }
        return s_keys;
    }

    public LELocation(LEPortMaster pm, String name) {
        super(pm);
        this.m_name = name;
        this.m_tag = "location " + this.m_name;
    }

    public Object clone() {
        LELocation config = new LELocation(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    LEConfig createConfig(String key) {
        if (key.equals("script")) {
            return new LEDialScript(this.m_pm, String.valueOf(this.m_tag) + " " + "script");
        }
        if (key.equals("v25bis")) {
            return new LEDialScript(this.m_pm, String.valueOf(this.m_tag) + " " + "v25bis");
        }
        return new LEConfig(this.m_pm);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(ADDRESS) || keys.contains(DESTINATION)) {
            String dest = (String)this.get(DESTINATION);
            if (dest != null && dest.equals(NEGOTIATED)) {
                StringBuffer buf = new StringBuffer("set ");
                buf.append(this.m_tag);
                buf.append(" destination ");
                buf.append("255.255.255.255");
                cmds.addElement(buf.toString());
            } else if (dest != null) {
                this.makeSetCommand(cmds, this.m_tag, ADDRESS, DESTINATION);
            }
        }
        if (allCmds || keys.contains(ANALOG)) {
            this.makeSetCommand(cmds, this.m_tag, ANALOG, ANALOG);
        }
        if (allCmds || keys.contains(ASYNC_MAP)) {
            this.makeSetCommand(cmds, this.m_tag, ASYNC_MAP, ASYNC_MAP);
        }
        if (allCmds || keys.contains(CHAP)) {
            this.makeSetCommand(cmds, this.m_tag, CHAP, CHAP);
        }
        if (allCmds || keys.contains(COMPRESSION)) {
            this.makeSetCommand(cmds, this.m_tag, COMPRESSION, COMPRESSION);
        }
        if (allCmds || keys.contains(DOSBS)) {
            this.makeSetCommand(cmds, this.m_tag, DOSBS, DOSBS);
        }
        if (allCmds || keys.contains(GROUP)) {
            this.makeSetCommand(cmds, this.m_tag, GROUP, GROUP);
        }
        if (allCmds || keys.contains(HIGH_WATER)) {
            this.makeSetCommand(cmds, this.m_tag, HIGH_WATER, HIGH_WATER);
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_tag, IDLE_TIMEOUT, IDLE_TIMEOUT);
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, INPUT_FILTER, INPUT_FILTER);
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_tag, IPX_NETWORK, IPX_NETWORK);
        }
        if (allCmds || keys.contains(LOCAL_IP)) {
            this.makeSetCommand(cmds, this.m_tag, LOCAL_IP, LOCAL_IP);
        }
        if (allCmds || keys.contains(MAX_PORTS)) {
            this.makeSetCommand(cmds, this.m_tag, MAX_PORTS, MAX_PORTS);
        }
        if (allCmds || keys.contains(MULTILINK)) {
            this.makeSetCommand(cmds, this.m_tag, MULTILINK, MULTILINK);
        }
        if (allCmds || keys.contains(MTU)) {
            this.makeSetCommand(cmds, this.m_tag, MTU, MTU);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_tag, NETMASK, NETMASK);
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, OUTPUT_FILTER, OUTPUT_FILTER);
        }
        if (allCmds || keys.contains(PASSWORD)) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
        }
        if (allCmds || keys.contains(PROTOCOL)) {
            this.makeSetCommand(cmds, this.m_tag, PROTOCOL, PROTOCOL);
        }
        if (allCmds || keys.contains(TELEPHONE)) {
            this.makeSetCommand(cmds, this.m_tag, TELEPHONE, "telephone");
        }
        if (allCmds || keys.contains(USERNAME)) {
            this.makeSetCommand(cmds, this.m_tag, USERNAME, USERNAME);
        }
        if (allCmds || keys.contains(TYPE)) {
            this.makeSetCommand(cmds, this.m_tag, TYPE, null);
        }
        if (allCmds || keys.contains(RIP_BROAD) || keys.contains(RIP_LISTEN)) {
            this.makeRIPCommand(cmds, this.m_tag, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        return cmds.size() > start;
    }
}

