/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LELocation;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LELocations
extends LETable {
    public LELocations(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LELocations config = new LELocations(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String name) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("location", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                errors = new LEVector();
                errors.addElement(ret);
            }
            this.refresh();
        } else {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String name) {
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("location", name);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            this.remove(name);
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    LEConfig createConfig(String key) {
        return new LELocation(this.m_pm, key);
    }

    boolean getChildCommands(LEConfig child, LEVector cmds) {
        LELocation loc = (LELocation)child;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("location ");
        buf.append(loc.getName());
        cmds.addElement(new String(buf));
        child.getAllCommands(cmds);
        return true;
    }
}

