/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LENetUser
extends LEConfig {
    public static final String ADDRESS = "IPAddress";
    public static final String ASYNC_MAP = "map";
    public static final String COMPRESSION = "compression";
    public static final String DESTINATION = "destination";
    public static final String IDLE_TIMEOUT = "idle";
    public static final String INPUT_FILTER = "ifilter";
    public static final String IPX_NETWORK = "ipxnet";
    public static final String LOCAL_IP = "local-ip-address";
    public static final String MAX_PORTS = "maxports";
    public static final String MTU = "mtu";
    public static final String NETMASK = "netmask";
    public static final String OUTPUT_FILTER = "ofilter";
    public static final String PASSWORD = "password";
    public static final String PROTOCOL = "protocol";
    public static final String RIP_BROAD = "RIPBroadcast";
    public static final String RIP_LISTEN = "RIPListen";
    public static final String SESSION_LIMIT = "session";
    public static final int KEY_COUNT = 17;
    public static final String USER = "user";
    public static final String ASSIGNED = "assigned";
    public static final String NEGOTIATED = "negotiated";
    public static final String SPECIFIED = "specified";
    public static final String PPP = "ppp";
    public static final String SLIP = "slip";
    public static final String MINUTES = "minutes";
    public static final String SECONDS = "seconds";
    static String[] s_keys = null;
    String m_name;
    String m_tag;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[17];
            int i = 0;
            LENetUser.s_keys[i++] = ADDRESS;
            LENetUser.s_keys[i++] = ASYNC_MAP;
            LENetUser.s_keys[i++] = COMPRESSION;
            LENetUser.s_keys[i++] = DESTINATION;
            LENetUser.s_keys[i++] = IDLE_TIMEOUT;
            LENetUser.s_keys[i++] = INPUT_FILTER;
            LENetUser.s_keys[i++] = IPX_NETWORK;
            LENetUser.s_keys[i++] = LOCAL_IP;
            LENetUser.s_keys[i++] = MAX_PORTS;
            LENetUser.s_keys[i++] = MTU;
            LENetUser.s_keys[i++] = NETMASK;
            LENetUser.s_keys[i++] = OUTPUT_FILTER;
            LENetUser.s_keys[i++] = PASSWORD;
            LENetUser.s_keys[i++] = PROTOCOL;
            LENetUser.s_keys[i++] = RIP_BROAD;
            LENetUser.s_keys[i++] = RIP_LISTEN;
            LENetUser.s_keys[i++] = SESSION_LIMIT;
        }
        return s_keys;
    }

    public LENetUser(LEPortMaster pm, String name) {
        super(pm);
        this.m_name = name;
        this.m_tag = "user " + this.m_name;
    }

    public Object clone() {
        LENetUser config = new LENetUser(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    public String getName() {
        return this.m_name;
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(ADDRESS) || keys.contains(DESTINATION)) {
            String dest = (String)this.get(DESTINATION);
            if (dest != null && dest.equals(SPECIFIED)) {
                this.makeSetCommand(cmds, this.m_tag, ADDRESS, DESTINATION);
            } else {
                this.makeSetCommand(cmds, this.m_tag, DESTINATION, DESTINATION);
            }
        }
        if (allCmds || keys.contains(ASYNC_MAP)) {
            this.makeSetCommand(cmds, this.m_tag, ASYNC_MAP, ASYNC_MAP);
        }
        if (allCmds || keys.contains(COMPRESSION)) {
            this.makeSetCommand(cmds, this.m_tag, COMPRESSION, COMPRESSION);
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_tag, IDLE_TIMEOUT, IDLE_TIMEOUT);
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, INPUT_FILTER, INPUT_FILTER);
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_tag, IPX_NETWORK, IPX_NETWORK);
        }
        if (allCmds || keys.contains(LOCAL_IP)) {
            this.makeSetCommand(cmds, this.m_tag, LOCAL_IP, LOCAL_IP);
        }
        if (allCmds || keys.contains(MAX_PORTS)) {
            this.makeSetCommand(cmds, this.m_tag, MAX_PORTS, MAX_PORTS);
        }
        if (allCmds || keys.contains(MTU)) {
            this.makeSetCommand(cmds, this.m_tag, MTU, MTU);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_tag, NETMASK, NETMASK);
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_tag, OUTPUT_FILTER, OUTPUT_FILTER);
        }
        if (!allCmds && keys.contains(PASSWORD)) {
            this.makeSetCommand(cmds, this.m_tag, PASSWORD, PASSWORD);
        }
        if (allCmds || keys.contains(PROTOCOL)) {
            this.makeSetCommand(cmds, this.m_tag, PROTOCOL, PROTOCOL);
        }
        if (allCmds || keys.contains(SESSION_LIMIT)) {
            this.makeSetCommand(cmds, this.m_tag, SESSION_LIMIT, "session-limit");
        }
        if (allCmds || keys.contains(RIP_BROAD) || keys.contains(RIP_LISTEN)) {
            this.makeRIPCommand(cmds, this.m_tag, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        return cmds.size() > start;
    }
}

