/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfigFacility;
import COM.livingston.model.LEPMEntityParser;
import COM.livingston.model.LEPMOldParser;
import COM.livingston.model.LEPortMaster;

public class LEPMConfigFacility
implements LEConfigFacility {
    LEPortMaster m_pm;

    public LEPMConfigFacility(LEPortMaster pm) {
        this.m_pm = pm;
    }

    public boolean getConfig(String key) {
        LEDSSPortMaster dss = this.m_pm.getDSS();
        if (dss == null) {
            return false;
        }
        if (dss.supportsEntities() && LEPMEntityParser.Parse(key, dss, this.m_pm)) {
            return true;
        }
        return LEPMOldParser.Parse(key, dss, this.m_pm);
    }

    public boolean getTable(String key) {
        return this.getConfig(key);
    }

    public boolean getTOC(String key) {
        return true;
    }

    public boolean getTableEntry(String tableKey, String entryKey) {
        return true;
    }

    public LEPMCommand execute(String command) {
        LEDSSPortMaster dss = this.m_pm.getDSS();
        if (dss == null) {
            return null;
        }
        return dss.execute(command);
    }
}

