/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEDSSException;
import COM.livingston.backend.LEDSSPortMaster;
import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEAsyncPort;
import COM.livingston.model.LEChoicenet;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDataSpecFactory;
import COM.livingston.model.LEDebugFacility;
import COM.livingston.model.LEEthernets;
import COM.livingston.model.LEFilters;
import COM.livingston.model.LEGlobal;
import COM.livingston.model.LEHosts;
import COM.livingston.model.LEISDNPort;
import COM.livingston.model.LELines;
import COM.livingston.model.LELocations;
import COM.livingston.model.LEModems;
import COM.livingston.model.LEOSPF;
import COM.livingston.model.LEOSPFAreas;
import COM.livingston.model.LEPMConfigFacility;
import COM.livingston.model.LEPort;
import COM.livingston.model.LEPorts;
import COM.livingston.model.LERadius;
import COM.livingston.model.LERoutes;
import COM.livingston.model.LESNMP;
import COM.livingston.model.LESubInterfaces;
import COM.livingston.model.LESyncPort;
import COM.livingston.model.LESyslog;
import COM.livingston.model.LEUsers;
import COM.livingston.util.LEDebug;
import COM.livingston.util.LEStatusManager;
import COM.livingston.util.LEThreadStatus;
import COM.livingston.util.LEVector;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class LEPortMaster
extends LEConfig {
    public static final String CHOICENET = "choicenet";
    public static final String ETHERNETS = "ethernet";
    public static final String FILTERS = "filter";
    public static final String GLOBAL = "global";
    public static final String HOSTS = "1245184";
    public static final String LINES = "131072";
    public static final String LOCATIONS = "location";
    public static final String MODEMS = "196608";
    public static final String OSPF = "1048576";
    public static final String OSPF_AREAS = "524288";
    public static final String PORTS = "port";
    public static final String RADIUS = "radius";
    public static final String ROUTES = "1310720";
    public static final String SNMP = "1376256";
    public static final String SUB_IS = "2490368";
    public static final String SYSLOG = "327680";
    public static final String USERS = "user";
    public static final int KEY_COUNT = 17;
    public static final String DEFAULT_USER = "!root";
    public static final String MOD_IRX_111 = "IRX-111";
    public static final String MOD_IRX_112 = "IRX-112";
    public static final String MOD_IRX_114 = "IRX-114";
    public static final String MOD_IRX_211 = "IRX-211";
    public static final String MOD_OR = "OR";
    public static final String MOD_OR_AP = "OR-AP";
    public static final String MOD_OR_HS = "OR-HS";
    public static final String MOD_OR_LS = "OR-LS";
    public static final String MOD_OR_M = "OR-M";
    public static final String MOD_OR_ST = "OR-ST";
    public static final String MOD_OR_U = "OR-U";
    public static final String MOD_PM2 = "PM-2";
    public static final String MOD_PM25 = "PM-25";
    public static final String MOD_PM2E = "PM-2e";
    public static final String MOD_PM2EI = "PM-2ei";
    public static final String MOD_PM2ER = "PM-2er";
    public static final String MOD_PM2I = "PM-2i";
    public static final String MOD_PM2R = "PM-2r";
    public static final String MOD_PM3 = "PM-3";
    public static final String MOD_UNKNOWN = "";
    static final String SET_PASSWORD = "set pas";
    static final String PM3 = "6.";
    static final String IRX = "4.";
    static final String OR = "5.";
    static final String PM25 = "2.5";
    static final String PM2 = "2.2";
    static String[] s_keys = null;
    String m_host;
    String m_user;
    String m_password;
    LEDSSPortMaster m_dss;
    LEPMConfigFacility m_facility;
    LEDebugFacility m_debug;
    Vector m_retrieved = new Vector();
    String m_software = "";
    String m_hardware;
    String m_uptime = "";

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[17];
            LEPortMaster.s_keys[0] = CHOICENET;
            LEPortMaster.s_keys[1] = ETHERNETS;
            LEPortMaster.s_keys[2] = FILTERS;
            LEPortMaster.s_keys[3] = GLOBAL;
            LEPortMaster.s_keys[4] = HOSTS;
            LEPortMaster.s_keys[5] = LINES;
            LEPortMaster.s_keys[6] = LOCATIONS;
            LEPortMaster.s_keys[7] = MODEMS;
            LEPortMaster.s_keys[8] = OSPF;
            LEPortMaster.s_keys[9] = OSPF_AREAS;
            LEPortMaster.s_keys[10] = PORTS;
            LEPortMaster.s_keys[11] = RADIUS;
            LEPortMaster.s_keys[12] = ROUTES;
            LEPortMaster.s_keys[13] = SNMP;
            LEPortMaster.s_keys[14] = USERS;
            LEPortMaster.s_keys[15] = SUB_IS;
            LEPortMaster.s_keys[16] = SYSLOG;
        }
        return s_keys;
    }

    public LEPortMaster(String host, String user, String password) throws LEDSSException, IOException {
        super(null);
        this.m_host = host;
        this.m_user = user;
        this.m_password = password;
        this.m_facility = new LEPMConfigFacility(this);
        this.m_dss = user.equals(DEFAULT_USER) ? new LEDSSPortMaster(host, password) : new LEDSSPortMaster(host, user, password);
        if (this.m_dss.supportsEntities()) {
            this.m_debug = new LEDebugFacility(this.m_dss);
        }
        try {
            this.setSpec(LEDataSpecFactory.GetPortMasterSpec());
        }
        catch (IOException e) {
            LEDebug.getLog().logln(20, e);
        }
        this.ping();
    }

    public boolean isConnected() {
        if (this.m_dss == null) {
            return false;
        }
        return this.m_dss.isConnected();
    }

    public void disconnect() {
        if (this.m_dss != null) {
            this.m_dss.disconnect();
        }
    }

    public boolean reconnect() {
        if (this.m_dss == null) {
            return false;
        }
        if (this.isConnected()) {
            return true;
        }
        boolean success = this.m_dss.reconnect();
        if (success) {
            this.purgeCache();
        }
        return success;
    }

    public void reboot() {
        if (this.m_dss != null) {
            this.execute("reboot");
        }
    }

    public String getHostname() {
        return this.m_host;
    }

    public String getUpTime() {
        return this.m_uptime;
    }

    public String getSoftwareVersion() {
        return this.m_software;
    }

    public String getHardwareType() {
        return this.m_hardware;
    }

    public LEDebugFacility getDebugFacility() {
        return this.m_debug;
    }

    public LEDSSPortMaster getDSS() {
        return this.m_dss;
    }

    public Object get(String key) {
        Object field = this.m_fields.get(key);
        if (field == null && !this.m_retrieved.contains(key) && this.load(key)) {
            this.m_retrieved.addElement(key);
            field = this.m_fields.get(key);
        }
        return field;
    }

    public Object fetch(String key) {
        if (this.m_fields.containsKey(key)) {
            this.load(key);
        }
        return this.get(key);
    }

    public LEPMCommand execute(String command) {
        String cmd;
        if (this.m_facility == null || !this.isConnected()) {
            LEPMCommand cmd2 = new LEPMCommand(command);
            cmd2.setResult("No connection");
            cmd2.setStatus(false);
            return cmd2;
        }
        LEStatusManager.SetStatus(command);
        LEPMCommand ret = this.m_facility.execute(command);
        if (LEPMCommand.IsReboot(command)) {
            this.purgeCache();
        } else if (command.length() > 6 && (cmd = command.substring(0, 7)).equalsIgnoreCase(SET_PASSWORD)) {
            StringTokenizer tz = new StringTokenizer(command);
            String tok = tz.nextToken();
            tok = tz.nextToken();
            this.m_password = tz.nextToken();
            this.m_dss.setPassword(this.m_password);
        }
        LEStatusManager.SetStatus(LEThreadStatus.NO_MESSAGE);
        return ret;
    }

    public boolean ping() {
        if (this.m_dss == null) {
            return false;
        }
        boolean ping = false;
        if (this.m_dss.supportsEntities()) {
            LEPMCommand cmd = this.execute("version");
            if (cmd.getStatus()) {
                ping = true;
                this.parseVersion(cmd.getResult());
            }
        } else if (this.load(GLOBAL)) {
            ping = true;
        }
        return ping;
    }

    public void purgeCache() {
        this.m_fields.clear();
        this.m_retrieved.removeAllElements();
        this.get(GLOBAL);
        this.m_debug = this.m_dss.supportsEntities() ? new LEDebugFacility(this.m_dss) : null;
    }

    public boolean getCommands(LEVector cmds) {
        String[] keys = LEPortMaster.GetAllPossibleKeys();
        int i = 0;
        while (i < keys.length) {
            this.get(keys[i]);
            ++i;
        }
        return super.getCommands(cmds);
    }

    void refresh(LEConfig config) {
        String refreshKey = null;
        Enumeration keys = this.m_fields.keys();
        while (refreshKey == null && keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (config != this.m_fields.get(key)) continue;
            refreshKey = key;
        }
        if (refreshKey != null) {
            this.fetch(refreshKey);
        }
    }

    void parseVersion(String result) {
        if (result == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(result);
        boolean foundUptime = false;
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (foundUptime) {
                buf.append(' ');
                buf.append(token);
                continue;
            }
            if (token.equals("is")) {
                foundUptime = true;
                buf.append(tokenizer.nextToken());
                continue;
            }
            if (token.equals("PortMaster")) {
                token = tokenizer.nextToken();
                if (this.m_hardware != null) continue;
                if (token.equals(MOD_PM3) || token.equals(MOD_PM25)) {
                    this.m_hardware = token;
                    continue;
                }
                this.m_hardware = this.determineModel();
                continue;
            }
            if (!token.equals("ComOS")) continue;
            this.m_software = tokenizer.nextToken();
        }
        this.m_uptime = new String(buf);
        int len = this.m_uptime.length();
        if (len > 0) {
            this.m_uptime = this.m_uptime.substring(0, len - 1);
        }
    }

    void formatUpTime(int time) {
        int days = time / 1440;
        int hours = time % 1440 / 60;
        int minutes = time % 60;
        StringBuffer buf = new StringBuffer();
        if (days > 0) {
            buf.append(days);
            buf.append(" day");
            if (days > 1) {
                buf.append('s');
            }
            buf.append(' ');
        }
        if (hours > 0) {
            buf.append(hours);
            buf.append(" hour");
            if (hours > 1) {
                buf.append('s');
            }
            buf.append(' ');
        }
        buf.append(minutes);
        buf.append(" minute");
        if (minutes > 1) {
            buf.append('s');
        }
        this.m_uptime = new String(buf);
    }

    boolean load(String key) {
        LEStatusManager.SetStatus("Getting " + this.getDescriptionFor(key) + " from " + this.m_host);
        boolean success = this.m_facility.getConfig(key);
        if (success && key.equals(GLOBAL)) {
            LEGlobal global = (LEGlobal)this.get(GLOBAL);
            String tmp = (String)global.get("swversion");
            if (tmp != null && tmp.length() > 0) {
                this.m_software = tmp;
            }
            if (this.m_hardware == null) {
                this.m_hardware = this.determineModel();
            }
            tmp = (String)global.get("uptime");
            try {
                int time = Integer.parseInt(tmp);
                this.formatUpTime(time);
            }
            catch (Exception e) {
                LEDebug.getLog().logln(20, e);
            }
        }
        LEStatusManager.StatusComplete();
        return success;
    }

    String determineModel() {
        LEGlobal global = (LEGlobal)this.get(GLOBAL);
        if (global == null) {
            return MOD_UNKNOWN;
        }
        String hardware = (String)global.get("hwversion");
        if (hardware == null || hardware.length() == 0) {
            return MOD_UNKNOWN;
        }
        if (hardware.startsWith(PM3)) {
            return MOD_PM3;
        }
        if (hardware.startsWith(PM25)) {
            return MOD_PM25;
        }
        LEPorts ports = (LEPorts)this.get(PORTS);
        if (ports == null) {
            return MOD_UNKNOWN;
        }
        if (hardware.startsWith(IRX)) {
            LEPort port = ports.getPort("S4");
            if (port != null) {
                return MOD_IRX_114;
            }
            port = ports.getPort("S2");
            if (port != null) {
                return MOD_IRX_112;
            }
            LEEthernets ethers = (LEEthernets)this.get(ETHERNETS);
            if (ethers != null && ethers.get("ether1") != null) {
                return MOD_IRX_211;
            }
            return MOD_IRX_111;
        }
        if (hardware.startsWith(OR)) {
            LEPort port = ports.getPort("S1");
            if (port != null) {
                if (port instanceof LEAsyncPort) {
                    return MOD_OR_M;
                }
                if (port instanceof LEISDNPort) {
                    String comver = (String)global.get("swversion");
                    if (comver.indexOf("AP") != -1) {
                        return MOD_OR_AP;
                    }
                    return MOD_OR_U;
                }
            }
            if ((port = ports.getPort("W1")) instanceof LESyncPort) {
                return MOD_OR_HS;
            }
            return MOD_OR;
        }
        if (hardware.startsWith(PM2)) {
            boolean isE = false;
            LEPort port = ports.getPort("S10");
            if (port != null) {
                isE = true;
            } else {
                port = ports.getPort("S20");
                if (port != null) {
                    isE = true;
                }
            }
            port = ports.getPort("P0");
            if (port != null) {
                if (isE) {
                    return MOD_PM2E;
                }
                return MOD_PM2;
            }
            port = ports.getPort("W1");
            if (port != null) {
                if (isE) {
                    return MOD_PM2ER;
                }
                return MOD_PM2R;
            }
            port = ports.getPort("C0");
            if (port != null) {
                if (isE) {
                    return MOD_PM2EI;
                }
                return MOD_PM2I;
            }
            return MOD_PM2;
        }
        return MOD_UNKNOWN;
    }

    LEConfig createConfig(String key) {
        LEConfig config = key.equals(GLOBAL) ? new LEGlobal(this) : (key.equals(RADIUS) ? new LERadius(this) : (key.equals(CHOICENET) ? new LEChoicenet(this) : (key.equals(FILTERS) ? new LEFilters(this) : (key.equals(PORTS) ? new LEPorts(this) : (key.equals(USERS) ? new LEUsers(this) : (key.equals(LOCATIONS) ? new LELocations(this) : (key.equals(ETHERNETS) ? new LEEthernets(this) : (key.equals(SYSLOG) ? new LESyslog(this) : (key.equals(SNMP) ? new LESNMP(this) : (key.equals(OSPF) ? new LEOSPF(this) : (key.equals(OSPF_AREAS) ? new LEOSPFAreas(this) : (key.equals(ROUTES) ? new LERoutes(this) : (key.equals(HOSTS) ? new LEHosts(this) : (key.equals(MODEMS) ? new LEModems(this) : (key.equals(LINES) ? new LELines(this) : (key.equals(SUB_IS) ? new LESubInterfaces(this) : new LEConfig(this)))))))))))))))));
        return config;
    }
}

