/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEAsyncPorts;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEISDNPorts;
import COM.livingston.model.LEParallelPorts;
import COM.livingston.model.LEPort;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LESyncPorts;

public class LEPorts
extends LEConfig {
    public static final String ASYNC_PORTS = "AsyncPort";
    public static final String SYNC_PORTS = "SyncPort";
    public static final String ISDN_PORTS = "ISDNPort";
    public static final String PARALLEL_PORTS = "ParallelPort";
    public static final int KEY_COUNT = 4;
    public static final String PPP = "ppp";
    public static final String FRAME_RELAY = "frame";
    public static final String SLIP = "slip";
    public static final String VJ = "vj";
    public static final String STAC = "stac";
    public static final String SECONDS = "seconds";
    public static final String MINUTES = "minutes";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[4];
            LEPorts.s_keys[0] = ASYNC_PORTS;
            LEPorts.s_keys[1] = SYNC_PORTS;
            LEPorts.s_keys[2] = ISDN_PORTS;
            LEPorts.s_keys[3] = PARALLEL_PORTS;
        }
        return s_keys;
    }

    public LEPorts(LEPortMaster pm) {
        super(pm);
    }

    public LEPort getPort(String id) {
        LEParallelPorts pports;
        LEISDNPorts iports;
        LESyncPorts sports;
        LEPort port = null;
        LEAsyncPorts aports = (LEAsyncPorts)this.get(ASYNC_PORTS);
        if (aports != null) {
            port = (LEPort)aports.get(id);
        }
        if (port == null && (sports = (LESyncPorts)this.get(SYNC_PORTS)) != null) {
            port = (LEPort)sports.get(id);
        }
        if (port == null && (iports = (LEISDNPorts)this.get(ISDN_PORTS)) != null) {
            port = (LEPort)iports.get(id);
        }
        if (port == null && (pports = (LEParallelPorts)this.get(PARALLEL_PORTS)) != null) {
            port = (LEPort)pports.get(id);
        }
        return port;
    }

    public Object clone() {
        LEPorts ports = new LEPorts(this.m_pm);
        this.copyTo(ports);
        return ports;
    }

    LEConfig createConfig(String key) {
        LEConfig config = key.equals(ASYNC_PORTS) ? new LEAsyncPorts(this.m_pm) : (key.equals(SYNC_PORTS) ? new LESyncPorts(this.m_pm) : (key.equals(ISDN_PORTS) ? new LEISDNPorts(this.m_pm) : (key.equals(PARALLEL_PORTS) ? new LEParallelPorts(this.m_pm) : new LEConfig(this.m_pm))));
        return config;
    }
}

