/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LESNMPHosts;
import COM.livingston.util.LEVector;

public class LESNMP
extends LEConfig {
    public static final String READ_COMMUNITY = "read";
    public static final String READ_HOSTS = "readhost";
    public static final String READ_TYPE = "readtype";
    public static final String SYSNAME = "sysname";
    public static final String WRITE_COMMUNITY = "write";
    public static final String WRITE_HOSTS = "writehost";
    public static final String WRITE_TYPE = "writetype";
    public static final int KEY_COUNT = 7;
    public static final String READER_TAG = "reader";
    public static final String SNMP_TAG = "snmp";
    public static final String SNMPHOST_TAG = "snmphost";
    public static final String WRITER_TAG = "writer";
    public static final String ANY = "any";
    public static final String NONE = "none";
    public static final String SPECIFIED = "specified";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[7];
            int i = 0;
            LESNMP.s_keys[i++] = READ_COMMUNITY;
            LESNMP.s_keys[i++] = READ_HOSTS;
            LESNMP.s_keys[i++] = READ_TYPE;
            LESNMP.s_keys[i++] = SYSNAME;
            LESNMP.s_keys[i++] = WRITE_COMMUNITY;
            LESNMP.s_keys[i++] = WRITE_HOSTS;
            LESNMP.s_keys[i++] = WRITE_TYPE;
        }
        return s_keys;
    }

    public LESNMP(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LESNMP config = new LESNMP(this.m_pm);
        this.copyTo(config);
        return config;
    }

    LEConfig createConfig(String key) {
        if (key.equals(READ_HOSTS)) {
            return new LESNMPHosts(this.m_pm, READER_TAG);
        }
        if (key.equals(WRITE_HOSTS)) {
            return new LESNMPHosts(this.m_pm, WRITER_TAG);
        }
        return new LEConfig(this.m_pm);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(SYSNAME)) {
            this.makeSetCommand(cmds, null, SYSNAME, SYSNAME);
        }
        if (allCmds || keys.contains(READ_COMMUNITY)) {
            this.makeSetCommand(cmds, SNMP_TAG, READ_COMMUNITY, "readcommunity");
        }
        if (allCmds || keys.contains(WRITE_COMMUNITY)) {
            this.makeSetCommand(cmds, SNMP_TAG, WRITE_COMMUNITY, "writecommunity");
        }
        if (allCmds || keys.contains(READ_TYPE)) {
            this.setSNMPHostType(READ_HOSTS, READ_TYPE);
        }
        if (allCmds || keys.contains(WRITE_TYPE)) {
            this.setSNMPHostType(WRITE_HOSTS, WRITE_TYPE);
        }
        return cmds.size() > start;
    }

    void setSNMPHostType(String host, String type) {
        Object obj = this.get(host);
        if (obj instanceof LESNMPHosts) {
            LESNMPHosts hosts = (LESNMPHosts)obj;
            String val = (String)this.get(type);
            if (val != null) {
                if (val.equals(ANY)) {
                    hosts.setType(0);
                } else if (val.equals(NONE)) {
                    hosts.setType(1);
                } else {
                    hosts.setType(2);
                }
            }
        }
    }
}

