/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.backend.LEPMCommand;
import COM.livingston.model.LEConfig;
import COM.livingston.model.LEPortMaster;
import COM.livingston.model.LESubInterface;
import COM.livingston.model.LETable;
import COM.livingston.util.LEVector;

public class LESubInterfaces
extends LETable {
    public LESubInterfaces(LEPortMaster pm) {
        super(pm);
    }

    public Object clone() {
        LESubInterfaces config = new LESubInterfaces(this.m_pm);
        this.copyTo(config);
        return config;
    }

    public LEVector add(String subname) {
        LEVector errors = null;
        String cmd = this.makeAddCommand("subinterface", subname);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            ret = this.m_pm.execute("save all");
            this.refresh();
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    public LEVector delete(String subname) {
        LESubInterface sub = (LESubInterface)this.get(subname);
        if (sub == null) {
            return null;
        }
        LEVector errors = null;
        String cmd = this.makeDeleteCommand("subinterface", subname);
        LEPMCommand ret = this.m_pm.execute(cmd);
        if (ret.getStatus()) {
            this.m_fields.remove(subname);
            ret = this.m_pm.execute("save all");
            if (!ret.getStatus()) {
                this.refresh();
            }
        }
        if (!ret.getStatus()) {
            errors = new LEVector();
            errors.addElement(ret);
        }
        return errors;
    }

    boolean getChildCommands(LEConfig child, LEVector cmds) {
        LESubInterface subi = (LESubInterface)child;
        StringBuffer buf = new StringBuffer("add ");
        buf.append("subinterface ");
        buf.append(subi.getName());
        cmds.addElement(new String(buf));
        child.getAllCommands(cmds);
        return true;
    }

    LEConfig createConfig(String key) {
        return new LESubInterface(this.m_pm, key);
    }
}

