/*
 * Decompiled with CFR 0.152.
 */
package COM.livingston.model;

import COM.livingston.model.LEConfig;
import COM.livingston.model.LEDLCIList;
import COM.livingston.model.LEPort;
import COM.livingston.model.LEPortMaster;
import COM.livingston.util.LEVector;

public class LESyncPort
extends LEPort {
    public static final String COMPRESSION = "compression";
    public static final String DESTINATION = "destination";
    public static final String DLCI_LIST = "dlci";
    public static final String GROUP = "group";
    public static final String HANGUP = "hangup";
    public static final String HARDWARE_TYPE = "PortHardwareType";
    public static final String IDLE_TIMEOUT = "idle";
    public static final String INPUT_FILTER = "ifilter";
    public static final String IPX_NETWORK = "ipxnet";
    public static final String LMI_TYPE = "LMIType";
    public static final String LMI_TIMER = "LMITimer";
    public static final String LOCAL_IP = "address";
    public static final String MODEM_CONTROL = "cd";
    public static final String MTU = "mtu";
    public static final String NETMASK = "netmask";
    public static final String NETWORK_TYPE = "NetworkType";
    public static final String OUTPUT_FILTER = "ofilter";
    public static final String OSPF = "ospf";
    public static final String PORT_TYPE = "PortType";
    public static final String PROTOCOL = "protocol";
    public static final String RIP_BROAD = "RIPBroadcast";
    public static final String RIP_LISTEN = "RIPListen";
    public static final String SPEED = "speed";
    public static final int KEY_COUNT = 23;
    public static final String LMI = "lmi";
    public static final String ANNEXD = "annex-d";
    public static final String NONE = "none";
    public static final String PPP = "ppp";
    public static final String FRAME = "frame";
    static String[] s_keys = null;

    public static String[] GetAllPossibleKeys() {
        if (s_keys == null) {
            s_keys = new String[23];
            int i = 0;
            LESyncPort.s_keys[i++] = COMPRESSION;
            LESyncPort.s_keys[i++] = DESTINATION;
            LESyncPort.s_keys[i++] = DLCI_LIST;
            LESyncPort.s_keys[i++] = GROUP;
            LESyncPort.s_keys[i++] = HANGUP;
            LESyncPort.s_keys[i++] = HARDWARE_TYPE;
            LESyncPort.s_keys[i++] = IDLE_TIMEOUT;
            LESyncPort.s_keys[i++] = INPUT_FILTER;
            LESyncPort.s_keys[i++] = IPX_NETWORK;
            LESyncPort.s_keys[i++] = LMI_TYPE;
            LESyncPort.s_keys[i++] = LMI_TIMER;
            LESyncPort.s_keys[i++] = LOCAL_IP;
            LESyncPort.s_keys[i++] = MODEM_CONTROL;
            LESyncPort.s_keys[i++] = MTU;
            LESyncPort.s_keys[i++] = NETMASK;
            LESyncPort.s_keys[i++] = NETWORK_TYPE;
            LESyncPort.s_keys[i++] = OUTPUT_FILTER;
            LESyncPort.s_keys[i++] = OSPF;
            LESyncPort.s_keys[i++] = PROTOCOL;
            LESyncPort.s_keys[i++] = RIP_BROAD;
            LESyncPort.s_keys[i++] = RIP_LISTEN;
            LESyncPort.s_keys[i++] = SPEED;
        }
        return s_keys;
    }

    public LESyncPort(LEPortMaster pm, String name) {
        super(pm, name);
    }

    public Object clone() {
        LESyncPort config = new LESyncPort(this.m_pm, this.m_name);
        this.copyTo(config);
        return config;
    }

    LEConfig createConfig(String key) {
        return new LEDLCIList(this.m_pm, this.m_name);
    }

    boolean generateCommands(LEVector keys, LEVector cmds) {
        boolean allCmds = keys == null;
        int start = cmds.size();
        if (allCmds || keys.contains(COMPRESSION)) {
            this.makeSetCommand(cmds, this.m_name, COMPRESSION, COMPRESSION);
        }
        if (allCmds || keys.contains(DESTINATION)) {
            this.makeSetCommand(cmds, this.m_name, DESTINATION, DESTINATION);
        }
        if (allCmds || keys.contains(GROUP)) {
            this.makeSetCommand(cmds, this.m_name, GROUP, GROUP);
        }
        if (allCmds || keys.contains(HANGUP)) {
            this.makeSetCommand(cmds, this.m_name, HANGUP, HANGUP);
        }
        if (allCmds || keys.contains(IDLE_TIMEOUT)) {
            this.makeSetCommand(cmds, this.m_name, IDLE_TIMEOUT, "idletime");
        }
        if (allCmds || keys.contains(INPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, INPUT_FILTER, INPUT_FILTER);
        }
        if (allCmds || keys.contains(IPX_NETWORK)) {
            this.makeSetCommand(cmds, this.m_name, IPX_NETWORK, IPX_NETWORK);
        }
        if (allCmds || keys.contains(LMI_TYPE) || keys.contains(LMI_TIMER)) {
            String lmi = (String)this.get(LMI_TYPE);
            String timer = (String)this.get(LMI_TIMER);
            if (lmi.equals(NONE)) {
                lmi = LMI;
                timer = "0";
            }
            if (lmi != null && lmi.length() > 0 && timer != null && timer.length() > 0) {
                StringBuffer buf = new StringBuffer("set ");
                buf.append(this.m_name);
                buf.append(" ");
                buf.append(lmi);
                buf.append(" ");
                buf.append(timer);
                cmds.addElement(new String(buf));
            }
        }
        if (allCmds || keys.contains(LOCAL_IP)) {
            this.makeSetCommand(cmds, this.m_name, LOCAL_IP, LOCAL_IP);
        }
        if (allCmds || keys.contains(MODEM_CONTROL)) {
            this.makeSetCommand(cmds, this.m_name, MODEM_CONTROL, MODEM_CONTROL);
        }
        if (allCmds || keys.contains(MTU)) {
            this.makeSetCommand(cmds, this.m_name, MTU, MTU);
        }
        if (allCmds || keys.contains(NETMASK)) {
            this.makeSetCommand(cmds, this.m_name, NETMASK, NETMASK);
        }
        if (allCmds || keys.contains(OUTPUT_FILTER)) {
            this.makeSetCommand(cmds, this.m_name, OUTPUT_FILTER, OUTPUT_FILTER);
        }
        if (allCmds || keys.contains(OSPF)) {
            this.makeSetCommand(cmds, this.m_name, OSPF, OSPF);
        }
        if (allCmds || keys.contains(PROTOCOL)) {
            this.makeSetCommand(cmds, this.m_name, PROTOCOL, PROTOCOL);
        }
        if (allCmds || keys.contains(RIP_BROAD) || keys.contains(RIP_LISTEN)) {
            this.makeRIPCommand(cmds, this.m_name, "rip", (String)this.get(RIP_BROAD), (String)this.get(RIP_LISTEN));
        }
        if (allCmds || keys.contains(NETWORK_TYPE)) {
            this.makeTypeCommand(cmds, null, (String)this.get(NETWORK_TYPE), null);
        }
        return cmds.size() > start;
    }
}

